/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.eclipse.core.builder;

import antlr.AntlrTool;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.antlr.eclipse.core.AntlrCorePlugin;
import org.antlr.eclipse.core.AntlrNature;
import org.antlr.eclipse.core.builder.CleaningVisitor;
import org.antlr.eclipse.core.builder.IStreamListener;
import org.antlr.eclipse.core.builder.MonitoredOutputStream;
import org.antlr.eclipse.core.properties.SettingsPersister;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class AntlrBuilder
extends IncrementalProjectBuilder
implements IStreamListener {
    public static final String BUILDER_ID = "org.antlr.eclipse.core.antlrbuilder";
    public static final String DEBUG_OPTION = "org.antlr.eclipse.core/builder/debug";
    public static boolean DEBUG = false;
    private IFile fFile;
    private String fOutput;
    private PrintStream fOriginalOut;
    private PrintStream fOriginalErr;
    public static final QualifiedName CLEAN_WARNINGS = new QualifiedName("org.antlr.eclipse.core", "cleanWarnings");
    public static final QualifiedName INSTALL_SMAP = new QualifiedName("org.antlr.eclipse.core", "installSmap");
    public static final QualifiedName GRAMMAR_ECLIPSE_PROPERTY = new QualifiedName("org.antlr.eclipse.core", "grammar");
    public static final QualifiedName COMMAND_LINE_OPTIONS_PROPERTY = new QualifiedName("org.antlr.eclipse.core", "commandLineOptions");

    public AntlrBuilder() {
        DEBUG = AntlrCorePlugin.isDebug(DEBUG_OPTION);
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        this.getProject().accept((IResourceVisitor)new CleaningVisitor(monitor, null));
    }

    protected IProject[] build(int aKind, Map anArgs, IProgressMonitor aMonitor) throws CoreException {
        IResourceDelta delta;
        IResourceDelta iResourceDelta = delta = aKind != 6 ? this.getDelta(this.getProject()) : null;
        if (delta == null || aKind == 6) {
            IProject project = this.getProject();
            if (AntlrNature.hasNature(project)) {
                project.accept((IResourceVisitor)new Visitor(aMonitor));
            }
        } else {
            delta.accept((IResourceDeltaVisitor)new DeltaVisitor(aMonitor));
        }
        return null;
    }

    public void streamAppended(String aText, Object aStream) {
        if (DEBUG) {
            this.fOriginalOut.println("ANTLR output: " + aText);
        }
        int line = 0;
        String message = null;
        int severity = 0;
        StringTokenizer st = new StringTokenizer(aText, "|");
        if (st.countTokens() > 3) {
            st.nextToken();
            line = Integer.parseInt(st.nextToken());
            Integer.parseInt(st.nextToken());
            message = st.nextToken();
            while (st.hasMoreTokens()) {
                message = String.valueOf(message) + st.nextToken();
            }
            if (message.startsWith("warning:")) {
                severity = 1;
                message = message.substring(8);
            } else {
                severity = 2;
            }
            message = message.replace('\t', ' ').trim();
        } else if (aText.startsWith("panic: ")) {
            message = aText.substring(7);
            severity = 2;
        } else if (aText.startsWith("error: ")) {
            message = aText.substring(7);
            severity = 2;
        } else if (aText.startsWith("warning: ")) {
            severity = 1;
            message = message.substring(9);
        } else if (DEBUG) {
            this.fOriginalOut.println("Unhandled ANTLR output: " + aText);
        }
        if (message != null) {
            this.createProblemMarker(line, message, severity);
        }
    }

    private void createProblemMarker(int aLine, String aMessage, int aSeverity) {
        try {
            IMarker marker = this.fFile.createMarker("org.eclipse.core.resources.problemmarker");
            marker.setAttribute("message", (Object)aMessage);
            marker.setAttribute("severity", aSeverity);
            if (aLine > 0) {
                marker.setAttribute("lineNumber", aLine);
            }
        }
        catch (CoreException e) {
            AntlrCorePlugin.log(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void compileFile(IFile aFile, IProgressMonitor aMonitor) {
        Object var8_12;
        String grammarFileName = aFile.getProjectRelativePath().toString();
        try {
            aFile.getProject().accept((IResourceVisitor)new CleaningVisitor(aMonitor, grammarFileName));
            if (aFile.getProject().hasNature("org.eclipse.jdt.core.javanature")) {
                IProject project = aFile.getProject();
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IPath path = aFile.getFullPath();
                boolean ok = false;
                IClasspathEntry[] resolvedClasspath = javaProject.getResolvedClasspath(true);
                int i = 0;
                while (i < resolvedClasspath.length) {
                    IPath entryPath;
                    IClasspathEntry entry = resolvedClasspath[i];
                    if (entry.getEntryKind() == 3 && (entryPath = entry.getPath()).isPrefixOf(path)) {
                        ok = true;
                        break;
                    }
                    ++i;
                }
                if (!ok) {
                    return;
                }
            }
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        this.fFile = aFile;
        aMonitor.beginTask(AntlrCorePlugin.getFormattedMessage("AntlrBuilder.compiling", aFile.getFullPath().toString()), 4);
        try {
            aFile.deleteMarkers(null, true, 2);
        }
        catch (CoreException e) {
            AntlrCorePlugin.log(e);
        }
        Map map = SettingsPersister.readSettings(aFile.getProject());
        List args = this.createArguments(map, aFile);
        if (DEBUG) {
            System.out.println("Compiling ANTLR grammar '" + aFile.getName() + "': arguments=" + args);
        }
        this.fOriginalOut = System.out;
        this.fOriginalErr = System.err;
        System.setOut(new PrintStream(new MonitoredOutputStream(this)));
        System.setErr(new PrintStream(new MonitoredOutputStream(this)));
        try {
            block19: {
                try {
                    AntlrTool tool = new AntlrTool();
                    if (tool.preprocess(args.toArray(new String[args.size()]))) break block19;
                    try {
                        aMonitor.worked(1);
                        if (!tool.parse()) {
                            aMonitor.worked(1);
                            if (!tool.generate()) {
                                aMonitor.worked(1);
                                this.refreshFolder(map, tool, args, aFile, grammarFileName, ResourcesPlugin.getWorkspace().getRoot().findMember(this.fOutput), aMonitor, tool.getSourceMaps());
                            } else {
                                this.deleteFiles(tool, aFile.getParent(), aMonitor);
                            }
                            aMonitor.worked(1);
                        }
                    }
                    catch (CoreException e) {
                        AntlrCorePlugin.log(e);
                    }
                }
                catch (Throwable e) {
                    if (e instanceof SecurityException) break block19;
                    AntlrCorePlugin.log(e);
                }
            }
            var8_12 = null;
        }
        catch (Throwable throwable) {
            var8_12 = null;
            System.setOut(this.fOriginalOut);
            System.setErr(this.fOriginalErr);
            aMonitor.done();
            throw throwable;
        }
        System.setOut(this.fOriginalOut);
        System.setErr(this.fOriginalErr);
        aMonitor.done();
    }

    private List createArguments(Map map, IFile file) {
        ArrayList<String> args = new ArrayList<String>();
        AntlrCorePlugin.getDefault().upgradeOldSettings((IResource)file, map);
        this.fOutput = SettingsPersister.get(map, (IResource)file, "output");
        String outputPath = null;
        if (this.fOutput != null && this.fOutput.trim().length() > 0) {
            outputPath = this.convertRootRelatedPath(this.fOutput);
        }
        if (outputPath == null) {
            this.fOutput = this.fFile.getParent().getFullPath().toString();
            outputPath = this.fFile.getParent().getLocation().toString();
        }
        args.add("-o");
        args.add(outputPath);
        this.addBooleanGrammarProperty(map, (IResource)file, "debug", "-debug", null, args, false);
        this.addBooleanGrammarProperty(map, (IResource)file, "htmlOutput", "-html", null, args, false);
        this.addBooleanGrammarProperty(map, (IResource)file, "docbookOutput", "-docbook", null, args, false);
        this.addBooleanGrammarProperty(map, (IResource)file, "diagnosticOutput", "-diagnostic", null, args, false);
        this.addBooleanGrammarProperty(map, (IResource)file, "trace", "-trace", null, args, false);
        this.addBooleanGrammarProperty(map, (IResource)file, "traceParser", "-traceParser", null, args, false);
        this.addBooleanGrammarProperty(map, (IResource)file, "traceLexer", "-traceLexer", null, args, false);
        this.addBooleanGrammarProperty(map, (IResource)file, "traceTreeParser", "-traceTreeParser", null, args, false);
        this.addBooleanGrammarProperty(map, (IResource)file, "installSmap", "-smap", null, args, true);
        String superGrammars = SettingsPersister.get(map, (IResource)file, "superGrammars");
        if (superGrammars != null && superGrammars.trim().length() > 0) {
            if ((superGrammars = this.convertRootRelatedPathList(superGrammars)) != null) {
                args.add("-glib");
                args.add(superGrammars);
            }
        } else {
            String localSuperGrammar = this.extractGlibComment(this.fFile);
            if (localSuperGrammar != null && (localSuperGrammar = this.convertFolderRelatedPath(localSuperGrammar)) != null) {
                args.add("-glib");
                args.add(localSuperGrammar);
            }
        }
        args.add(this.fFile.getLocation().toOSString());
        return args;
    }

    private void addBooleanGrammarProperty(Map map, IResource grammar, String propertyName, String option, String option2, List args, boolean defaultValue) {
        String stringValue = SettingsPersister.get(map, grammar, propertyName);
        boolean value = stringValue == null ? defaultValue : "true".equalsIgnoreCase(stringValue);
        if (value) {
            args.add(option);
            if (option2 != null) {
                args.add(option2);
            }
        }
    }

    private String convertRootRelatedPath(String aPath) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember(aPath);
        if (resource == null) {
            this.createProblemMarker(0, AntlrCorePlugin.getFormattedMessage("AntlrTool.error.noGrammarFile", aPath), 2);
        }
        return resource != null ? resource.getLocation().toOSString() : null;
    }

    private String convertRootRelatedPathList(String aPathList) {
        StringBuffer list = new StringBuffer();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        StringTokenizer tokenizer = new StringTokenizer(aPathList, ";");
        while (tokenizer.hasMoreTokens()) {
            String grammar = tokenizer.nextToken();
            IResource resource = root.findMember(grammar);
            if (resource != null) {
                list.append(resource.getLocation().toOSString());
                if (!tokenizer.hasMoreTokens()) continue;
                list.append(';');
                continue;
            }
            this.createProblemMarker(0, AntlrCorePlugin.getFormattedMessage("AntlrTool.error.noGrammarFile", grammar), 2);
        }
        return list.toString();
    }

    private String convertFolderRelatedPath(String aPath) {
        IResource resource = this.fFile.getParent().findMember(aPath.toString());
        if (resource == null) {
            this.createProblemMarker(0, AntlrCorePlugin.getFormattedMessage("AntlrTool.error.noGrammarFile", aPath), 2);
        }
        return resource != null ? resource.getLocation().toOSString() : null;
    }

    private void deleteFiles(AntlrTool aTool, IContainer aFolder, IProgressMonitor aMonitor) {
        Iterator files = aTool.files();
        while (files.hasNext()) {
            IResource file;
            String fileName = (String)files.next();
            if (DEBUG) {
                this.fOriginalOut.println("Deleting ANTLR generated file '" + fileName + "'");
            }
            if ((file = aFolder.findMember(fileName)) == null) continue;
            aMonitor.subTask(AntlrCorePlugin.getFormattedMessage("AntlrBuilder.deleting", fileName));
            try {
                file.delete(true, aMonitor);
            }
            catch (CoreException e) {
                AntlrCorePlugin.log(e);
            }
        }
    }

    private void refreshFolder(Map map, AntlrTool aTool, List args, IFile grammarFile, String grammarFileName, IResource aFolder, IProgressMonitor aMonitor, Map sourceMaps) {
        aMonitor.subTask(AntlrCorePlugin.getFormattedMessage("AntlrBuilder.refreshing", aFolder.getFullPath().toString()));
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IContainer folder = root.getContainerForLocation(aFolder.getLocation());
        if (DEBUG) {
            this.fOriginalOut.println("Refreshing output folder '" + folder.getFullPath() + "'");
        }
        try {
            StringBuffer argString = new StringBuffer();
            Iterator i = args.iterator();
            while (i.hasNext()) {
                String arg = (String)i.next();
                argString.append(arg);
                argString.append("|");
            }
            ArrayList<IFile> compilationUnitFiles = new ArrayList<IFile>();
            Iterator files = aTool.files();
            while (files.hasNext()) {
                String fileName = (String)files.next();
                if (DEBUG) {
                    this.fOriginalOut.println("ANTLR generated file '" + fileName + "'");
                }
                IFile file = folder.getFile((IPath)new Path(fileName));
                file.refreshLocal(0, aMonitor);
                file.setDerived(true);
                String cleanWarnings = SettingsPersister.get(map, (IResource)grammarFile, "cleanWarnings");
                String installSmap = SettingsPersister.get(map, (IResource)grammarFile, "installSmap");
                file.setPersistentProperty(CLEAN_WARNINGS, cleanWarnings);
                file.setPersistentProperty(INSTALL_SMAP, installSmap);
                file.setPersistentProperty(GRAMMAR_ECLIPSE_PROPERTY, grammarFileName);
                file.setPersistentProperty(COMMAND_LINE_OPTIONS_PROPERTY, argString.toString());
                if (!fileName.endsWith(".java")) continue;
                compilationUnitFiles.add(file);
                Map sourceMap = (Map)sourceMaps.get(file.getName());
                if (sourceMap == null) continue;
                Iterator i2 = sourceMap.keySet().iterator();
                while (i2.hasNext()) {
                    Integer sourceLine = (Integer)i2.next();
                    List targetLines = (List)sourceMap.get(sourceLine);
                    Iterator j = targetLines.iterator();
                    while (j.hasNext()) {
                        Integer targetLine = (Integer)j.next();
                        IMarker marker = file.createMarker("org.antlr.eclipse.core.sourceMapMarker");
                        marker.setAttribute("grammarLine", (Object)sourceLine);
                        marker.setAttribute("generatedLine", (Object)targetLine);
                    }
                }
            }
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (Exception e) {
            AntlrCorePlugin.log(e);
        }
    }

    private String extractGlibComment(IFile aFile) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(aFile.getContents()));
            int c = reader.read();
            while (c == 32 || c == 9 || c == 10 || c == 13) {
                c = reader.read();
            }
            if (c == 47 && reader.read() == 47) {
                c = reader.read();
                while (c == 32 || c == 9) {
                    c = reader.read();
                }
                if (c == 45 && reader.read() == 103 && reader.read() == 108 && reader.read() == 105 && reader.read() == 98 && reader.read() == 32) {
                    c = reader.read();
                    while (c == 32 || c == 9) {
                        c = reader.read();
                    }
                    StringBuffer grammar = new StringBuffer();
                    while (c != 10 && c != 13) {
                        grammar.append((char)c);
                        c = reader.read();
                    }
                    return grammar.toString();
                }
            }
        }
        catch (Exception e) {
            AntlrCorePlugin.log(e);
        }
        return null;
    }

    private class Visitor
    implements IResourceVisitor {
        private IProgressMonitor fMonitor;

        public Visitor(IProgressMonitor aMonitor) {
            this.fMonitor = aMonitor;
        }

        public boolean visit(IResource aResource) {
            IFile file;
            if (aResource instanceof IFile && (file = (IFile)aResource).getName().endsWith(".g")) {
                AntlrBuilder.this.compileFile(file, this.fMonitor);
            }
            return true;
        }
    }

    private class DeltaVisitor
    implements IResourceDeltaVisitor {
        private IProgressMonitor fMonitor;

        public DeltaVisitor(IProgressMonitor aMonitor) {
            this.fMonitor = aMonitor;
        }

        public boolean visit(IResourceDelta aDelta) {
            boolean visitChildren = false;
            IResource resource = aDelta.getResource();
            if (resource instanceof IProject) {
                IProject project = (IProject)resource;
                visitChildren = AntlrNature.hasNature(project);
            } else if (resource instanceof IFolder) {
                visitChildren = true;
            } else if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                String ext = file.getFileExtension();
                if (file.exists() && ext != null && ext.equals("g")) {
                    switch (aDelta.getKind()) {
                        case 1: 
                        case 4: {
                            AntlrBuilder.this.compileFile(file, this.fMonitor);
                            visitChildren = true;
                            break;
                        }
                        case 2: {
                            try {
                                String grammarFileName = file.getProjectRelativePath().toString();
                                file.getProject().accept((IResourceVisitor)new CleaningVisitor(this.fMonitor, grammarFileName));
                            }
                            catch (CoreException e) {
                                AntlrCorePlugin.log(e);
                            }
                            visitChildren = true;
                        }
                    }
                }
            }
            return visitChildren;
        }
    }
}

