/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.eclipse.core.builder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import org.antlr.eclipse.core.builder.IStreamListener;

public class MonitoredOutputStream
extends OutputStream {
    private IStreamListener fListener;
    private static final int MAX_SIZE = 1024;
    private Hashtable fBuffers = new Hashtable();
    private boolean fSkip = false;

    public MonitoredOutputStream(IStreamListener aListener) {
        this.fListener = aListener;
    }

    public void write(int aByte) throws IOException {
        byte c = (byte)aByte;
        if (c == 10 || c == 13) {
            if (!this.fSkip) {
                this.processBuffer();
            }
        } else {
            ByteArrayOutputStream buffer = this.getBuffer();
            buffer.write(aByte);
            if (buffer.size() > 1024) {
                this.processBuffer();
            }
        }
        this.fSkip = c == 13;
    }

    public void flush() throws IOException {
        if (this.getBuffer().size() > 0) {
            this.processBuffer();
        }
    }

    public void close() throws IOException {
        this.flush();
    }

    protected void processBuffer() {
        this.fListener.streamAppended(this.getBuffer().toString(), this);
        this.fBuffers.remove(Thread.currentThread());
    }

    private ByteArrayOutputStream getBuffer() {
        Thread current = Thread.currentThread();
        ByteArrayOutputStream buffer = (ByteArrayOutputStream)this.fBuffers.get(current);
        if (buffer == null) {
            buffer = new ByteArrayOutputStream();
            this.fBuffers.put(current, buffer);
        }
        return buffer;
    }
}

