/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.eclipse.core.builder;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.antlr.eclipse.core.AntlrCorePlugin;
import org.antlr.eclipse.core.builder.AntlrBuilder;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class WarningCleanerBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "org.antlr.eclipse.core.warningcleanerbuilder";
    private Map sourceLineCharMappings = new HashMap();

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IProject[] build(int aKind, Map anArgs, IProgressMonitor aMonitor) throws CoreException {
        try {
            IResourceDelta delta;
            IResourceDelta iResourceDelta = delta = aKind != 6 ? this.getDelta(this.getProject()) : null;
            if (delta == null || aKind == 6) {
                IProject project = this.getProject();
                project.accept((IResourceVisitor)new Visitor(aMonitor));
            } else {
                delta.accept((IResourceDeltaVisitor)new DeltaVisitor(aMonitor));
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.sourceLineCharMappings.clear();
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.sourceLineCharMappings.clear();
            return null;
        }
    }

    private void removeWarningMarkers(IResource resource) {
        if (!resource.isDerived()) {
            return;
        }
        try {
            String currentGrammarFileName = resource.getPersistentProperty(AntlrBuilder.GRAMMAR_ECLIPSE_PROPERTY);
            if (currentGrammarFileName == null) {
                return;
            }
            String cleanWarningsString = resource.getPersistentProperty(AntlrBuilder.CLEAN_WARNINGS);
            boolean cleanWarnings = "true".equalsIgnoreCase(cleanWarningsString);
            HashMap<Integer, Integer> sourceMap = new HashMap<Integer, Integer>();
            Integer highestLine = new Integer(0);
            IMarker[] sourceMappingMarkers = resource.findMarkers("org.antlr.eclipse.core.sourceMapMarker", false, 0);
            int i = 0;
            while (i < sourceMappingMarkers.length) {
                Integer sourceLine = (Integer)sourceMappingMarkers[i].getAttribute("grammarLine");
                Integer targetLine = (Integer)sourceMappingMarkers[i].getAttribute("generatedLine");
                sourceMap.put(targetLine, sourceLine);
                if (highestLine.compareTo(sourceLine) < 0) {
                    highestLine = sourceLine;
                }
                ++i;
            }
            IFile grammarFile = resource.getProject().getFile((IPath)new Path(currentGrammarFileName));
            int[] grammarFirstChar = (int[])this.sourceLineCharMappings.get(currentGrammarFileName);
            if (grammarFirstChar == null) {
                grammarFirstChar = this.getFirstCharMapping(highestLine, grammarFile.getContents(true));
            }
            int[] generatedFirstChar = this.getFirstCharMapping(new Integer(1000), ((IFile)resource).getContents(true));
            Integer zero = new Integer(0);
            IMarker[] markers = resource.findMarkers("org.eclipse.jdt.core.problem", false, 0);
            int i2 = 0;
            while (i2 < markers.length) {
                Integer severity = (Integer)markers[i2].getAttribute("severity");
                if (!sourceMap.isEmpty() && severity != null && severity == 2) {
                    IMarker markerCopy = grammarFile.createMarker(markers[i2].getType());
                    HashMap attributes = new HashMap(markers[i2].getAttributes());
                    markerCopy.setAttributes(attributes);
                    Integer targetLine = (Integer)markerCopy.getAttribute("lineNumber");
                    Integer charEnd = (Integer)markerCopy.getAttribute("charEnd");
                    Integer charStart = (Integer)markerCopy.getAttribute("charStart");
                    int targetFirstChar = generatedFirstChar[targetLine];
                    int startOffset = charStart - targetFirstChar;
                    int endOffset = charEnd - targetFirstChar;
                    Integer sourceLine = (Integer)sourceMap.get(targetLine);
                    if (sourceLine == null) {
                        sourceLine = zero;
                    }
                    markerCopy.setAttribute("lineNumber", (Object)sourceLine);
                    int sourceChar = grammarFirstChar[sourceLine];
                    markerCopy.setAttribute("charEnd", (Object)new Integer(sourceChar + startOffset));
                    markerCopy.setAttribute("charStart", (Object)new Integer(sourceChar + endOffset));
                }
                if (cleanWarnings && severity != null && severity == 1) {
                    markers[i2].delete();
                }
                ++i2;
            }
        }
        catch (CoreException e) {
            AntlrCorePlugin.log(e);
        }
    }

    private int[] getFirstCharMapping(Integer highestLine, InputStream contents) throws CoreException {
        int[] firstChar = new int[highestLine.intValue()];
        BufferedInputStream bi = new BufferedInputStream(contents);
        try {
            int c;
            int lineNumber = 1;
            int charNumber = 0;
            int lastChar = -1;
            firstChar = this.ensureCapacity(firstChar, 1);
            firstChar[1] = 1;
            boolean seenNonSpaceForThisLine = false;
            while ((c = bi.read()) != -1) {
                ++charNumber;
                if (lastChar == 13 && c != 10) {
                    firstChar = this.ensureCapacity(firstChar, ++lineNumber);
                    firstChar[lineNumber] = charNumber;
                    seenNonSpaceForThisLine = false;
                }
                if (c == 10) {
                    firstChar = this.ensureCapacity(firstChar, ++lineNumber);
                    firstChar[lineNumber] = charNumber + 1;
                    seenNonSpaceForThisLine = false;
                }
                if (!seenNonSpaceForThisLine && !Character.isWhitespace((char)c)) {
                    firstChar[lineNumber] = charNumber;
                    seenNonSpaceForThisLine = true;
                }
                lastChar = c;
            }
            bi.close();
        }
        catch (IOException iOException) {}
        return firstChar;
    }

    private int[] ensureCapacity(int[] data, int index) {
        if (index >= data.length) {
            int[] newData = new int[data.length + 10];
            System.arraycopy(data, 0, newData, 0, data.length);
            data = newData;
        }
        return data;
    }

    private class Visitor
    implements IResourceVisitor {
        public Visitor(IProgressMonitor aMonitor) {
        }

        public boolean visit(IResource aResource) {
            WarningCleanerBuilder.this.removeWarningMarkers(aResource);
            return true;
        }
    }

    private class DeltaVisitor
    implements IResourceDeltaVisitor {
        public DeltaVisitor(IProgressMonitor aMonitor) {
        }

        public boolean visit(IResourceDelta aDelta) {
            WarningCleanerBuilder.this.removeWarningMarkers(aDelta.getResource());
            return true;
        }
    }
}

