/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.eclipse.core.parser;

import antlr.ANTLRGrammarParseBehavior;
import antlr.ANTLRLexer;
import antlr.ANTLRParser;
import antlr.SemanticException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.Tool;
import antlr.collections.impl.BitSet;
import java.io.Reader;
import java.util.Stack;
import org.antlr.eclipse.core.AntlrCorePlugin;

public class AntlrOverviewParser
implements ANTLRGrammarParseBehavior {
    private StringBuffer fBuffer;
    private Stack fSubRules;
    private SubRule fCurrentSubRule;

    public String parse(Reader aReader) {
        this.fBuffer = new StringBuffer(2000);
        this.fSubRules = new Stack();
        this.fCurrentSubRule = new SubRule();
        ANTLRLexer lexer = new ANTLRLexer(aReader);
        TokenBuffer tokenBuf = new TokenBuffer((TokenStream)lexer);
        ANTLRParser p = new ANTLRParser(tokenBuf, (ANTLRGrammarParseBehavior)this, (Tool)new OverviewTool());
        p.setFilename(".");
        try {
            p.grammar();
        }
        catch (Exception e) {
            AntlrCorePlugin.log(e);
        }
        String text = this.fBuffer.toString();
        this.fBuffer = null;
        this.fSubRules = null;
        this.fCurrentSubRule = null;
        return text;
    }

    public void beginAlt(boolean doAST_) {
        if (this.fSubRules.empty()) {
            this.fBuffer.append("\n\t");
        }
        if (this.fCurrentSubRule.alt > 0) {
            this.fBuffer.append("| ");
        }
        ++this.fCurrentSubRule.alt;
    }

    public void beginSubRule(Token label, Token start, boolean not) {
        if (this.fCurrentSubRule.ref > 0 && this.fSubRules.empty()) {
            this.fBuffer.append("\n\t");
        }
        if (not) {
            this.fBuffer.append('~');
        }
        this.fBuffer.append("( ");
        this.fSubRules.push(this.fCurrentSubRule);
        this.fCurrentSubRule = new SubRule();
    }

    public void defineRuleName(Token r, String access, boolean ruleAST, String docComment) throws SemanticException {
        this.fBuffer.append('\n').append(r.getText()).append(" :");
    }

    public void endRule(String r) {
        if (this.fCurrentSubRule.ref > 0) {
            this.fBuffer.append("\n\t");
        }
        if (!this.fCurrentSubRule.isBracketClosed) {
            this.fBuffer.append('\t');
        }
        this.fBuffer.append(";\n");
        this.fCurrentSubRule.alt = 0;
        this.fCurrentSubRule.ref = 0;
    }

    public void endSubRule() {
        if (!this.fCurrentSubRule.isBracketClosed) {
            this.fBuffer.append(") ");
        }
        this.fCurrentSubRule = (SubRule)this.fSubRules.pop();
        if (this.fSubRules.empty()) {
            this.fBuffer.append("\n\t");
            this.fCurrentSubRule.isBracketClosed = true;
            this.fCurrentSubRule.ref = 0;
        }
    }

    public void oneOrMoreSubRule() {
        this.fBuffer.append(")+ ");
        this.fCurrentSubRule.isBracketClosed = true;
    }

    public void optionalSubRule() {
        this.fBuffer.append(")? ");
        this.fCurrentSubRule.isBracketClosed = true;
    }

    public void zeroOrMoreSubRule() {
        this.fBuffer.append(")* ");
        this.fCurrentSubRule.isBracketClosed = true;
    }

    public void synPred() {
        this.fBuffer.append(") => ");
        this.fCurrentSubRule.isBracketClosed = true;
    }

    public void refCharLiteral(Token lit, Token label, boolean inverted, int autoGenType, boolean lastInRule) {
        if (inverted) {
            this.fBuffer.append('~');
        }
        this.fBuffer.append(lit.getText()).append(' ');
        ++this.fCurrentSubRule.ref;
    }

    public void refCharRange(Token t1, Token t2, Token label, int autoGenType, boolean lastInRule) {
        this.fBuffer.append(t1.getText()).append("..").append(t2.getText()).append(' ');
        ++this.fCurrentSubRule.ref;
    }

    public void refRule(Token idAssign, Token r, Token label, Token arg, int autoGenType) {
        this.fBuffer.append(r.getText()).append(' ');
        ++this.fCurrentSubRule.ref;
    }

    public void refSemPred(Token pred) {
        this.fBuffer.append("{").append(pred.getText()).append("}? ");
        ++this.fCurrentSubRule.ref;
    }

    public void refStringLiteral(Token lit, Token label, int autoGenType, boolean lastInRule) {
        this.fBuffer.append(lit.getText()).append(' ');
        ++this.fCurrentSubRule.ref;
    }

    public void refToken(Token assignId, Token t, Token label, Token args, boolean inverted, int autoGenType, boolean lastInRule) {
        if (inverted) {
            this.fBuffer.append('~');
        }
        this.fBuffer.append(t.getText()).append(' ');
        ++this.fCurrentSubRule.ref;
    }

    public void refTokenRange(Token t1, Token t2, Token label, int autoGenType, boolean lastInRule) {
        this.fBuffer.append(t1.getText()).append("..").append(t2.getText()).append(' ');
        ++this.fCurrentSubRule.ref;
    }

    public void refWildcard(Token t, Token label, int autoGenType) {
        this.fBuffer.append(". ");
        ++this.fCurrentSubRule.ref;
    }

    public void startLexer(String file, Token name, String superClass, String doc) {
        this.startClass(file, name, superClass, doc, "Lexer");
    }

    public void startParser(String file, Token name, String superClass, String doc) {
        this.startClass(file, name, superClass, doc, "Parser");
    }

    public void startTreeWalker(String file, Token name, String superClass, String doc) {
        this.startClass(file, name, superClass, doc, "TreeParser");
    }

    private void startClass(String file, Token name, String superClass, String doc, String className) {
        if (this.fBuffer.length() > 0) {
            this.fBuffer.append("\n\n\n");
        }
        if (doc != null) {
            this.fBuffer.append(doc).append("\n\n");
        }
        this.fBuffer.append("class ").append(name.getText()).append(" extends ").append(className).append(";\n\n");
    }

    public void abortGrammar() {
    }

    public void beginChildList() {
    }

    public void beginExceptionGroup() {
    }

    public void beginExceptionSpec(Token label) {
    }

    public void beginTree(Token tok) throws SemanticException {
    }

    public void defineToken(Token tokname, Token tokliteral) {
    }

    public void endAlt() {
    }

    public void endChildList() {
    }

    public void endExceptionGroup() {
    }

    public void endExceptionSpec() {
    }

    public void endGrammar() {
    }

    public void endOptions() {
    }

    public void endTree() {
    }

    public void hasError() {
    }

    public void noASTSubRule() {
    }

    public void refAction(Token action) {
    }

    public void refArgAction(Token action) {
    }

    public void setUserExceptions(String thr) {
    }

    public void refElementOption(Token option, Token value) {
    }

    public void refTokensSpecElementOption(Token tok, Token option, Token value) {
    }

    public void refExceptionHandler(Token exTypeAndName, Token action) {
    }

    public void refHeaderAction(Token name, Token act) {
    }

    public void refInitAction(Token action) {
    }

    public void refMemberAction(Token act) {
    }

    public void refPreambleAction(Token act) {
    }

    public void refReturnAction(Token returnAction) {
    }

    public void refTreeSpecifier(Token treeSpec) {
    }

    public void setArgOfRuleRef(Token argaction) {
    }

    public void setCharVocabulary(BitSet b) {
    }

    public void setFileOption(Token key, Token value, String filename) {
    }

    public void setGrammarOption(Token key, Token value) {
    }

    public void setRuleOption(Token key, Token value) {
    }

    public void setSubruleOption(Token key, Token value) {
    }

    public void beginRule(Token ruleId, Token lookahead, boolean ruleAutoGen) {
    }

    private class OverviewTool
    extends Tool {
        OverviewTool() {
        }

        public void error(String s, String file, int line, int column) {
        }

        public void error(String s) {
        }

        public void warning(String s, String file, int line, int column) {
        }

        public void warning(String s) {
        }

        public void warning(String[] s, String file, int line, int column) {
        }
    }

    private class SubRule {
        int ref = 0;
        int alt = 0;
        boolean isBracketClosed = false;

        SubRule() {
        }
    }
}

