/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.eclipse.core.parser;

import antlr.Token;
import java.util.Enumeration;
import java.util.Vector;
import org.antlr.eclipse.core.parser.AbstractModel;
import org.antlr.eclipse.core.parser.Block;
import org.antlr.eclipse.core.parser.Grammar;
import org.antlr.eclipse.core.parser.ISegment;
import org.antlr.eclipse.core.parser.ISegmentVisitor;

public class Hierarchy
extends AbstractModel {
    private Block fHeader = null;
    private Block fOptions = null;
    private Vector fGrammars = new Vector();
    private Exception fException = null;

    public Hierarchy(String aName) {
        super(aName, null);
        this.setStartLine(1);
    }

    public boolean hasChildren() {
        return this.fHeader != null || this.fOptions != null || !this.fGrammars.isEmpty();
    }

    public Object[] getChildren() {
        Vector<Block> childs = new Vector<Block>();
        if (this.fHeader != null) {
            childs.add(this.fHeader);
        }
        if (this.fOptions != null) {
            childs.add(this.fOptions);
        }
        childs.addAll(this.fGrammars);
        return childs.toArray();
    }

    public String getUniqueID() {
        return this.getName();
    }

    public boolean accept(ISegmentVisitor aVisitor) {
        boolean more = true;
        Enumeration grammars = this.fGrammars.elements();
        while (grammars.hasMoreElements() && more) {
            more = ((ISegment)grammars.nextElement()).accept(aVisitor);
        }
        if (more && this.fHeader != null) {
            more = aVisitor.visit(this.fHeader);
        }
        if (more && this.fOptions != null) {
            more = aVisitor.visit(this.fOptions);
        }
        return more;
    }

    public void setHeader(Token aToken) {
        this.fHeader = new Block(this, 0, aToken.getLine(), aToken.getColumn());
    }

    public Block getHeader() {
        return this.fHeader;
    }

    public void setOptions(Token aToken) {
        this.fOptions = new Block(this, 1, aToken.getLine(), aToken.getColumn());
    }

    public Block getOptions() {
        return this.fOptions;
    }

    public void addGrammar(Grammar aGrammar) {
        this.fGrammars.add(aGrammar);
    }

    public Enumeration getGrammars() {
        return this.fGrammars.elements();
    }

    public Grammar getLastGrammar() {
        return this.fGrammars.isEmpty() ? null : (Grammar)this.fGrammars.lastElement();
    }

    public void setException(Exception anException) {
        this.fException = anException;
    }

    public Exception getException() {
        return this.fException;
    }

    public String toString() {
        return String.valueOf(this.getUniqueID()) + " [" + this.getStartLine() + ":" + this.getEndLine() + "] with grammar(s) " + this.fGrammars;
    }
}

