/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.eclipse.core.parser;

import antlr.Token;
import java.util.Enumeration;
import java.util.Vector;
import org.antlr.eclipse.core.parser.AbstractModel;
import org.antlr.eclipse.core.parser.Block;
import org.antlr.eclipse.core.parser.Grammar;
import org.antlr.eclipse.core.parser.ISegment;
import org.antlr.eclipse.core.parser.ISegmentVisitor;

public class Rule
extends AbstractModel {
    public static final int PRIVATE = 1;
    public static final int PROTECTED = 2;
    public static final int PUBLIC = 3;
    private int fVisibility;
    private Block fDocComment = null;
    private Block fOptions = null;
    private Block fMemberAction = null;
    private Vector fExceptions = new Vector();
    private boolean fIsExcluded;

    public Rule(Grammar aGrammar, String aName, int aVisibility, int aStartLine) {
        super(aName, aGrammar);
        this.fVisibility = aVisibility;
        this.setStartLine(aStartLine);
        this.setEndLine(aStartLine);
    }

    public boolean hasChildren() {
        return this.fDocComment != null || this.fOptions != null || this.fMemberAction != null || !this.fExceptions.isEmpty();
    }

    public Object[] getChildren() {
        Vector<Block> childs = new Vector<Block>();
        if (this.fDocComment != null) {
            childs.add(this.fDocComment);
        }
        if (this.fOptions != null) {
            childs.add(this.fOptions);
        }
        if (this.fMemberAction != null) {
            childs.add(this.fMemberAction);
        }
        childs.addAll(this.fExceptions);
        return childs.toArray();
    }

    public String getUniqueID() {
        return String.valueOf(((ISegment)this.getParent()).getUniqueID()) + "/Rule:" + this.getName();
    }

    public boolean accept(ISegmentVisitor aVisitor) {
        boolean more = true;
        Enumeration exceptions = this.fExceptions.elements();
        while (exceptions.hasMoreElements() && more) {
            more = ((ISegment)exceptions.nextElement()).accept(aVisitor);
        }
        if (more && this.fDocComment != null) {
            more = aVisitor.visit(this.fDocComment);
        }
        if (more && this.fOptions != null) {
            more = aVisitor.visit(this.fOptions);
        }
        if (more && this.fMemberAction != null) {
            more = aVisitor.visit(this.fMemberAction);
        }
        if (more) {
            more = aVisitor.visit(this);
        }
        return more;
    }

    public int getVisibility() {
        return this.fVisibility;
    }

    public void setIsExcluded(boolean anIsExcluded) {
        this.fIsExcluded = anIsExcluded;
    }

    public boolean isExcluded() {
        return this.fIsExcluded;
    }

    public void setDocComment(Token aToken) {
        this.fDocComment = new Block(this, 4, aToken.getLine(), aToken.getColumn());
    }

    public Block getDocComment() {
        return this.fDocComment;
    }

    public void setOptions(Token aToken) {
        this.fOptions = new Block(this, 1, aToken.getLine(), aToken.getColumn());
    }

    public Block getOptions() {
        return this.fOptions;
    }

    public void setMemberAction(Token aToken) {
        this.fMemberAction = new Block(this, 5, aToken.getLine(), aToken.getColumn());
    }

    public Block getMemberAction() {
        return this.fMemberAction;
    }

    public void addException(Token aToken) {
        this.fExceptions.add(new Block(this, 6, aToken.getLine(), this.getEndLine()));
    }

    public String toString() {
        return String.valueOf(this.getUniqueID()) + " [" + this.getStartLine() + ":" + this.getEndLine() + "]";
    }
}

