/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.eclipse.smapinstaller;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class SDEInstaller {
    static final String nameSDE = "SourceDebugExtension";
    byte[] orig;
    byte[] sdeAttr;
    byte[] gen;
    int origPos = 0;
    int genPos = 0;
    int sdeIndex;

    static void install(File inClassFile, File attrFile, File outClassFile) throws IOException {
        new SDEInstaller(inClassFile, attrFile, outClassFile);
    }

    static void install(File inOutClassFile, File attrFile) throws IOException {
        File tmpFile = new File(String.valueOf(inOutClassFile.getPath()) + "tmp");
        new SDEInstaller(inOutClassFile, attrFile, tmpFile);
        if (!inOutClassFile.delete()) {
            throw new IOException("inOutClassFile.delete() failed");
        }
        if (!tmpFile.renameTo(inOutClassFile)) {
            throw new IOException("tmpFile.renameTo(inOutClassFile) failed");
        }
    }

    static void install(File classFile, byte[] smap) throws IOException {
        File tmpFile = new File(String.valueOf(classFile.getPath()) + "tmp");
        new SDEInstaller(classFile, smap, tmpFile);
        if (!classFile.delete()) {
            throw new IOException("classFile.delete() failed");
        }
        if (!tmpFile.renameTo(classFile)) {
            throw new IOException("tmpFile.renameTo(classFile) failed");
        }
    }

    SDEInstaller(File inClassFile, byte[] sdeAttr, File outClassFile) throws IOException {
        if (!inClassFile.exists()) {
            return;
        }
        this.sdeAttr = sdeAttr;
        this.orig = SDEInstaller.readWhole(inClassFile);
        this.gen = new byte[this.orig.length + sdeAttr.length + 100];
        this.addSDE();
        FileOutputStream outStream = new FileOutputStream(outClassFile);
        outStream.write(this.gen, 0, this.genPos);
        outStream.close();
    }

    SDEInstaller(File inClassFile, File attrFile, File outClassFile) throws IOException {
        this(inClassFile, SDEInstaller.readWhole(attrFile), outClassFile);
    }

    static byte[] readWhole(File input) throws IOException {
        FileInputStream inStream = new FileInputStream(input);
        int len = (int)input.length();
        byte[] bytes = new byte[len];
        if (inStream.read(bytes, 0, len) != len) {
            throw new IOException("expected size: " + len);
        }
        inStream.close();
        return bytes;
    }

    void addSDE() throws UnsupportedEncodingException, IOException {
        this.copy(8);
        int constantPoolCountPos = this.genPos;
        int constantPoolCount = this.readU2();
        this.writeU2(constantPoolCount);
        this.sdeIndex = this.copyConstantPool(constantPoolCount);
        if (this.sdeIndex < 0) {
            this.writeUtf8ForSDE();
            this.sdeIndex = constantPoolCount++;
            this.randomAccessWriteU2(constantPoolCountPos, constantPoolCount);
        }
        this.copy(6);
        int interfaceCount = this.readU2();
        this.writeU2(interfaceCount);
        this.copy(interfaceCount * 2);
        this.copyMembers();
        this.copyMembers();
        int attrCountPos = this.genPos;
        int attrCount = this.readU2();
        this.writeU2(attrCount);
        if (!this.copyAttrs(attrCount)) {
            this.randomAccessWriteU2(attrCountPos, ++attrCount);
        }
        this.writeAttrForSDE(this.sdeIndex);
    }

    void copyMembers() {
        int count = this.readU2();
        this.writeU2(count);
        int i = 0;
        while (i < count) {
            this.copy(6);
            int attrCount = this.readU2();
            this.writeU2(attrCount);
            this.copyAttrs(attrCount);
            ++i;
        }
    }

    boolean copyAttrs(int attrCount) {
        boolean sdeFound = false;
        int i = 0;
        while (i < attrCount) {
            int nameIndex = this.readU2();
            if (nameIndex == this.sdeIndex) {
                sdeFound = true;
            } else {
                this.writeU2(nameIndex);
                int len = this.readU4();
                this.writeU4(len);
                this.copy(len);
            }
            ++i;
        }
        return sdeFound;
    }

    void writeAttrForSDE(int index) {
        this.writeU2(index);
        this.writeU4(this.sdeAttr.length);
        int i = 0;
        while (i < this.sdeAttr.length) {
            this.writeU1(this.sdeAttr[i]);
            ++i;
        }
    }

    void randomAccessWriteU2(int pos, int val) {
        int savePos = this.genPos;
        this.genPos = pos;
        this.writeU2(val);
        this.genPos = savePos;
    }

    int readU1() {
        return this.orig[this.origPos++] & 0xFF;
    }

    int readU2() {
        int res = this.readU1();
        return (res << 8) + this.readU1();
    }

    int readU4() {
        int res = this.readU2();
        return (res << 16) + this.readU2();
    }

    void writeU1(int val) {
        this.gen[this.genPos++] = (byte)val;
    }

    void writeU2(int val) {
        this.writeU1(val >> 8);
        this.writeU1(val & 0xFF);
    }

    void writeU4(int val) {
        this.writeU2(val >> 16);
        this.writeU2(val & 0xFFFF);
    }

    void copy(int count) {
        int i = 0;
        while (i < count) {
            this.gen[this.genPos++] = this.orig[this.origPos++];
            ++i;
        }
    }

    byte[] readBytes(int count) {
        byte[] bytes = new byte[count];
        int i = 0;
        while (i < count) {
            bytes[i] = this.orig[this.origPos++];
            ++i;
        }
        return bytes;
    }

    void writeBytes(byte[] bytes) {
        int i = 0;
        while (i < bytes.length) {
            this.gen[this.genPos++] = bytes[i];
            ++i;
        }
    }

    int copyConstantPool(int constantPoolCount) throws UnsupportedEncodingException, IOException {
        int newSdeIndex = -1;
        int i = 1;
        while (i < constantPoolCount) {
            int tag = this.readU1();
            this.writeU1(tag);
            switch (tag) {
                case 7: 
                case 8: {
                    this.copy(2);
                    break;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    this.copy(4);
                    break;
                }
                case 5: 
                case 6: {
                    this.copy(8);
                    ++i;
                    break;
                }
                case 1: {
                    int len = this.readU2();
                    this.writeU2(len);
                    byte[] utf8 = this.readBytes(len);
                    String str = new String(utf8, "UTF-8");
                    if (str.equals(nameSDE)) {
                        newSdeIndex = i;
                    }
                    this.writeBytes(utf8);
                    break;
                }
                default: {
                    throw new IOException("unexpected tag: " + tag);
                }
            }
            ++i;
        }
        return newSdeIndex;
    }

    void writeUtf8ForSDE() {
        int len = nameSDE.length();
        this.writeU1(1);
        this.writeU2(len);
        int i = 0;
        while (i < len) {
            this.writeU1(nameSDE.charAt(i));
            ++i;
        }
    }
}

