/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.eclipse.smapinstaller;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.antlr.eclipse.core.builder.AntlrBuilder;
import org.antlr.eclipse.smapinstaller.SDEInstaller;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class SMapInstallerBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "org.antlr.eclipse.core.smapbuilder";
    private IResourceDeltaVisitor deltaVisitor = new IResourceDeltaVisitor(){

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (delta.getKind() == 4) {
                SMapInstallerBuilder.this.installSmap(delta.getResource());
            }
            return true;
        }
    };
    private IResourceVisitor visitor = new IResourceVisitor(){

        public boolean visit(IResource resource) {
            try {
                SMapInstallerBuilder.this.installSmap(resource);
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            return true;
        }
    };

    protected void installSmap(IResource resource) throws JavaModelException {
        if (!(resource instanceof IFile)) {
            return;
        }
        IFile smapIFile = (IFile)resource;
        if (!"smap".equalsIgnoreCase(smapIFile.getFileExtension())) {
            return;
        }
        IJavaProject javaProject = JavaCore.create((IProject)smapIFile.getProject());
        IPath smapPath = smapIFile.getFullPath();
        IClasspathEntry[] classpathEntries = javaProject.getResolvedClasspath(true);
        int i = 0;
        int l = classpathEntries.length;
        while (i < l) {
            IClasspathEntry entry = classpathEntries[i];
            if (entry.getEntryKind() == 3 && entry.getPath().isPrefixOf(smapPath)) {
                IPath outputLocation = entry.getOutputLocation();
                if (outputLocation == null) {
                    outputLocation = javaProject.getOutputLocation();
                }
                String sourceDir = entry.getPath().toString();
                String smapName = smapPath.toString();
                String javaSourceName = String.valueOf(smapName.substring(0, smapName.length() - 5)) + ".java";
                String className = String.valueOf(smapName.substring(sourceDir.length(), smapName.length() - 5)) + ".class";
                IPath path = outputLocation.append(className);
                IPath workspaceLoc = ResourcesPlugin.getWorkspace().getRoot().getLocation();
                IPath classFileLocation = workspaceLoc.append(path);
                IResource classResource = ResourcesPlugin.getWorkspace().getRoot().findMember(javaSourceName);
                File classFile = classFileLocation.toFile();
                File smapFile = smapIFile.getLocation().toFile();
                try {
                    String installSmap = classResource.getPersistentProperty(AntlrBuilder.INSTALL_SMAP);
                    if ("true".equals(installSmap)) {
                        SDEInstaller.install(classFile, smapFile);
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6) {
            this.getProject().accept(this.visitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.getProject().accept(this.visitor);
            } else {
                delta.accept(this.deltaVisitor);
            }
        }
        return null;
    }
}

