/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package fr.irisa.cairn.model.polymodel.prdg;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import fr.irisa.cairn.model.integerLinearAlgebra.IntegerLinearAlgebraPackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see fr.irisa.cairn.model.polymodel.prdg.PrdgFactory
 * @model kind="package"
 * @generated
 */
public interface PrdgPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "prdg";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://fr.irisa.cairn.model.polymodel/prdg";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "prdg";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	PrdgPackage eINSTANCE = fr.irisa.cairn.model.polymodel.prdg.impl.PrdgPackageImpl.init();

	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.polymodel.prdg.impl.PRDGNodeImpl <em>PRDG Node</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.polymodel.prdg.impl.PRDGNodeImpl
	 * @see fr.irisa.cairn.model.polymodel.prdg.impl.PrdgPackageImpl#getPRDGNode()
	 * @generated
	 */
	int PRDG_NODE = 0;

	/**
	 * The feature id for the '<em><b>Prdg</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRDG_NODE__PRDG = 0;

	/**
	 * The feature id for the '<em><b>Domain</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRDG_NODE__DOMAIN = 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRDG_NODE__NAME = 2;

	/**
	 * The number of structural features of the '<em>PRDG Node</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRDG_NODE_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.polymodel.prdg.impl.PRDGEdgeImpl <em>PRDG Edge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.polymodel.prdg.impl.PRDGEdgeImpl
	 * @see fr.irisa.cairn.model.polymodel.prdg.impl.PrdgPackageImpl#getPRDGEdge()
	 * @generated
	 */
	int PRDG_EDGE = 1;

	/**
	 * The feature id for the '<em><b>Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRDG_EDGE__SOURCE = 0;

	/**
	 * The feature id for the '<em><b>Destination</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRDG_EDGE__DESTINATION = 1;

	/**
	 * The feature id for the '<em><b>Domain</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRDG_EDGE__DOMAIN = 2;

	/**
	 * The feature id for the '<em><b>Function</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRDG_EDGE__FUNCTION = 3;

	/**
	 * The number of structural features of the '<em>PRDG Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRDG_EDGE_FEATURE_COUNT = 4;

	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.polymodel.prdg.impl.PRDGImpl <em>PRDG</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.polymodel.prdg.impl.PRDGImpl
	 * @see fr.irisa.cairn.model.polymodel.prdg.impl.PrdgPackageImpl#getPRDG()
	 * @generated
	 */
	int PRDG = 2;

	/**
	 * The feature id for the '<em><b>Scope</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRDG__SCOPE = IntegerLinearAlgebraPackage.SCOPE_CONTAINER__SCOPE;

	/**
	 * The feature id for the '<em><b>Nodes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRDG__NODES = IntegerLinearAlgebraPackage.SCOPE_CONTAINER_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Edges</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRDG__EDGES = IntegerLinearAlgebraPackage.SCOPE_CONTAINER_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>PRDG</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRDG_FEATURE_COUNT = IntegerLinearAlgebraPackage.SCOPE_CONTAINER_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.polymodel.prdg.impl.FunctionImpl <em>Function</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.polymodel.prdg.impl.FunctionImpl
	 * @see fr.irisa.cairn.model.polymodel.prdg.impl.PrdgPackageImpl#getFunction()
	 * @generated
	 */
	int FUNCTION = 3;

	/**
	 * The feature id for the '<em><b>Mapping</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION__MAPPING = 0;

	/**
	 * The number of structural features of the '<em>Function</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FUNCTION_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.polymodel.prdg.impl.ProjectionFunctionImpl <em>Projection Function</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.polymodel.prdg.impl.ProjectionFunctionImpl
	 * @see fr.irisa.cairn.model.polymodel.prdg.impl.PrdgPackageImpl#getProjectionFunction()
	 * @generated
	 */
	int PROJECTION_FUNCTION = 4;

	/**
	 * The feature id for the '<em><b>Mapping</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROJECTION_FUNCTION__MAPPING = FUNCTION__MAPPING;

	/**
	 * The number of structural features of the '<em>Projection Function</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROJECTION_FUNCTION_FEATURE_COUNT = FUNCTION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.polymodel.prdg.impl.DependenceFunctionImpl <em>Dependence Function</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.polymodel.prdg.impl.DependenceFunctionImpl
	 * @see fr.irisa.cairn.model.polymodel.prdg.impl.PrdgPackageImpl#getDependenceFunction()
	 * @generated
	 */
	int DEPENDENCE_FUNCTION = 5;

	/**
	 * The feature id for the '<em><b>Mapping</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEPENDENCE_FUNCTION__MAPPING = FUNCTION__MAPPING;

	/**
	 * The number of structural features of the '<em>Dependence Function</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEPENDENCE_FUNCTION_FEATURE_COUNT = FUNCTION_FEATURE_COUNT + 0;


	/**
	 * Returns the meta object for class '{@link fr.irisa.cairn.model.polymodel.prdg.PRDGNode <em>PRDG Node</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>PRDG Node</em>'.
	 * @see fr.irisa.cairn.model.polymodel.prdg.PRDGNode
	 * @generated
	 */
	EClass getPRDGNode();

	/**
	 * Returns the meta object for the container reference '{@link fr.irisa.cairn.model.polymodel.prdg.PRDGNode#getPrdg <em>Prdg</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Prdg</em>'.
	 * @see fr.irisa.cairn.model.polymodel.prdg.PRDGNode#getPrdg()
	 * @see #getPRDGNode()
	 * @generated
	 */
	EReference getPRDGNode_Prdg();

	/**
	 * Returns the meta object for the containment reference '{@link fr.irisa.cairn.model.polymodel.prdg.PRDGNode#getDomain <em>Domain</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Domain</em>'.
	 * @see fr.irisa.cairn.model.polymodel.prdg.PRDGNode#getDomain()
	 * @see #getPRDGNode()
	 * @generated
	 */
	EReference getPRDGNode_Domain();

	/**
	 * Returns the meta object for the attribute '{@link fr.irisa.cairn.model.polymodel.prdg.PRDGNode#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see fr.irisa.cairn.model.polymodel.prdg.PRDGNode#getName()
	 * @see #getPRDGNode()
	 * @generated
	 */
	EAttribute getPRDGNode_Name();

	/**
	 * Returns the meta object for class '{@link fr.irisa.cairn.model.polymodel.prdg.PRDGEdge <em>PRDG Edge</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>PRDG Edge</em>'.
	 * @see fr.irisa.cairn.model.polymodel.prdg.PRDGEdge
	 * @generated
	 */
	EClass getPRDGEdge();

	/**
	 * Returns the meta object for the reference '{@link fr.irisa.cairn.model.polymodel.prdg.PRDGEdge#getSource <em>Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Source</em>'.
	 * @see fr.irisa.cairn.model.polymodel.prdg.PRDGEdge#getSource()
	 * @see #getPRDGEdge()
	 * @generated
	 */
	EReference getPRDGEdge_Source();

	/**
	 * Returns the meta object for the reference '{@link fr.irisa.cairn.model.polymodel.prdg.PRDGEdge#getDestination <em>Destination</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Destination</em>'.
	 * @see fr.irisa.cairn.model.polymodel.prdg.PRDGEdge#getDestination()
	 * @see #getPRDGEdge()
	 * @generated
	 */
	EReference getPRDGEdge_Destination();

	/**
	 * Returns the meta object for the containment reference '{@link fr.irisa.cairn.model.polymodel.prdg.PRDGEdge#getDomain <em>Domain</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Domain</em>'.
	 * @see fr.irisa.cairn.model.polymodel.prdg.PRDGEdge#getDomain()
	 * @see #getPRDGEdge()
	 * @generated
	 */
	EReference getPRDGEdge_Domain();

	/**
	 * Returns the meta object for the containment reference '{@link fr.irisa.cairn.model.polymodel.prdg.PRDGEdge#getFunction <em>Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Function</em>'.
	 * @see fr.irisa.cairn.model.polymodel.prdg.PRDGEdge#getFunction()
	 * @see #getPRDGEdge()
	 * @generated
	 */
	EReference getPRDGEdge_Function();

	/**
	 * Returns the meta object for class '{@link fr.irisa.cairn.model.polymodel.prdg.PRDG <em>PRDG</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>PRDG</em>'.
	 * @see fr.irisa.cairn.model.polymodel.prdg.PRDG
	 * @generated
	 */
	EClass getPRDG();

	/**
	 * Returns the meta object for the containment reference list '{@link fr.irisa.cairn.model.polymodel.prdg.PRDG#getNodes <em>Nodes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Nodes</em>'.
	 * @see fr.irisa.cairn.model.polymodel.prdg.PRDG#getNodes()
	 * @see #getPRDG()
	 * @generated
	 */
	EReference getPRDG_Nodes();

	/**
	 * Returns the meta object for the containment reference list '{@link fr.irisa.cairn.model.polymodel.prdg.PRDG#getEdges <em>Edges</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Edges</em>'.
	 * @see fr.irisa.cairn.model.polymodel.prdg.PRDG#getEdges()
	 * @see #getPRDG()
	 * @generated
	 */
	EReference getPRDG_Edges();

	/**
	 * Returns the meta object for class '{@link fr.irisa.cairn.model.polymodel.prdg.Function <em>Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Function</em>'.
	 * @see fr.irisa.cairn.model.polymodel.prdg.Function
	 * @generated
	 */
	EClass getFunction();

	/**
	 * Returns the meta object for the containment reference '{@link fr.irisa.cairn.model.polymodel.prdg.Function#getMapping <em>Mapping</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Mapping</em>'.
	 * @see fr.irisa.cairn.model.polymodel.prdg.Function#getMapping()
	 * @see #getFunction()
	 * @generated
	 */
	EReference getFunction_Mapping();

	/**
	 * Returns the meta object for class '{@link fr.irisa.cairn.model.polymodel.prdg.ProjectionFunction <em>Projection Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Projection Function</em>'.
	 * @see fr.irisa.cairn.model.polymodel.prdg.ProjectionFunction
	 * @generated
	 */
	EClass getProjectionFunction();

	/**
	 * Returns the meta object for class '{@link fr.irisa.cairn.model.polymodel.prdg.DependenceFunction <em>Dependence Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Dependence Function</em>'.
	 * @see fr.irisa.cairn.model.polymodel.prdg.DependenceFunction
	 * @generated
	 */
	EClass getDependenceFunction();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	PrdgFactory getPrdgFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.polymodel.prdg.impl.PRDGNodeImpl <em>PRDG Node</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.polymodel.prdg.impl.PRDGNodeImpl
		 * @see fr.irisa.cairn.model.polymodel.prdg.impl.PrdgPackageImpl#getPRDGNode()
		 * @generated
		 */
		EClass PRDG_NODE = eINSTANCE.getPRDGNode();

		/**
		 * The meta object literal for the '<em><b>Prdg</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PRDG_NODE__PRDG = eINSTANCE.getPRDGNode_Prdg();

		/**
		 * The meta object literal for the '<em><b>Domain</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PRDG_NODE__DOMAIN = eINSTANCE.getPRDGNode_Domain();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PRDG_NODE__NAME = eINSTANCE.getPRDGNode_Name();

		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.polymodel.prdg.impl.PRDGEdgeImpl <em>PRDG Edge</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.polymodel.prdg.impl.PRDGEdgeImpl
		 * @see fr.irisa.cairn.model.polymodel.prdg.impl.PrdgPackageImpl#getPRDGEdge()
		 * @generated
		 */
		EClass PRDG_EDGE = eINSTANCE.getPRDGEdge();

		/**
		 * The meta object literal for the '<em><b>Source</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PRDG_EDGE__SOURCE = eINSTANCE.getPRDGEdge_Source();

		/**
		 * The meta object literal for the '<em><b>Destination</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PRDG_EDGE__DESTINATION = eINSTANCE.getPRDGEdge_Destination();

		/**
		 * The meta object literal for the '<em><b>Domain</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PRDG_EDGE__DOMAIN = eINSTANCE.getPRDGEdge_Domain();

		/**
		 * The meta object literal for the '<em><b>Function</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PRDG_EDGE__FUNCTION = eINSTANCE.getPRDGEdge_Function();

		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.polymodel.prdg.impl.PRDGImpl <em>PRDG</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.polymodel.prdg.impl.PRDGImpl
		 * @see fr.irisa.cairn.model.polymodel.prdg.impl.PrdgPackageImpl#getPRDG()
		 * @generated
		 */
		EClass PRDG = eINSTANCE.getPRDG();

		/**
		 * The meta object literal for the '<em><b>Nodes</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PRDG__NODES = eINSTANCE.getPRDG_Nodes();

		/**
		 * The meta object literal for the '<em><b>Edges</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PRDG__EDGES = eINSTANCE.getPRDG_Edges();

		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.polymodel.prdg.impl.FunctionImpl <em>Function</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.polymodel.prdg.impl.FunctionImpl
		 * @see fr.irisa.cairn.model.polymodel.prdg.impl.PrdgPackageImpl#getFunction()
		 * @generated
		 */
		EClass FUNCTION = eINSTANCE.getFunction();

		/**
		 * The meta object literal for the '<em><b>Mapping</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FUNCTION__MAPPING = eINSTANCE.getFunction_Mapping();

		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.polymodel.prdg.impl.ProjectionFunctionImpl <em>Projection Function</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.polymodel.prdg.impl.ProjectionFunctionImpl
		 * @see fr.irisa.cairn.model.polymodel.prdg.impl.PrdgPackageImpl#getProjectionFunction()
		 * @generated
		 */
		EClass PROJECTION_FUNCTION = eINSTANCE.getProjectionFunction();

		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.polymodel.prdg.impl.DependenceFunctionImpl <em>Dependence Function</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.polymodel.prdg.impl.DependenceFunctionImpl
		 * @see fr.irisa.cairn.model.polymodel.prdg.impl.PrdgPackageImpl#getDependenceFunction()
		 * @generated
		 */
		EClass DEPENDENCE_FUNCTION = eINSTANCE.getDependenceFunction();

	}

} //PrdgPackage
