package fr.irisa.cairn.model.polymodel.prdg.factory;


import fr.irisa.cairn.model.polymodel.AffineMapping;
import fr.irisa.cairn.model.polymodel.PolyhedralDomain;
import fr.irisa.cairn.model.polymodel.prdg.DependenceFunction;
import fr.irisa.cairn.model.polymodel.prdg.Function;
import fr.irisa.cairn.model.polymodel.prdg.PRDG;
import fr.irisa.cairn.model.polymodel.prdg.PRDGEdge;
import fr.irisa.cairn.model.polymodel.prdg.PRDGNode;
import fr.irisa.cairn.model.polymodel.prdg.PrdgFactory;
import fr.irisa.cairn.model.polymodel.prdg.ProjectionFunction;

public class PRDGUserFactory {

	protected static final PrdgFactory fact = PrdgFactory.eINSTANCE;
	
	public static PRDG createPRDG() {
		return fact.createPRDG();
	}
	
	public static PRDGNode createPRDGNode(String name, PolyhedralDomain domain) {
		PRDGNode node = fact.createPRDGNode();
		node.setName(name);
		node.setDomain(domain);
		return node;
	}
	
	public static PRDGEdge createPRDGEdge(PRDGNode source, PRDGNode dest, PolyhedralDomain domain, Function func) {
		PRDGEdge edge = fact.createPRDGEdge();
		edge.setSource(source);
		edge.setDestination(dest);
		edge.setDomain(domain);
		edge.setFunction(func);
		return edge;
	}
	
	public static DependenceFunction createDependenceFunction(AffineMapping func) {
		DependenceFunction f = fact.createDependenceFunction();
		f.setMapping(func);
		return f;
	}
	
	public static ProjectionFunction createProjectionFunction(AffineMapping func) {
		ProjectionFunction f = fact.createProjectionFunction();
		f.setMapping(func);
		return f;
	}
}
