/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package fr.irisa.cairn.model.polymodel.ada.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import fr.irisa.cairn.jnimap.isl.jni.ISLFactory;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLDataflowAnalysis;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLDimType;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLMap;
import fr.irisa.cairn.jnimap.isl.jni.JNIISLUnionMap;
import fr.irisa.cairn.model.integerLinearAlgebra.IVariable;
import fr.irisa.cairn.model.polymodel.AffineMapping;
import fr.irisa.cairn.model.polymodel.PolyhedralDomain;
import fr.irisa.cairn.model.polymodel.ada.ADAInput;
import fr.irisa.cairn.model.polymodel.ada.AdaPackage;
import fr.irisa.cairn.model.polymodel.ada.CandidateStatement;
import fr.irisa.cairn.model.polymodel.ada.ReadAccess;
import fr.irisa.cairn.model.polymodel.ada.Variable;
import fr.irisa.cairn.model.polymodel.isl.factory.ISLDefaultFactory;
import fr.irisa.cairn.model.polymodel.prdg.PRDG;
import fr.irisa.cairn.model.polymodel.prdg.PRDGEdge;
import fr.irisa.cairn.model.polymodel.prdg.PRDGNode;
import fr.irisa.cairn.model.polymodel.prdg.factory.PRDGUserFactory;
import fr.irisa.cairn.model.polymodel.util.PolyModelToISLString;
import fr.irisa.cairn.model.polymodel.util.PolyModelToISLString.NAMING_SCHEME;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>ADA Input</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link fr.irisa.cairn.model.polymodel.ada.impl.ADAInputImpl#getVariables <em>Variables</em>}</li>
 *   <li>{@link fr.irisa.cairn.model.polymodel.ada.impl.ADAInputImpl#getStatements <em>Statements</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ADAInputImpl extends EObjectImpl implements ADAInput {
	/**
	 * The cached value of the '{@link #getVariables() <em>Variables</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVariables()
	 * @generated
	 * @ordered
	 */
	protected EList<Variable> variables;

	/**
	 * The cached value of the '{@link #getStatements() <em>Statements</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStatements()
	 * @generated
	 * @ordered
	 */
	protected EList<CandidateStatement> statements;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ADAInputImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return AdaPackage.Literals.ADA_INPUT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Variable> getVariables() {
		if (variables == null) {
			variables = new EObjectContainmentEList<Variable>(Variable.class, this, AdaPackage.ADA_INPUT__VARIABLES);
		}
		return variables;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<CandidateStatement> getStatements() {
		if (statements == null) {
			statements = new EObjectContainmentEList<CandidateStatement>(CandidateStatement.class, this, AdaPackage.ADA_INPUT__STATEMENTS);
		}
		return statements;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public PRDG generatePRDG() {

		List<IVariable> params = getStatements().get(0).getDomain().getParams();

		List<PolyModelToISLString.Relation> sinkRelations = new ArrayList<PolyModelToISLString.Relation>();
		List<PolyModelToISLString.Relation> sourceRelations = new ArrayList<PolyModelToISLString.Relation>(getStatements().size());
		List<PolyModelToISLString.Relation> scheduleRelations = new ArrayList<PolyModelToISLString.Relation>(getStatements().size());
		for (CandidateStatement stmt : getStatements()) {
			if (stmt.getWrite() == null) {
				throw new RuntimeException("Statement " + stmt.getID() + " does not have a write access.");
			}
			sourceRelations.add(new PolyModelToISLString.Relation(stmt.getDomain(), stmt.getWrite().getAccessFunction(), stmt.getID(), stmt.getWrite().getVariable().getName()));
			scheduleRelations.add(new PolyModelToISLString.Relation(stmt.getDomain(), stmt.getSchedule(), stmt.getID(), ""));
			
			
			for (ReadAccess read : stmt.getReads()) {
				sinkRelations.add(new PolyModelToISLString.Relation(stmt.getDomain(), read.getAccessFunction(), stmt.getID(), read.getVariable().getName()));
			}
		}

//		NAMING_SCHEME naming = NAMING_SCHEME.GIVEN_NAME;
		NAMING_SCHEME naming = NAMING_SCHEME.DIMENSIONS;
		
		JNIISLUnionMap sinkUmap   = ISLFactory.islUnionMap(PolyModelToISLString.toUnionMap(params, sinkRelations, naming));
		JNIISLUnionMap mustUmap = ISLFactory.islUnionMap(PolyModelToISLString.toUnionMap(params, sourceRelations, naming));
		JNIISLUnionMap mayUmap = ISLFactory.islUnionMap(PolyModelToISLString.toUnionMap(params, new ArrayList<PolyModelToISLString.Relation>(0), naming));
		JNIISLUnionMap scheduleUmap = ISLFactory.islUnionMap(PolyModelToISLString.toUnionMap(params, scheduleRelations, naming));
	
		
//		System.out.println(sinkUmap);
//		System.out.println(mustUmap);
//		System.out.println(mayUmap);
//		System.out.println(scheduleUmap);
//		System.out.println();
		
		JNIISLDataflowAnalysis data = new JNIISLDataflowAnalysis(sinkUmap, mustUmap, mayUmap, scheduleUmap);

//		System.out.println(data.getMay_dep());
//		System.out.println(data.getMust_dep());
//		System.out.println(data.getMay_no_source());
//		System.out.println(data.getMust_no_source());
//		System.out.println();
		
		PRDG prdg = PRDGUserFactory.createPRDG();
		
		for (CandidateStatement stmt : getStatements()) {
			prdg.getNodes().add(PRDGUserFactory.createPRDGNode(stmt.getID(), stmt.getDomain()));
		}
		
		JNIISLUnionMap depQuast = data.getMust_dep().reverse();
		for (JNIISLMap dep : depQuast.getMaps()) {
			
			PRDGNode consumer = prdg.getNode(dep.getTupleName(JNIISLDimType.isl_dim_in));
			PRDGNode producer = prdg.getNode(dep.getTupleName(JNIISLDimType.isl_dim_out));
			
			AffineMapping map = ISLDefaultFactory.INSTANCE.affineMapping(dep, params, consumer.getDomain().getIndices());
			PolyhedralDomain dom = ISLDefaultFactory.INSTANCE.polyhedralDomainFromMap(dep.reverse(), params, consumer.getDomain().getIndices());
			PRDGEdge edge = PRDGUserFactory.createPRDGEdge(consumer, producer, dom, PRDGUserFactory.createDependenceFunction(map));
			prdg.getEdges().add(edge);
		}
		
		System.out.println(prdg);
		
		return prdg;
	}

	/**
	 * <!-- begin-user-doc -->
	 * Performs O(n) search to find the statement with the given name.
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public CandidateStatement getStatement(String id) {
		for (CandidateStatement stmt : getStatements()) {
			if (stmt.getID().contentEquals(id)) {
				return stmt;
			}
		}
		
		throw new RuntimeException("Statement : " + id  + " not found.");
	}

	/**
	 * <!-- begin-user-doc -->
	 * Performs O(n) search to find the variable with the given name. 
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public Variable getVariable(String name) {
		for (Variable var : getVariables()) {
			if (var.getName().contentEquals(name)) {
				return var;
			}
		}
		
		throw new RuntimeException("Variable : " + name  + " not found.");
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case AdaPackage.ADA_INPUT__VARIABLES:
				return ((InternalEList<?>)getVariables()).basicRemove(otherEnd, msgs);
			case AdaPackage.ADA_INPUT__STATEMENTS:
				return ((InternalEList<?>)getStatements()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case AdaPackage.ADA_INPUT__VARIABLES:
				return getVariables();
			case AdaPackage.ADA_INPUT__STATEMENTS:
				return getStatements();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case AdaPackage.ADA_INPUT__VARIABLES:
				getVariables().clear();
				getVariables().addAll((Collection<? extends Variable>)newValue);
				return;
			case AdaPackage.ADA_INPUT__STATEMENTS:
				getStatements().clear();
				getStatements().addAll((Collection<? extends CandidateStatement>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case AdaPackage.ADA_INPUT__VARIABLES:
				getVariables().clear();
				return;
			case AdaPackage.ADA_INPUT__STATEMENTS:
				getStatements().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case AdaPackage.ADA_INPUT__VARIABLES:
				return variables != null && !variables.isEmpty();
			case AdaPackage.ADA_INPUT__STATEMENTS:
				return statements != null && !statements.isEmpty();
		}
		return super.eIsSet(featureID);
	}
	
	@Override
	public String toString() {
		StringBuffer sb = new StringBuffer("---- ADAInput ----\n");
		
		for (CandidateStatement cand : getStatements()) {
			sb.append(cand.toString());
			sb.append("\n");
		}
		
		return sb.toString();
	}

} //ADAInputImpl
