package fr.irisa.cairn.model.polymodel.ada.tests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import junit.framework.TestCase;

import org.junit.Test;

import fr.irisa.cairn.model.polymodel.ada.ADAInput;
import fr.irisa.cairn.model.polymodel.ada.CandidateStatement;
import fr.irisa.cairn.model.polymodel.ada.ReadAccess;
import fr.irisa.cairn.model.polymodel.ada.Variable;
import fr.irisa.cairn.model.polymodel.ada.WriteAccess;
import fr.irisa.cairn.model.polymodel.ada.factory.ADAUserFactory;
import fr.irisa.cairn.model.polymodel.isl.factory.ISLDefaultFactory;
import fr.irisa.cairn.model.polymodel.prdg.PRDG;

public class ADATests extends TestCase {
	
	@Test
	public void test1() {
		matrix_multiply();
	}

	@Test
	public void test2() {
		String[][] statements = new String[][] {
				new String[] {"S0", "[N] -> { [i,j] : 0<=i<N & 0<=j<N }", 
									"[N] -> { [i,j] -> [0,i,0,j,0,0,0]}"},
				new String[] {"S1", "[N] -> { [i,j,k] : 0<=i<N & 0<=j<N & 0<=k<N }", 
									"[N] -> { [i,j,k] -> [0,i,0,j,1,k,0] }"}
			};
		String[][] reads = new String[][] {
				new String[] {"S1", "A", "[N] -> { [i,j,k] -> [i,k]}"},
				new String[] {"S1", "B", "[N] -> { [i,j,k] -> [k,j]}"},
				new String[] {"S1", "C", "[N] -> { [i,j,k] -> [i,j]}"}
			};
		String[][] writes = new String[][] {
				new String[] {"S0", "C", "[N] -> { [i,j] -> [i,j]}"},
				new String[] {"S1", "C", "[N] -> { [i,j,k] -> [i,j]}"}
			};
		
		createPRDGfromADAInput(statements, reads, writes);
	}
	
	private void createPRDGfromADAInput(String[][] statements, String[][] reads, String[][] writes) {
		ADAInput input = ADAUserFactory.createADAInputFromStrings(statements, reads, writes);
		System.out.println(input);
		PRDG prdg = input.generatePRDG();
		assertNotNull(prdg);
		
	}
	
	@SuppressWarnings("serial")
	private void matrix_multiply() {
		ADAInput input = ADAUserFactory.createADAInput();
		Variable A = ADAUserFactory.createVariable("A");
		Variable B = ADAUserFactory.createVariable("B");
		Variable C = ADAUserFactory.createVariable("C");
		input.getVariables().add(A);
		input.getVariables().add(B);
		input.getVariables().add(C);

		List<String> params = new ArrayList<String>(1) { {add("N");} };

		//S0
		{
			List<String> indices = new ArrayList<String>(3) { {add("i"); add("j");} };
			CandidateStatement S0 = ADAUserFactory.createCandidateStatement("S0", 
					ISLDefaultFactory.INSTANCE.polyhedralDomainFromString(params, indices,
							new ArrayList<String>() { {
								add("0<=i");add("i<N");
								add("0<=j");add("j<N");
						} }),
					ISLDefaultFactory.INSTANCE.affineMappingFromString(params, indices, 
							new ArrayList<String>() { {
								add("i"); add("j"); add("0"); add("0");
						} }));
			input.getStatements().add(S0);
		
			WriteAccess write = ADAUserFactory.createWriteAccess(C, 
				ISLDefaultFactory.INSTANCE.affineMappingFromString(params, indices, 
						new ArrayList<String>() { {
							add("i"); add("j");
					} }));
			S0.setWrite(write);
		}


		//S1
		{
			List<String> indices = new ArrayList<String>(3) { {add("i"); add("j"); add("k");} };
			CandidateStatement S1 = ADAUserFactory.createCandidateStatement("S1", 
					ISLDefaultFactory.INSTANCE.polyhedralDomainFromString(params, indices,
							new ArrayList<String>() { {
								add("0<=i");add("i<N");
								add("0<=j");add("j<N");
								add("0<=k");add("k<N");
						} }),
					ISLDefaultFactory.INSTANCE.affineMappingFromString(params, indices, 
							new ArrayList<String>() { {
								add("i"); add("j"); add("1"); add("k");
						} }));
			
			input.getStatements().add(S1);
		
			WriteAccess write = ADAUserFactory.createWriteAccess(C, 
					ISLDefaultFactory.INSTANCE.affineMappingFromString(params, indices, 
							new ArrayList<String>() { {
								add("i"); add("j");
						} }));
			
			ReadAccess readA = ADAUserFactory.createReadAccess(A, 
					ISLDefaultFactory.INSTANCE.affineMappingFromString(params, indices, 
							new ArrayList<String>() { {
								add("i"); add("k");
						} }));
			
			ReadAccess readB = ADAUserFactory.createReadAccess(B, 
					ISLDefaultFactory.INSTANCE.affineMappingFromString(params, indices, 
							new ArrayList<String>() { {
								add("k"); add("j");
						} }));
			
			ReadAccess readC = ADAUserFactory.createReadAccess(C, 
					ISLDefaultFactory.INSTANCE.affineMappingFromString(params, indices, 
							new ArrayList<String>() { {
								add("i"); add("j");
						} }));
			
			S1.setWrite(write);
			S1.getReads().add(readA);
			S1.getReads().add(readB);
			S1.getReads().add(readC);
		}
		
		System.out.println(input);
		PRDG prdg = input.generatePRDG();
		assertNotNull(prdg);
	}

}
