package org.polymodel.verifier;

import org.eclipse.emf.ecore.EObject;

import fr.irisa.cairn.model.polymodel.AffineMapping;

/**
 * Memory Allocation have mapping and also the name of the array that it maps to.
 * The mapping is expressed as an affine function (+ mod factors currently not supported)
 * The target is distinguished by some object of users choice, when a.target.equals(b.target), two MemoryMaps a,b points to the same array
 * 
 * @author yuki
 *
 */
public interface MemoryMap extends EObject {

	/**
	 * Returns the value of the '<em><b>Mapping</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Mapping</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Mapping</em>' containment reference.
	 * @see #setMapping(AffineMapping)
	 * @see org.polymodel.verifier.VerifierPackage#getMemoryMap_Mapping()
	 * @model containment="true" required="true"
	 * @generated
	 */
	AffineMapping getMapping();

	/**
	 * Sets the value of the '{@link org.polymodel.verifier.MemoryMap#getMapping <em>Mapping</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Mapping</em>' containment reference.
	 * @see #getMapping()
	 * @generated
	 */
	void setMapping(AffineMapping value);

	/**
	 * Returns the value of the '<em><b>Target</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Target</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Target</em>' attribute.
	 * @see #setTarget(Object)
	 * @see org.polymodel.verifier.VerifierPackage#getMemoryMap_Target()
	 * @model dataType="org.polymodel.verifier.Object" required="true"
	 * @generated
	 */
	Object getTarget();

	/**
	 * Sets the value of the '{@link org.polymodel.verifier.MemoryMap#getTarget <em>Target</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Target</em>' attribute.
	 * @see #getTarget()
	 * @generated
	 */
	void setTarget(Object value);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model required="true"
	 * @generated
	 */
	String toCArrayAccess();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model required="true" dependenceRequired="true"
	 * @generated
	 */
	String toCArrayAccess(AffineMapping dependence);
}
