/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.polymodel.verifier;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.polymodel.verifier.VerifierFactory
 * @model kind="package"
 * @generated
 */
public interface VerifierPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "verifier";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://polymodel/verifier";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "verifier";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	VerifierPackage eINSTANCE = org.polymodel.verifier.impl.VerifierPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.polymodel.verifier.impl.MemoryMapImpl <em>Memory Map</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.polymodel.verifier.impl.MemoryMapImpl
	 * @see org.polymodel.verifier.impl.VerifierPackageImpl#getMemoryMap()
	 * @generated
	 */
	int MEMORY_MAP = 0;

	/**
	 * The feature id for the '<em><b>Mapping</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_MAP__MAPPING = 0;

	/**
	 * The feature id for the '<em><b>Target</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_MAP__TARGET = 1;

	/**
	 * The number of structural features of the '<em>Memory Map</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_MAP_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.polymodel.verifier.impl.VerifierOutputImpl <em>Output</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.polymodel.verifier.impl.VerifierOutputImpl
	 * @see org.polymodel.verifier.impl.VerifierPackageImpl#getVerifierOutput()
	 * @generated
	 */
	int VERIFIER_OUTPUT = 1;

	/**
	 * The feature id for the '<em><b>Messages</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERIFIER_OUTPUT__MESSAGES = 0;

	/**
	 * The feature id for the '<em><b>Valid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERIFIER_OUTPUT__VALID = 1;

	/**
	 * The feature id for the '<em><b>Input</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERIFIER_OUTPUT__INPUT = 2;

	/**
	 * The number of structural features of the '<em>Output</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERIFIER_OUTPUT_FEATURE_COUNT = 3;


	/**
	 * The meta object id for the '{@link org.polymodel.verifier.impl.EdgeFunctionImpl <em>Edge Function</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.polymodel.verifier.impl.EdgeFunctionImpl
	 * @see org.polymodel.verifier.impl.VerifierPackageImpl#getEdgeFunction()
	 * @generated
	 */
	int EDGE_FUNCTION = 2;

	/**
	 * The feature id for the '<em><b>Mapping</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDGE_FUNCTION__MAPPING = 0;

	/**
	 * The number of structural features of the '<em>Edge Function</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDGE_FUNCTION_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.polymodel.verifier.impl.VerifierInputImpl <em>Input</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.polymodel.verifier.impl.VerifierInputImpl
	 * @see org.polymodel.verifier.impl.VerifierPackageImpl#getVerifierInput()
	 * @generated
	 */
	int VERIFIER_INPUT = 3;

	/**
	 * The feature id for the '<em><b>Nodes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERIFIER_INPUT__NODES = 0;

	/**
	 * The feature id for the '<em><b>Edges</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERIFIER_INPUT__EDGES = 1;

	/**
	 * The number of structural features of the '<em>Input</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERIFIER_INPUT_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.polymodel.verifier.impl.VerifierEdgeImpl <em>Edge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.polymodel.verifier.impl.VerifierEdgeImpl
	 * @see org.polymodel.verifier.impl.VerifierPackageImpl#getVerifierEdge()
	 * @generated
	 */
	int VERIFIER_EDGE = 4;

	/**
	 * The feature id for the '<em><b>Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERIFIER_EDGE__SOURCE = 0;

	/**
	 * The feature id for the '<em><b>Destination</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERIFIER_EDGE__DESTINATION = 1;

	/**
	 * The feature id for the '<em><b>Domain</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERIFIER_EDGE__DOMAIN = 2;

	/**
	 * The feature id for the '<em><b>Function</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERIFIER_EDGE__FUNCTION = 3;

	/**
	 * The number of structural features of the '<em>Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERIFIER_EDGE_FEATURE_COUNT = 4;

	/**
	 * The meta object id for the '{@link org.polymodel.verifier.impl.VerifierNodeImpl <em>Node</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.polymodel.verifier.impl.VerifierNodeImpl
	 * @see org.polymodel.verifier.impl.VerifierPackageImpl#getVerifierNode()
	 * @generated
	 */
	int VERIFIER_NODE = 5;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERIFIER_NODE__NAME = 0;

	/**
	 * The feature id for the '<em><b>Domain</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERIFIER_NODE__DOMAIN = 1;

	/**
	 * The feature id for the '<em><b>Space Time Map</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERIFIER_NODE__SPACE_TIME_MAP = 2;

	/**
	 * The feature id for the '<em><b>Memory Map</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERIFIER_NODE__MEMORY_MAP = 3;

	/**
	 * The feature id for the '<em><b>Dimension Types</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERIFIER_NODE__DIMENSION_TYPES = 4;

	/**
	 * The number of structural features of the '<em>Node</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERIFIER_NODE_FEATURE_COUNT = 5;

	/**
	 * The meta object id for the '{@link org.polymodel.verifier.impl.ProjectionFunctionImpl <em>Projection Function</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.polymodel.verifier.impl.ProjectionFunctionImpl
	 * @see org.polymodel.verifier.impl.VerifierPackageImpl#getProjectionFunction()
	 * @generated
	 */
	int PROJECTION_FUNCTION = 6;

	/**
	 * The feature id for the '<em><b>Mapping</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROJECTION_FUNCTION__MAPPING = EDGE_FUNCTION__MAPPING;

	/**
	 * The number of structural features of the '<em>Projection Function</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROJECTION_FUNCTION_FEATURE_COUNT = EDGE_FUNCTION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.polymodel.verifier.impl.DependenceFunctionImpl <em>Dependence Function</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.polymodel.verifier.impl.DependenceFunctionImpl
	 * @see org.polymodel.verifier.impl.VerifierPackageImpl#getDependenceFunction()
	 * @generated
	 */
	int DEPENDENCE_FUNCTION = 7;

	/**
	 * The feature id for the '<em><b>Mapping</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEPENDENCE_FUNCTION__MAPPING = EDGE_FUNCTION__MAPPING;

	/**
	 * The number of structural features of the '<em>Dependence Function</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEPENDENCE_FUNCTION_FEATURE_COUNT = EDGE_FUNCTION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.polymodel.verifier.VERBOSITY <em>VERBOSITY</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.polymodel.verifier.VERBOSITY
	 * @see org.polymodel.verifier.impl.VerifierPackageImpl#getVERBOSITY()
	 * @generated
	 */
	int VERBOSITY = 8;


	/**
	 * The meta object id for the '{@link org.polymodel.verifier.DIM_TYPE <em>DIM TYPE</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.polymodel.verifier.DIM_TYPE
	 * @see org.polymodel.verifier.impl.VerifierPackageImpl#getDIM_TYPE()
	 * @generated
	 */
	int DIM_TYPE = 9;

	/**
	 * The meta object id for the '<em>Object</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see java.lang.Object
	 * @see org.polymodel.verifier.impl.VerifierPackageImpl#getObject()
	 * @generated
	 */
	int OBJECT = 10;


	/**
	 * Returns the meta object for class '{@link org.polymodel.verifier.MemoryMap <em>Memory Map</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Memory Map</em>'.
	 * @see org.polymodel.verifier.MemoryMap
	 * @generated
	 */
	EClass getMemoryMap();

	/**
	 * Returns the meta object for the containment reference '{@link org.polymodel.verifier.MemoryMap#getMapping <em>Mapping</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Mapping</em>'.
	 * @see org.polymodel.verifier.MemoryMap#getMapping()
	 * @see #getMemoryMap()
	 * @generated
	 */
	EReference getMemoryMap_Mapping();

	/**
	 * Returns the meta object for the attribute '{@link org.polymodel.verifier.MemoryMap#getTarget <em>Target</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Target</em>'.
	 * @see org.polymodel.verifier.MemoryMap#getTarget()
	 * @see #getMemoryMap()
	 * @generated
	 */
	EAttribute getMemoryMap_Target();

	/**
	 * Returns the meta object for class '{@link org.polymodel.verifier.VerifierOutput <em>Output</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Output</em>'.
	 * @see org.polymodel.verifier.VerifierOutput
	 * @generated
	 */
	EClass getVerifierOutput();

	/**
	 * Returns the meta object for the reference list '{@link org.polymodel.verifier.VerifierOutput#getMessages <em>Messages</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Messages</em>'.
	 * @see org.polymodel.verifier.VerifierOutput#getMessages()
	 * @see #getVerifierOutput()
	 * @generated
	 */
	EReference getVerifierOutput_Messages();

	/**
	 * Returns the meta object for the attribute '{@link org.polymodel.verifier.VerifierOutput#isValid <em>Valid</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Valid</em>'.
	 * @see org.polymodel.verifier.VerifierOutput#isValid()
	 * @see #getVerifierOutput()
	 * @generated
	 */
	EAttribute getVerifierOutput_Valid();

	/**
	 * Returns the meta object for the reference '{@link org.polymodel.verifier.VerifierOutput#getInput <em>Input</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Input</em>'.
	 * @see org.polymodel.verifier.VerifierOutput#getInput()
	 * @see #getVerifierOutput()
	 * @generated
	 */
	EReference getVerifierOutput_Input();

	/**
	 * Returns the meta object for class '{@link org.polymodel.verifier.EdgeFunction <em>Edge Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Edge Function</em>'.
	 * @see org.polymodel.verifier.EdgeFunction
	 * @generated
	 */
	EClass getEdgeFunction();

	/**
	 * Returns the meta object for the containment reference '{@link org.polymodel.verifier.EdgeFunction#getMapping <em>Mapping</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Mapping</em>'.
	 * @see org.polymodel.verifier.EdgeFunction#getMapping()
	 * @see #getEdgeFunction()
	 * @generated
	 */
	EReference getEdgeFunction_Mapping();

	/**
	 * Returns the meta object for class '{@link org.polymodel.verifier.VerifierInput <em>Input</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Input</em>'.
	 * @see org.polymodel.verifier.VerifierInput
	 * @generated
	 */
	EClass getVerifierInput();

	/**
	 * Returns the meta object for the containment reference list '{@link org.polymodel.verifier.VerifierInput#getNodes <em>Nodes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Nodes</em>'.
	 * @see org.polymodel.verifier.VerifierInput#getNodes()
	 * @see #getVerifierInput()
	 * @generated
	 */
	EReference getVerifierInput_Nodes();

	/**
	 * Returns the meta object for the containment reference list '{@link org.polymodel.verifier.VerifierInput#getEdges <em>Edges</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Edges</em>'.
	 * @see org.polymodel.verifier.VerifierInput#getEdges()
	 * @see #getVerifierInput()
	 * @generated
	 */
	EReference getVerifierInput_Edges();

	/**
	 * Returns the meta object for class '{@link org.polymodel.verifier.VerifierEdge <em>Edge</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Edge</em>'.
	 * @see org.polymodel.verifier.VerifierEdge
	 * @generated
	 */
	EClass getVerifierEdge();

	/**
	 * Returns the meta object for the reference '{@link org.polymodel.verifier.VerifierEdge#getSource <em>Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Source</em>'.
	 * @see org.polymodel.verifier.VerifierEdge#getSource()
	 * @see #getVerifierEdge()
	 * @generated
	 */
	EReference getVerifierEdge_Source();

	/**
	 * Returns the meta object for the reference '{@link org.polymodel.verifier.VerifierEdge#getDestination <em>Destination</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Destination</em>'.
	 * @see org.polymodel.verifier.VerifierEdge#getDestination()
	 * @see #getVerifierEdge()
	 * @generated
	 */
	EReference getVerifierEdge_Destination();

	/**
	 * Returns the meta object for the containment reference '{@link org.polymodel.verifier.VerifierEdge#getDomain <em>Domain</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Domain</em>'.
	 * @see org.polymodel.verifier.VerifierEdge#getDomain()
	 * @see #getVerifierEdge()
	 * @generated
	 */
	EReference getVerifierEdge_Domain();

	/**
	 * Returns the meta object for the containment reference '{@link org.polymodel.verifier.VerifierEdge#getFunction <em>Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Function</em>'.
	 * @see org.polymodel.verifier.VerifierEdge#getFunction()
	 * @see #getVerifierEdge()
	 * @generated
	 */
	EReference getVerifierEdge_Function();

	/**
	 * Returns the meta object for class '{@link org.polymodel.verifier.VerifierNode <em>Node</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Node</em>'.
	 * @see org.polymodel.verifier.VerifierNode
	 * @generated
	 */
	EClass getVerifierNode();

	/**
	 * Returns the meta object for the attribute '{@link org.polymodel.verifier.VerifierNode#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.polymodel.verifier.VerifierNode#getName()
	 * @see #getVerifierNode()
	 * @generated
	 */
	EAttribute getVerifierNode_Name();

	/**
	 * Returns the meta object for the containment reference '{@link org.polymodel.verifier.VerifierNode#getDomain <em>Domain</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Domain</em>'.
	 * @see org.polymodel.verifier.VerifierNode#getDomain()
	 * @see #getVerifierNode()
	 * @generated
	 */
	EReference getVerifierNode_Domain();

	/**
	 * Returns the meta object for the containment reference '{@link org.polymodel.verifier.VerifierNode#getSpaceTimeMap <em>Space Time Map</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Space Time Map</em>'.
	 * @see org.polymodel.verifier.VerifierNode#getSpaceTimeMap()
	 * @see #getVerifierNode()
	 * @generated
	 */
	EReference getVerifierNode_SpaceTimeMap();

	/**
	 * Returns the meta object for the containment reference '{@link org.polymodel.verifier.VerifierNode#getMemoryMap <em>Memory Map</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Memory Map</em>'.
	 * @see org.polymodel.verifier.VerifierNode#getMemoryMap()
	 * @see #getVerifierNode()
	 * @generated
	 */
	EReference getVerifierNode_MemoryMap();

	/**
	 * Returns the meta object for the attribute list '{@link org.polymodel.verifier.VerifierNode#getDimensionTypes <em>Dimension Types</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Dimension Types</em>'.
	 * @see org.polymodel.verifier.VerifierNode#getDimensionTypes()
	 * @see #getVerifierNode()
	 * @generated
	 */
	EAttribute getVerifierNode_DimensionTypes();

	/**
	 * Returns the meta object for class '{@link org.polymodel.verifier.ProjectionFunction <em>Projection Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Projection Function</em>'.
	 * @see org.polymodel.verifier.ProjectionFunction
	 * @generated
	 */
	EClass getProjectionFunction();

	/**
	 * Returns the meta object for class '{@link org.polymodel.verifier.DependenceFunction <em>Dependence Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Dependence Function</em>'.
	 * @see org.polymodel.verifier.DependenceFunction
	 * @generated
	 */
	EClass getDependenceFunction();

	/**
	 * Returns the meta object for enum '{@link org.polymodel.verifier.VERBOSITY <em>VERBOSITY</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>VERBOSITY</em>'.
	 * @see org.polymodel.verifier.VERBOSITY
	 * @generated
	 */
	EEnum getVERBOSITY();

	/**
	 * Returns the meta object for enum '{@link org.polymodel.verifier.DIM_TYPE <em>DIM TYPE</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>DIM TYPE</em>'.
	 * @see org.polymodel.verifier.DIM_TYPE
	 * @generated
	 */
	EEnum getDIM_TYPE();

	/**
	 * Returns the meta object for data type '{@link java.lang.Object <em>Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Object</em>'.
	 * @see java.lang.Object
	 * @model instanceClass="java.lang.Object"
	 * @generated
	 */
	EDataType getObject();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	VerifierFactory getVerifierFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.polymodel.verifier.impl.MemoryMapImpl <em>Memory Map</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.polymodel.verifier.impl.MemoryMapImpl
		 * @see org.polymodel.verifier.impl.VerifierPackageImpl#getMemoryMap()
		 * @generated
		 */
		EClass MEMORY_MAP = eINSTANCE.getMemoryMap();

		/**
		 * The meta object literal for the '<em><b>Mapping</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MEMORY_MAP__MAPPING = eINSTANCE.getMemoryMap_Mapping();

		/**
		 * The meta object literal for the '<em><b>Target</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MEMORY_MAP__TARGET = eINSTANCE.getMemoryMap_Target();

		/**
		 * The meta object literal for the '{@link org.polymodel.verifier.impl.VerifierOutputImpl <em>Output</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.polymodel.verifier.impl.VerifierOutputImpl
		 * @see org.polymodel.verifier.impl.VerifierPackageImpl#getVerifierOutput()
		 * @generated
		 */
		EClass VERIFIER_OUTPUT = eINSTANCE.getVerifierOutput();

		/**
		 * The meta object literal for the '<em><b>Messages</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VERIFIER_OUTPUT__MESSAGES = eINSTANCE.getVerifierOutput_Messages();

		/**
		 * The meta object literal for the '<em><b>Valid</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute VERIFIER_OUTPUT__VALID = eINSTANCE.getVerifierOutput_Valid();

		/**
		 * The meta object literal for the '<em><b>Input</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VERIFIER_OUTPUT__INPUT = eINSTANCE.getVerifierOutput_Input();

		/**
		 * The meta object literal for the '{@link org.polymodel.verifier.impl.EdgeFunctionImpl <em>Edge Function</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.polymodel.verifier.impl.EdgeFunctionImpl
		 * @see org.polymodel.verifier.impl.VerifierPackageImpl#getEdgeFunction()
		 * @generated
		 */
		EClass EDGE_FUNCTION = eINSTANCE.getEdgeFunction();

		/**
		 * The meta object literal for the '<em><b>Mapping</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EDGE_FUNCTION__MAPPING = eINSTANCE.getEdgeFunction_Mapping();

		/**
		 * The meta object literal for the '{@link org.polymodel.verifier.impl.VerifierInputImpl <em>Input</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.polymodel.verifier.impl.VerifierInputImpl
		 * @see org.polymodel.verifier.impl.VerifierPackageImpl#getVerifierInput()
		 * @generated
		 */
		EClass VERIFIER_INPUT = eINSTANCE.getVerifierInput();

		/**
		 * The meta object literal for the '<em><b>Nodes</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VERIFIER_INPUT__NODES = eINSTANCE.getVerifierInput_Nodes();

		/**
		 * The meta object literal for the '<em><b>Edges</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VERIFIER_INPUT__EDGES = eINSTANCE.getVerifierInput_Edges();

		/**
		 * The meta object literal for the '{@link org.polymodel.verifier.impl.VerifierEdgeImpl <em>Edge</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.polymodel.verifier.impl.VerifierEdgeImpl
		 * @see org.polymodel.verifier.impl.VerifierPackageImpl#getVerifierEdge()
		 * @generated
		 */
		EClass VERIFIER_EDGE = eINSTANCE.getVerifierEdge();

		/**
		 * The meta object literal for the '<em><b>Source</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VERIFIER_EDGE__SOURCE = eINSTANCE.getVerifierEdge_Source();

		/**
		 * The meta object literal for the '<em><b>Destination</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VERIFIER_EDGE__DESTINATION = eINSTANCE.getVerifierEdge_Destination();

		/**
		 * The meta object literal for the '<em><b>Domain</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VERIFIER_EDGE__DOMAIN = eINSTANCE.getVerifierEdge_Domain();

		/**
		 * The meta object literal for the '<em><b>Function</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VERIFIER_EDGE__FUNCTION = eINSTANCE.getVerifierEdge_Function();

		/**
		 * The meta object literal for the '{@link org.polymodel.verifier.impl.VerifierNodeImpl <em>Node</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.polymodel.verifier.impl.VerifierNodeImpl
		 * @see org.polymodel.verifier.impl.VerifierPackageImpl#getVerifierNode()
		 * @generated
		 */
		EClass VERIFIER_NODE = eINSTANCE.getVerifierNode();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute VERIFIER_NODE__NAME = eINSTANCE.getVerifierNode_Name();

		/**
		 * The meta object literal for the '<em><b>Domain</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VERIFIER_NODE__DOMAIN = eINSTANCE.getVerifierNode_Domain();

		/**
		 * The meta object literal for the '<em><b>Space Time Map</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VERIFIER_NODE__SPACE_TIME_MAP = eINSTANCE.getVerifierNode_SpaceTimeMap();

		/**
		 * The meta object literal for the '<em><b>Memory Map</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VERIFIER_NODE__MEMORY_MAP = eINSTANCE.getVerifierNode_MemoryMap();

		/**
		 * The meta object literal for the '<em><b>Dimension Types</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute VERIFIER_NODE__DIMENSION_TYPES = eINSTANCE.getVerifierNode_DimensionTypes();

		/**
		 * The meta object literal for the '{@link org.polymodel.verifier.impl.ProjectionFunctionImpl <em>Projection Function</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.polymodel.verifier.impl.ProjectionFunctionImpl
		 * @see org.polymodel.verifier.impl.VerifierPackageImpl#getProjectionFunction()
		 * @generated
		 */
		EClass PROJECTION_FUNCTION = eINSTANCE.getProjectionFunction();

		/**
		 * The meta object literal for the '{@link org.polymodel.verifier.impl.DependenceFunctionImpl <em>Dependence Function</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.polymodel.verifier.impl.DependenceFunctionImpl
		 * @see org.polymodel.verifier.impl.VerifierPackageImpl#getDependenceFunction()
		 * @generated
		 */
		EClass DEPENDENCE_FUNCTION = eINSTANCE.getDependenceFunction();

		/**
		 * The meta object literal for the '{@link org.polymodel.verifier.VERBOSITY <em>VERBOSITY</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.polymodel.verifier.VERBOSITY
		 * @see org.polymodel.verifier.impl.VerifierPackageImpl#getVERBOSITY()
		 * @generated
		 */
		EEnum VERBOSITY = eINSTANCE.getVERBOSITY();

		/**
		 * The meta object literal for the '{@link org.polymodel.verifier.DIM_TYPE <em>DIM TYPE</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.polymodel.verifier.DIM_TYPE
		 * @see org.polymodel.verifier.impl.VerifierPackageImpl#getDIM_TYPE()
		 * @generated
		 */
		EEnum DIM_TYPE = eINSTANCE.getDIM_TYPE();

		/**
		 * The meta object literal for the '<em>Object</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see java.lang.Object
		 * @see org.polymodel.verifier.impl.VerifierPackageImpl#getObject()
		 * @generated
		 */
		EDataType OBJECT = eINSTANCE.getObject();

	}

} //VerifierPackage
