package org.polymodel.verifier.factory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polymodel.verifier.DIM_TYPE;
import org.polymodel.verifier.EdgeFunction;
import org.polymodel.verifier.MemoryMap;
import org.polymodel.verifier.VerifierEdge;
import org.polymodel.verifier.VerifierFactory;
import org.polymodel.verifier.VerifierInput;
import org.polymodel.verifier.VerifierNode;
import org.polymodel.verifier.VerifierOutput;

import fr.irisa.cairn.model.polymodel.AffineMapping;
import fr.irisa.cairn.model.polymodel.PolyhedralDomain;
import fr.irisa.cairn.model.polymodel.prdg.DependenceFunction;
import fr.irisa.cairn.model.polymodel.prdg.PRDG;
import fr.irisa.cairn.model.polymodel.prdg.PRDGEdge;
import fr.irisa.cairn.model.polymodel.prdg.PRDGNode;
import fr.irisa.cairn.model.polymodel.prdg.ProjectionFunction;

public class VerifierUserFactory {


	private static VerifierFactory factory = VerifierFactory.eINSTANCE;
	
	public static VerifierOutput initializeOutput() {
		return factory.createVerifierOutput();
	}
	
	public static MemoryMap createMemoryMap(Object target, AffineMapping mapping) {
		MemoryMap map = factory.createMemoryMap();
		
		map.setTarget(target);
		map.setMapping(mapping);
		
		return map;
	}
	
	public static VerifierInput createVerifierInput(PRDG prdg,  Map<PRDGNode, AffineMapping> spaceTimeMaps, Map<PRDGNode, MemoryMap> memoryMaps, Map<PRDGNode, List<DIM_TYPE>> dimTypes) {
		VerifierInput input = factory.createVerifierInput();
		
		Map<PRDGNode, VerifierNode> nodeToNode = new HashMap<PRDGNode, VerifierNode>();
		
		//first create all nodes
		for (PRDGNode node : prdg.getNodes()) {
			VerifierNode vnode = createVerifierNode(node.getName(), EcoreUtil.copy(node.getDomain()), memoryMaps.get(node), spaceTimeMaps.get(node), dimTypes.get(node));
			input.getNodes().add(vnode);
			nodeToNode.put(node, vnode);
		}
		
		//then adapt the edges
		for (PRDGEdge edge : prdg.getEdges()) {
			EdgeFunction edgeFunc;
			if ((edge.getFunction() instanceof DependenceFunction)) {
				edgeFunc = createDependenceEdgeFunction(EcoreUtil.copy(edge.getFunction().getMapping()));
			} else if (edge.getFunction() instanceof ProjectionFunction) {
				edgeFunc = createProjectionEdgeFunction(EcoreUtil.copy(edge.getFunction().getMapping()));
			} else {
				throw new RuntimeException("Unsupported EdgeFunction : " + edge.getFunction().eClass());
			}
			
			VerifierEdge vedge = createVerifierEdge(nodeToNode.get(edge.getSource()), nodeToNode.get(edge.getDestination()),
					edgeFunc, EcoreUtil.copy(edge.getDomain()));
			input.getEdges().add(vedge);
		}
		
		return input;
	}
	
	public static VerifierNode createVerifierNode(String name, PolyhedralDomain domain, MemoryMap memMap, AffineMapping STmap, List<DIM_TYPE> dimTypes) {
		VerifierNode node = factory.createVerifierNode();
		
		node.setName(name);
		node.setDomain(domain);
		node.setMemoryMap(memMap);
		node.setSpaceTimeMap(STmap);
		node.getDimensionTypes().addAll(dimTypes);
		
		return node;
	}
	
	public static VerifierEdge createVerifierEdge(VerifierNode src, VerifierNode dst, EdgeFunction function, PolyhedralDomain domain) {
		VerifierEdge edge = factory.createVerifierEdge();
		
		edge.setSource(src);
		edge.setDestination(dst);
		edge.setFunction(function);
		edge.setDomain(domain);
		
		return edge;
	}
	
	public static EdgeFunction createDependenceEdgeFunction(AffineMapping mapping) {
		EdgeFunction edgeFunc = factory.createDependenceFunction();
		
		edgeFunc.setMapping(mapping);
		
		return edgeFunc;
	}
	
	public static EdgeFunction createProjectionEdgeFunction(AffineMapping mapping) {
		EdgeFunction edgeFunc = factory.createProjectionFunction();
		
		edgeFunc.setMapping(mapping);
		
		return edgeFunc;
	}
}
