/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.polymodel.verifier.impl;

import java.util.Map;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.polymodel.verifier.*;
import org.polymodel.verifier.DIM_TYPE;
import org.polymodel.verifier.MemoryMap;
import org.polymodel.verifier.VERBOSITY;
import org.polymodel.verifier.VerifierFactory;
import org.polymodel.verifier.VerifierOutput;
import org.polymodel.verifier.VerifierPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class VerifierFactoryImpl extends EFactoryImpl implements VerifierFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static VerifierFactory init() {
		try {
			VerifierFactory theVerifierFactory = (VerifierFactory)EPackage.Registry.INSTANCE.getEFactory("http://polymodel/verifier"); 
			if (theVerifierFactory != null) {
				return theVerifierFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new VerifierFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public VerifierFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case VerifierPackage.MEMORY_MAP: return createMemoryMap();
			case VerifierPackage.VERIFIER_OUTPUT: return createVerifierOutput();
			case VerifierPackage.VERIFIER_INPUT: return createVerifierInput();
			case VerifierPackage.VERIFIER_EDGE: return createVerifierEdge();
			case VerifierPackage.VERIFIER_NODE: return createVerifierNode();
			case VerifierPackage.PROJECTION_FUNCTION: return createProjectionFunction();
			case VerifierPackage.DEPENDENCE_FUNCTION: return createDependenceFunction();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
			case VerifierPackage.VERBOSITY:
				return createVERBOSITYFromString(eDataType, initialValue);
			case VerifierPackage.DIM_TYPE:
				return createDIM_TYPEFromString(eDataType, initialValue);
			case VerifierPackage.OBJECT:
				return createObjectFromString(eDataType, initialValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
			case VerifierPackage.VERBOSITY:
				return convertVERBOSITYToString(eDataType, instanceValue);
			case VerifierPackage.DIM_TYPE:
				return convertDIM_TYPEToString(eDataType, instanceValue);
			case VerifierPackage.OBJECT:
				return convertObjectToString(eDataType, instanceValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MemoryMap createMemoryMap() {
		MemoryMapImpl memoryMap = new MemoryMapImpl();
		return memoryMap;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public VerifierOutput createVerifierOutput() {
		VerifierOutputImpl verifierOutput = new VerifierOutputImpl();
		return verifierOutput;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public VerifierInput createVerifierInput() {
		VerifierInputImpl verifierInput = new VerifierInputImpl();
		return verifierInput;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public VerifierEdge createVerifierEdge() {
		VerifierEdgeImpl verifierEdge = new VerifierEdgeImpl();
		return verifierEdge;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public VerifierNode createVerifierNode() {
		VerifierNodeImpl verifierNode = new VerifierNodeImpl();
		return verifierNode;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProjectionFunction createProjectionFunction() {
		ProjectionFunctionImpl projectionFunction = new ProjectionFunctionImpl();
		return projectionFunction;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DependenceFunction createDependenceFunction() {
		DependenceFunctionImpl dependenceFunction = new DependenceFunctionImpl();
		return dependenceFunction;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public VERBOSITY createVERBOSITYFromString(EDataType eDataType, String initialValue) {
		VERBOSITY result = VERBOSITY.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertVERBOSITYToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DIM_TYPE createDIM_TYPEFromString(EDataType eDataType, String initialValue) {
		DIM_TYPE result = DIM_TYPE.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertDIM_TYPEToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object createObjectFromString(EDataType eDataType, String initialValue) {
		return super.createFromString(eDataType, initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertObjectToString(EDataType eDataType, Object instanceValue) {
		return super.convertToString(eDataType, instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public VerifierPackage getVerifierPackage() {
		return (VerifierPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static VerifierPackage getPackage() {
		return VerifierPackage.eINSTANCE;
	}

} //VerifierFactoryImpl
