/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.polymodel.verifier.impl;

import fr.irisa.cairn.model.polymodel.AffineMapping;
import fr.irisa.cairn.model.polymodel.PolyhedralDomain;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.emf.ecore.util.EDataTypeEList;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;

import org.polymodel.verifier.DIM_TYPE;
import org.polymodel.verifier.MemoryMap;
import org.polymodel.verifier.VerifierNode;
import org.polymodel.verifier.VerifierPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Node</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.polymodel.verifier.impl.VerifierNodeImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.polymodel.verifier.impl.VerifierNodeImpl#getDomain <em>Domain</em>}</li>
 *   <li>{@link org.polymodel.verifier.impl.VerifierNodeImpl#getSpaceTimeMap <em>Space Time Map</em>}</li>
 *   <li>{@link org.polymodel.verifier.impl.VerifierNodeImpl#getMemoryMap <em>Memory Map</em>}</li>
 *   <li>{@link org.polymodel.verifier.impl.VerifierNodeImpl#getDimensionTypes <em>Dimension Types</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class VerifierNodeImpl extends EObjectImpl implements VerifierNode {
	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getDomain() <em>Domain</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDomain()
	 * @generated
	 * @ordered
	 */
	protected PolyhedralDomain domain;

	/**
	 * The cached value of the '{@link #getSpaceTimeMap() <em>Space Time Map</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSpaceTimeMap()
	 * @generated
	 * @ordered
	 */
	protected AffineMapping spaceTimeMap;

	/**
	 * The cached value of the '{@link #getMemoryMap() <em>Memory Map</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMemoryMap()
	 * @generated
	 * @ordered
	 */
	protected MemoryMap memoryMap;

	/**
	 * The cached value of the '{@link #getDimensionTypes() <em>Dimension Types</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDimensionTypes()
	 * @generated
	 * @ordered
	 */
	protected EList<DIM_TYPE> dimensionTypes;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VerifierNodeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return VerifierPackage.Literals.VERIFIER_NODE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VerifierPackage.VERIFIER_NODE__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PolyhedralDomain getDomain() {
		return domain;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetDomain(PolyhedralDomain newDomain, NotificationChain msgs) {
		PolyhedralDomain oldDomain = domain;
		domain = newDomain;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, VerifierPackage.VERIFIER_NODE__DOMAIN, oldDomain, newDomain);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDomain(PolyhedralDomain newDomain) {
		if (newDomain != domain) {
			NotificationChain msgs = null;
			if (domain != null)
				msgs = ((InternalEObject)domain).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - VerifierPackage.VERIFIER_NODE__DOMAIN, null, msgs);
			if (newDomain != null)
				msgs = ((InternalEObject)newDomain).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - VerifierPackage.VERIFIER_NODE__DOMAIN, null, msgs);
			msgs = basicSetDomain(newDomain, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VerifierPackage.VERIFIER_NODE__DOMAIN, newDomain, newDomain));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AffineMapping getSpaceTimeMap() {
		return spaceTimeMap;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSpaceTimeMap(AffineMapping newSpaceTimeMap, NotificationChain msgs) {
		AffineMapping oldSpaceTimeMap = spaceTimeMap;
		spaceTimeMap = newSpaceTimeMap;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, VerifierPackage.VERIFIER_NODE__SPACE_TIME_MAP, oldSpaceTimeMap, newSpaceTimeMap);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSpaceTimeMap(AffineMapping newSpaceTimeMap) {
		if (newSpaceTimeMap != spaceTimeMap) {
			NotificationChain msgs = null;
			if (spaceTimeMap != null)
				msgs = ((InternalEObject)spaceTimeMap).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - VerifierPackage.VERIFIER_NODE__SPACE_TIME_MAP, null, msgs);
			if (newSpaceTimeMap != null)
				msgs = ((InternalEObject)newSpaceTimeMap).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - VerifierPackage.VERIFIER_NODE__SPACE_TIME_MAP, null, msgs);
			msgs = basicSetSpaceTimeMap(newSpaceTimeMap, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VerifierPackage.VERIFIER_NODE__SPACE_TIME_MAP, newSpaceTimeMap, newSpaceTimeMap));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MemoryMap getMemoryMap() {
		return memoryMap;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetMemoryMap(MemoryMap newMemoryMap, NotificationChain msgs) {
		MemoryMap oldMemoryMap = memoryMap;
		memoryMap = newMemoryMap;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, VerifierPackage.VERIFIER_NODE__MEMORY_MAP, oldMemoryMap, newMemoryMap);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMemoryMap(MemoryMap newMemoryMap) {
		if (newMemoryMap != memoryMap) {
			NotificationChain msgs = null;
			if (memoryMap != null)
				msgs = ((InternalEObject)memoryMap).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - VerifierPackage.VERIFIER_NODE__MEMORY_MAP, null, msgs);
			if (newMemoryMap != null)
				msgs = ((InternalEObject)newMemoryMap).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - VerifierPackage.VERIFIER_NODE__MEMORY_MAP, null, msgs);
			msgs = basicSetMemoryMap(newMemoryMap, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VerifierPackage.VERIFIER_NODE__MEMORY_MAP, newMemoryMap, newMemoryMap));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<DIM_TYPE> getDimensionTypes() {
		if (dimensionTypes == null) {
			dimensionTypes = new EDataTypeEList<DIM_TYPE>(DIM_TYPE.class, this, VerifierPackage.VERIFIER_NODE__DIMENSION_TYPES);
		}
		return dimensionTypes;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case VerifierPackage.VERIFIER_NODE__DOMAIN:
				return basicSetDomain(null, msgs);
			case VerifierPackage.VERIFIER_NODE__SPACE_TIME_MAP:
				return basicSetSpaceTimeMap(null, msgs);
			case VerifierPackage.VERIFIER_NODE__MEMORY_MAP:
				return basicSetMemoryMap(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case VerifierPackage.VERIFIER_NODE__NAME:
				return getName();
			case VerifierPackage.VERIFIER_NODE__DOMAIN:
				return getDomain();
			case VerifierPackage.VERIFIER_NODE__SPACE_TIME_MAP:
				return getSpaceTimeMap();
			case VerifierPackage.VERIFIER_NODE__MEMORY_MAP:
				return getMemoryMap();
			case VerifierPackage.VERIFIER_NODE__DIMENSION_TYPES:
				return getDimensionTypes();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case VerifierPackage.VERIFIER_NODE__NAME:
				setName((String)newValue);
				return;
			case VerifierPackage.VERIFIER_NODE__DOMAIN:
				setDomain((PolyhedralDomain)newValue);
				return;
			case VerifierPackage.VERIFIER_NODE__SPACE_TIME_MAP:
				setSpaceTimeMap((AffineMapping)newValue);
				return;
			case VerifierPackage.VERIFIER_NODE__MEMORY_MAP:
				setMemoryMap((MemoryMap)newValue);
				return;
			case VerifierPackage.VERIFIER_NODE__DIMENSION_TYPES:
				getDimensionTypes().clear();
				getDimensionTypes().addAll((Collection<? extends DIM_TYPE>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case VerifierPackage.VERIFIER_NODE__NAME:
				setName(NAME_EDEFAULT);
				return;
			case VerifierPackage.VERIFIER_NODE__DOMAIN:
				setDomain((PolyhedralDomain)null);
				return;
			case VerifierPackage.VERIFIER_NODE__SPACE_TIME_MAP:
				setSpaceTimeMap((AffineMapping)null);
				return;
			case VerifierPackage.VERIFIER_NODE__MEMORY_MAP:
				setMemoryMap((MemoryMap)null);
				return;
			case VerifierPackage.VERIFIER_NODE__DIMENSION_TYPES:
				getDimensionTypes().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case VerifierPackage.VERIFIER_NODE__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case VerifierPackage.VERIFIER_NODE__DOMAIN:
				return domain != null;
			case VerifierPackage.VERIFIER_NODE__SPACE_TIME_MAP:
				return spaceTimeMap != null;
			case VerifierPackage.VERIFIER_NODE__MEMORY_MAP:
				return memoryMap != null;
			case VerifierPackage.VERIFIER_NODE__DIMENSION_TYPES:
				return dimensionTypes != null && !dimensionTypes.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (name: ");
		result.append(name);
		result.append(", dimensionTypes: ");
		result.append(dimensionTypes);
		result.append(')');
		return result.toString();
	}

} //VerifierNodeImpl
