/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.polymodel.verifier.impl;

import java.util.Collection;
import java.util.Map;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.polymodel.verifier.VERBOSITY;
import org.polymodel.verifier.VerifierInput;
import org.polymodel.verifier.VerifierOutput;
import org.polymodel.verifier.VerifierPackage;
import org.polymodel.verifier.message.IVerifierMessage;

import fr.irisa.cairn.model.polymodel.prdg.PRDG;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Output</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.polymodel.verifier.impl.VerifierOutputImpl#getMessages <em>Messages</em>}</li>
 *   <li>{@link org.polymodel.verifier.impl.VerifierOutputImpl#isValid <em>Valid</em>}</li>
 *   <li>{@link org.polymodel.verifier.impl.VerifierOutputImpl#getInput <em>Input</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class VerifierOutputImpl extends EObjectImpl implements VerifierOutput {
	/**
	 * The cached value of the '{@link #getMessages() <em>Messages</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMessages()
	 * @generated
	 * @ordered
	 */
	protected EList<IVerifierMessage> messages;

	/**
	 * The default value of the '{@link #isValid() <em>Valid</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isValid()
	 * @generated
	 * @ordered
	 */
	protected static final boolean VALID_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isValid() <em>Valid</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isValid()
	 * @generated
	 * @ordered
	 */
	protected boolean valid = VALID_EDEFAULT;

	/**
	 * The cached value of the '{@link #getInput() <em>Input</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInput()
	 * @generated
	 * @ordered
	 */
	protected VerifierInput input;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VerifierOutputImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return VerifierPackage.Literals.VERIFIER_OUTPUT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<IVerifierMessage> getMessages() {
		if (messages == null) {
			messages = new EObjectResolvingEList<IVerifierMessage>(IVerifierMessage.class, this, VerifierPackage.VERIFIER_OUTPUT__MESSAGES);
		}
		return messages;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isValid() {
		return valid;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setValid(boolean newValid) {
		boolean oldValid = valid;
		valid = newValid;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VerifierPackage.VERIFIER_OUTPUT__VALID, oldValid, valid));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public VerifierInput getInput() {
		if (input != null && input.eIsProxy()) {
			InternalEObject oldInput = (InternalEObject)input;
			input = (VerifierInput)eResolveProxy(oldInput);
			if (input != oldInput) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, VerifierPackage.VERIFIER_OUTPUT__INPUT, oldInput, input));
			}
		}
		return input;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public VerifierInput basicGetInput() {
		return input;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInput(VerifierInput newInput) {
		VerifierInput oldInput = input;
		input = newInput;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, VerifierPackage.VERIFIER_OUTPUT__INPUT, oldInput, input));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public String toString(VERBOSITY verbosity) {
		StringBuffer sb = new StringBuffer();
		for (IVerifierMessage message : getMessages()) {
			sb.append(message.toString(verbosity));
		}

		sb.append("\n");
		sb.append("VALID : " + valid);
		sb.append("\n");
		
		return sb.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case VerifierPackage.VERIFIER_OUTPUT__MESSAGES:
				return getMessages();
			case VerifierPackage.VERIFIER_OUTPUT__VALID:
				return isValid();
			case VerifierPackage.VERIFIER_OUTPUT__INPUT:
				if (resolve) return getInput();
				return basicGetInput();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case VerifierPackage.VERIFIER_OUTPUT__MESSAGES:
				getMessages().clear();
				getMessages().addAll((Collection<? extends IVerifierMessage>)newValue);
				return;
			case VerifierPackage.VERIFIER_OUTPUT__VALID:
				setValid((Boolean)newValue);
				return;
			case VerifierPackage.VERIFIER_OUTPUT__INPUT:
				setInput((VerifierInput)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case VerifierPackage.VERIFIER_OUTPUT__MESSAGES:
				getMessages().clear();
				return;
			case VerifierPackage.VERIFIER_OUTPUT__VALID:
				setValid(VALID_EDEFAULT);
				return;
			case VerifierPackage.VERIFIER_OUTPUT__INPUT:
				setInput((VerifierInput)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case VerifierPackage.VERIFIER_OUTPUT__MESSAGES:
				return messages != null && !messages.isEmpty();
			case VerifierPackage.VERIFIER_OUTPUT__VALID:
				return valid != VALID_EDEFAULT;
			case VerifierPackage.VERIFIER_OUTPUT__INPUT:
				return input != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	@Override
	public String toString() {
		StringBuffer sb = new StringBuffer();
		
		for (IVerifierMessage msg : getMessages()) {
			sb.append(msg.toString(VERBOSITY.MAX));
			sb.append("\n");
		}
		
		sb.append("valid : " + isValid());
		
		return sb.toString();
	}

} //VerifierOutputImpl
