/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.polymodel.verifier.impl;

import java.util.Map;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.polymodel.verifier.DependenceFunction;
import org.polymodel.verifier.EdgeFunction;
import org.polymodel.verifier.MemoryMap;
import org.polymodel.verifier.ProjectionFunction;
import org.polymodel.verifier.VerifierEdge;
import org.polymodel.verifier.VerifierFactory;
import org.polymodel.verifier.VerifierInput;
import org.polymodel.verifier.VerifierNode;
import org.polymodel.verifier.VerifierOutput;
import org.polymodel.verifier.VerifierPackage;
import org.polymodel.verifier.message.MessagePackage;
import org.polymodel.verifier.message.impl.MessagePackageImpl;

import fr.irisa.cairn.model.polymodel.PolymodelPackage;
import fr.irisa.cairn.model.polymodel.prdg.PrdgPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class VerifierPackageImpl extends EPackageImpl implements VerifierPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass memoryMapEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass verifierOutputEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass edgeFunctionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass verifierInputEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass verifierEdgeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass verifierNodeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass projectionFunctionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass dependenceFunctionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum verbosityEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum diM_TYPEEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType objectEDataType = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.polymodel.verifier.VerifierPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private VerifierPackageImpl() {
		super(eNS_URI, VerifierFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 * 
	 * <p>This method is used to initialize {@link VerifierPackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static VerifierPackage init() {
		if (isInited) return (VerifierPackage)EPackage.Registry.INSTANCE.getEPackage(VerifierPackage.eNS_URI);

		// Obtain or create and register package
		VerifierPackageImpl theVerifierPackage = (VerifierPackageImpl)(EPackage.Registry.INSTANCE.get(eNS_URI) instanceof VerifierPackageImpl ? EPackage.Registry.INSTANCE.get(eNS_URI) : new VerifierPackageImpl());

		isInited = true;

		// Initialize simple dependencies
		PolymodelPackage.eINSTANCE.eClass();

		// Obtain or create and register interdependencies
		MessagePackageImpl theMessagePackage = (MessagePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(MessagePackage.eNS_URI) instanceof MessagePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(MessagePackage.eNS_URI) : MessagePackage.eINSTANCE);

		// Create package meta-data objects
		theVerifierPackage.createPackageContents();
		theMessagePackage.createPackageContents();

		// Initialize created meta-data
		theVerifierPackage.initializePackageContents();
		theMessagePackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theVerifierPackage.freeze();

  
		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(VerifierPackage.eNS_URI, theVerifierPackage);
		return theVerifierPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getMemoryMap() {
		return memoryMapEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getMemoryMap_Mapping() {
		return (EReference)memoryMapEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getMemoryMap_Target() {
		return (EAttribute)memoryMapEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getVerifierOutput() {
		return verifierOutputEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getVerifierOutput_Messages() {
		return (EReference)verifierOutputEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getVerifierOutput_Valid() {
		return (EAttribute)verifierOutputEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getVerifierOutput_Input() {
		return (EReference)verifierOutputEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getEdgeFunction() {
		return edgeFunctionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getEdgeFunction_Mapping() {
		return (EReference)edgeFunctionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getVerifierInput() {
		return verifierInputEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getVerifierInput_Nodes() {
		return (EReference)verifierInputEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getVerifierInput_Edges() {
		return (EReference)verifierInputEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getVerifierEdge() {
		return verifierEdgeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getVerifierEdge_Source() {
		return (EReference)verifierEdgeEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getVerifierEdge_Destination() {
		return (EReference)verifierEdgeEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getVerifierEdge_Domain() {
		return (EReference)verifierEdgeEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getVerifierEdge_Function() {
		return (EReference)verifierEdgeEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getVerifierNode() {
		return verifierNodeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getVerifierNode_Name() {
		return (EAttribute)verifierNodeEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getVerifierNode_Domain() {
		return (EReference)verifierNodeEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getVerifierNode_SpaceTimeMap() {
		return (EReference)verifierNodeEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getVerifierNode_MemoryMap() {
		return (EReference)verifierNodeEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getVerifierNode_DimensionTypes() {
		return (EAttribute)verifierNodeEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getProjectionFunction() {
		return projectionFunctionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getDependenceFunction() {
		return dependenceFunctionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getVERBOSITY() {
		return verbosityEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getDIM_TYPE() {
		return diM_TYPEEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EDataType getObject() {
		return objectEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public VerifierFactory getVerifierFactory() {
		return (VerifierFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		memoryMapEClass = createEClass(MEMORY_MAP);
		createEReference(memoryMapEClass, MEMORY_MAP__MAPPING);
		createEAttribute(memoryMapEClass, MEMORY_MAP__TARGET);

		verifierOutputEClass = createEClass(VERIFIER_OUTPUT);
		createEReference(verifierOutputEClass, VERIFIER_OUTPUT__MESSAGES);
		createEAttribute(verifierOutputEClass, VERIFIER_OUTPUT__VALID);
		createEReference(verifierOutputEClass, VERIFIER_OUTPUT__INPUT);

		edgeFunctionEClass = createEClass(EDGE_FUNCTION);
		createEReference(edgeFunctionEClass, EDGE_FUNCTION__MAPPING);

		verifierInputEClass = createEClass(VERIFIER_INPUT);
		createEReference(verifierInputEClass, VERIFIER_INPUT__NODES);
		createEReference(verifierInputEClass, VERIFIER_INPUT__EDGES);

		verifierEdgeEClass = createEClass(VERIFIER_EDGE);
		createEReference(verifierEdgeEClass, VERIFIER_EDGE__SOURCE);
		createEReference(verifierEdgeEClass, VERIFIER_EDGE__DESTINATION);
		createEReference(verifierEdgeEClass, VERIFIER_EDGE__DOMAIN);
		createEReference(verifierEdgeEClass, VERIFIER_EDGE__FUNCTION);

		verifierNodeEClass = createEClass(VERIFIER_NODE);
		createEAttribute(verifierNodeEClass, VERIFIER_NODE__NAME);
		createEReference(verifierNodeEClass, VERIFIER_NODE__DOMAIN);
		createEReference(verifierNodeEClass, VERIFIER_NODE__SPACE_TIME_MAP);
		createEReference(verifierNodeEClass, VERIFIER_NODE__MEMORY_MAP);
		createEAttribute(verifierNodeEClass, VERIFIER_NODE__DIMENSION_TYPES);

		projectionFunctionEClass = createEClass(PROJECTION_FUNCTION);

		dependenceFunctionEClass = createEClass(DEPENDENCE_FUNCTION);

		// Create enums
		verbosityEEnum = createEEnum(VERBOSITY);
		diM_TYPEEEnum = createEEnum(DIM_TYPE);

		// Create data types
		objectEDataType = createEDataType(OBJECT);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		MessagePackage theMessagePackage = (MessagePackage)EPackage.Registry.INSTANCE.getEPackage(MessagePackage.eNS_URI);
		PolymodelPackage thePolymodelPackage = (PolymodelPackage)EPackage.Registry.INSTANCE.getEPackage(PolymodelPackage.eNS_URI);

		// Add subpackages
		getESubpackages().add(theMessagePackage);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes
		projectionFunctionEClass.getESuperTypes().add(this.getEdgeFunction());
		dependenceFunctionEClass.getESuperTypes().add(this.getEdgeFunction());

		// Initialize classes and features; add operations and parameters
		initEClass(memoryMapEClass, MemoryMap.class, "MemoryMap", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getMemoryMap_Mapping(), thePolymodelPackage.getAffineMapping(), null, "mapping", null, 1, 1, MemoryMap.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getMemoryMap_Target(), this.getObject(), "target", null, 1, 1, MemoryMap.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		addEOperation(memoryMapEClass, ecorePackage.getEString(), "toCArrayAccess", 1, 1, IS_UNIQUE, IS_ORDERED);

		EOperation op = addEOperation(memoryMapEClass, ecorePackage.getEString(), "toCArrayAccess", 1, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, thePolymodelPackage.getAffineMapping(), "dependence", 1, 1, IS_UNIQUE, IS_ORDERED);

		initEClass(verifierOutputEClass, VerifierOutput.class, "VerifierOutput", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getVerifierOutput_Messages(), theMessagePackage.getIVerifierMessage(), null, "messages", null, 0, -1, VerifierOutput.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getVerifierOutput_Valid(), ecorePackage.getEBoolean(), "valid", null, 1, 1, VerifierOutput.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getVerifierOutput_Input(), this.getVerifierInput(), null, "input", null, 1, 1, VerifierOutput.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		op = addEOperation(verifierOutputEClass, ecorePackage.getEString(), "toString", 1, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, this.getVERBOSITY(), "verbosity", 1, 1, IS_UNIQUE, IS_ORDERED);

		initEClass(edgeFunctionEClass, EdgeFunction.class, "EdgeFunction", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getEdgeFunction_Mapping(), thePolymodelPackage.getAffineMapping(), null, "mapping", null, 1, 1, EdgeFunction.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(verifierInputEClass, VerifierInput.class, "VerifierInput", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getVerifierInput_Nodes(), this.getVerifierNode(), null, "nodes", null, 0, -1, VerifierInput.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getVerifierInput_Edges(), this.getVerifierEdge(), null, "edges", null, 0, -1, VerifierInput.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(verifierEdgeEClass, VerifierEdge.class, "VerifierEdge", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getVerifierEdge_Source(), this.getVerifierNode(), null, "source", null, 1, 1, VerifierEdge.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getVerifierEdge_Destination(), this.getVerifierNode(), null, "destination", null, 1, 1, VerifierEdge.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getVerifierEdge_Domain(), thePolymodelPackage.getPolyhedralDomain(), null, "domain", null, 1, 1, VerifierEdge.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getVerifierEdge_Function(), this.getEdgeFunction(), null, "function", null, 1, 1, VerifierEdge.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(verifierNodeEClass, VerifierNode.class, "VerifierNode", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getVerifierNode_Name(), ecorePackage.getEString(), "name", null, 1, 1, VerifierNode.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getVerifierNode_Domain(), thePolymodelPackage.getPolyhedralDomain(), null, "domain", null, 1, 1, VerifierNode.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getVerifierNode_SpaceTimeMap(), thePolymodelPackage.getAffineMapping(), null, "spaceTimeMap", null, 1, 1, VerifierNode.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getVerifierNode_MemoryMap(), this.getMemoryMap(), null, "memoryMap", null, 1, 1, VerifierNode.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getVerifierNode_DimensionTypes(), this.getDIM_TYPE(), "dimensionTypes", null, 0, -1, VerifierNode.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(projectionFunctionEClass, ProjectionFunction.class, "ProjectionFunction", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(dependenceFunctionEClass, DependenceFunction.class, "DependenceFunction", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		// Initialize enums and add enum literals
		initEEnum(verbosityEEnum, org.polymodel.verifier.VERBOSITY.class, "VERBOSITY");
		addEEnumLiteral(verbosityEEnum, org.polymodel.verifier.VERBOSITY.NONE);
		addEEnumLiteral(verbosityEEnum, org.polymodel.verifier.VERBOSITY.MIN);
		addEEnumLiteral(verbosityEEnum, org.polymodel.verifier.VERBOSITY.MAX);

		initEEnum(diM_TYPEEEnum, org.polymodel.verifier.DIM_TYPE.class, "DIM_TYPE");
		addEEnumLiteral(diM_TYPEEEnum, org.polymodel.verifier.DIM_TYPE.SEQUENTIAL);
		addEEnumLiteral(diM_TYPEEEnum, org.polymodel.verifier.DIM_TYPE.PARALLEL);
		addEEnumLiteral(diM_TYPEEEnum, org.polymodel.verifier.DIM_TYPE.ORDERING);

		// Initialize data types
		initEDataType(objectEDataType, Object.class, "Object", IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS);

		// Create resource
		createResource(eNS_URI);
	}

} //VerifierPackageImpl
