/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.polymodel.verifier.message;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.polymodel.verifier.message.MessageFactory
 * @model kind="package"
 * @generated
 */
public interface MessagePackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "message";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://polymodel/verifier/message";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "message";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	MessagePackage eINSTANCE = org.polymodel.verifier.message.impl.MessagePackageImpl.init();

	/**
	 * The meta object id for the '{@link org.polymodel.verifier.message.IVerifierMessage <em>IVerifier Message</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.polymodel.verifier.message.IVerifierMessage
	 * @see org.polymodel.verifier.message.impl.MessagePackageImpl#getIVerifierMessage()
	 * @generated
	 */
	int IVERIFIER_MESSAGE = 0;

	/**
	 * The number of structural features of the '<em>IVerifier Message</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IVERIFIER_MESSAGE_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.polymodel.verifier.message.impl.AbstractNodeErrorImpl <em>Abstract Node Error</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.polymodel.verifier.message.impl.AbstractNodeErrorImpl
	 * @see org.polymodel.verifier.message.impl.MessagePackageImpl#getAbstractNodeError()
	 * @generated
	 */
	int ABSTRACT_NODE_ERROR = 1;

	/**
	 * The feature id for the '<em><b>Node</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_NODE_ERROR__NODE = IVERIFIER_MESSAGE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Violating Domain</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_NODE_ERROR__VIOLATING_DOMAIN = IVERIFIER_MESSAGE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Abstract Node Error</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_NODE_ERROR_FEATURE_COUNT = IVERIFIER_MESSAGE_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.polymodel.verifier.message.impl.AbstractNodePairErrorImpl <em>Abstract Node Pair Error</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.polymodel.verifier.message.impl.AbstractNodePairErrorImpl
	 * @see org.polymodel.verifier.message.impl.MessagePackageImpl#getAbstractNodePairError()
	 * @generated
	 */
	int ABSTRACT_NODE_PAIR_ERROR = 2;

	/**
	 * The feature id for the '<em><b>Node A</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_NODE_PAIR_ERROR__NODE_A = IVERIFIER_MESSAGE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Node B</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_NODE_PAIR_ERROR__NODE_B = IVERIFIER_MESSAGE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Abstract Node Pair Error</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_NODE_PAIR_ERROR_FEATURE_COUNT = IVERIFIER_MESSAGE_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.polymodel.verifier.message.impl.AbstractEdgeErrorImpl <em>Abstract Edge Error</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.polymodel.verifier.message.impl.AbstractEdgeErrorImpl
	 * @see org.polymodel.verifier.message.impl.MessagePackageImpl#getAbstractEdgeError()
	 * @generated
	 */
	int ABSTRACT_EDGE_ERROR = 3;

	/**
	 * The feature id for the '<em><b>Edge</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EDGE_ERROR__EDGE = IVERIFIER_MESSAGE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Violating Domain</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EDGE_ERROR__VIOLATING_DOMAIN = IVERIFIER_MESSAGE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Abstract Edge Error</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EDGE_ERROR_FEATURE_COUNT = IVERIFIER_MESSAGE_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.polymodel.verifier.message.impl.AbstractSpecErrorImpl <em>Abstract Spec Error</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.polymodel.verifier.message.impl.AbstractSpecErrorImpl
	 * @see org.polymodel.verifier.message.impl.MessagePackageImpl#getAbstractSpecError()
	 * @generated
	 */
	int ABSTRACT_SPEC_ERROR = 4;

	/**
	 * The number of structural features of the '<em>Abstract Spec Error</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_SPEC_ERROR_FEATURE_COUNT = IVERIFIER_MESSAGE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.polymodel.verifier.message.impl.WriteConflictErrorImpl <em>Write Conflict Error</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.polymodel.verifier.message.impl.WriteConflictErrorImpl
	 * @see org.polymodel.verifier.message.impl.MessagePackageImpl#getWriteConflictError()
	 * @generated
	 */
	int WRITE_CONFLICT_ERROR = 5;

	/**
	 * The feature id for the '<em><b>Node A</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WRITE_CONFLICT_ERROR__NODE_A = ABSTRACT_NODE_PAIR_ERROR__NODE_A;

	/**
	 * The feature id for the '<em><b>Node B</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WRITE_CONFLICT_ERROR__NODE_B = ABSTRACT_NODE_PAIR_ERROR__NODE_B;

	/**
	 * The feature id for the '<em><b>Violating Dimension</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WRITE_CONFLICT_ERROR__VIOLATING_DIMENSION = ABSTRACT_NODE_PAIR_ERROR_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Write Conflict Error</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WRITE_CONFLICT_ERROR_FEATURE_COUNT = ABSTRACT_NODE_PAIR_ERROR_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.polymodel.verifier.message.impl.UnsatisfiedCausalityErrorImpl <em>Unsatisfied Causality Error</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.polymodel.verifier.message.impl.UnsatisfiedCausalityErrorImpl
	 * @see org.polymodel.verifier.message.impl.MessagePackageImpl#getUnsatisfiedCausalityError()
	 * @generated
	 */
	int UNSATISFIED_CAUSALITY_ERROR = 6;

	/**
	 * The feature id for the '<em><b>Edge</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNSATISFIED_CAUSALITY_ERROR__EDGE = ABSTRACT_EDGE_ERROR__EDGE;

	/**
	 * The feature id for the '<em><b>Violating Domain</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNSATISFIED_CAUSALITY_ERROR__VIOLATING_DOMAIN = ABSTRACT_EDGE_ERROR__VIOLATING_DOMAIN;

	/**
	 * The feature id for the '<em><b>Violating Dimension</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNSATISFIED_CAUSALITY_ERROR__VIOLATING_DIMENSION = ABSTRACT_EDGE_ERROR_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Unsatisfied Causality Error</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNSATISFIED_CAUSALITY_ERROR_FEATURE_COUNT = ABSTRACT_EDGE_ERROR_FEATURE_COUNT + 1;


	/**
	 * The meta object id for the '{@link org.polymodel.verifier.message.impl.MismatchedDimensionsErrorImpl <em>Mismatched Dimensions Error</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.polymodel.verifier.message.impl.MismatchedDimensionsErrorImpl
	 * @see org.polymodel.verifier.message.impl.MessagePackageImpl#getMismatchedDimensionsError()
	 * @generated
	 */
	int MISMATCHED_DIMENSIONS_ERROR = 7;

	/**
	 * The feature id for the '<em><b>Edge</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MISMATCHED_DIMENSIONS_ERROR__EDGE = ABSTRACT_EDGE_ERROR__EDGE;

	/**
	 * The feature id for the '<em><b>Violating Domain</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MISMATCHED_DIMENSIONS_ERROR__VIOLATING_DOMAIN = ABSTRACT_EDGE_ERROR__VIOLATING_DOMAIN;

	/**
	 * The feature id for the '<em><b>Mismatched Dimension</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MISMATCHED_DIMENSIONS_ERROR__MISMATCHED_DIMENSION = ABSTRACT_EDGE_ERROR_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Mismatched Dimensions Error</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MISMATCHED_DIMENSIONS_ERROR_FEATURE_COUNT = ABSTRACT_EDGE_ERROR_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.polymodel.verifier.message.impl.MismatchedDimensionalityErrorImpl <em>Mismatched Dimensionality Error</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.polymodel.verifier.message.impl.MismatchedDimensionalityErrorImpl
	 * @see org.polymodel.verifier.message.impl.MessagePackageImpl#getMismatchedDimensionalityError()
	 * @generated
	 */
	int MISMATCHED_DIMENSIONALITY_ERROR = 8;

	/**
	 * The number of structural features of the '<em>Mismatched Dimensionality Error</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MISMATCHED_DIMENSIONALITY_ERROR_FEATURE_COUNT = ABSTRACT_SPEC_ERROR_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.polymodel.verifier.message.CAUSALITY_VIOLATION_TYPE <em>CAUSALITY VIOLATION TYPE</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.polymodel.verifier.message.CAUSALITY_VIOLATION_TYPE
	 * @see org.polymodel.verifier.message.impl.MessagePackageImpl#getCAUSALITY_VIOLATION_TYPE()
	 * @generated
	 */
	int CAUSALITY_VIOLATION_TYPE = 9;


	/**
	 * The meta object id for the '{@link org.polymodel.verifier.message.MISMATCHED_DIMENSION_TYPE <em>MISMATCHED DIMENSION TYPE</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.polymodel.verifier.message.MISMATCHED_DIMENSION_TYPE
	 * @see org.polymodel.verifier.message.impl.MessagePackageImpl#getMISMATCHED_DIMENSION_TYPE()
	 * @generated
	 */
	int MISMATCHED_DIMENSION_TYPE = 10;

	/**
	 * Returns the meta object for class '{@link org.polymodel.verifier.message.IVerifierMessage <em>IVerifier Message</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>IVerifier Message</em>'.
	 * @see org.polymodel.verifier.message.IVerifierMessage
	 * @generated
	 */
	EClass getIVerifierMessage();

	/**
	 * Returns the meta object for class '{@link org.polymodel.verifier.message.AbstractNodeError <em>Abstract Node Error</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Abstract Node Error</em>'.
	 * @see org.polymodel.verifier.message.AbstractNodeError
	 * @generated
	 */
	EClass getAbstractNodeError();

	/**
	 * Returns the meta object for the reference '{@link org.polymodel.verifier.message.AbstractNodeError#getNode <em>Node</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Node</em>'.
	 * @see org.polymodel.verifier.message.AbstractNodeError#getNode()
	 * @see #getAbstractNodeError()
	 * @generated
	 */
	EReference getAbstractNodeError_Node();

	/**
	 * Returns the meta object for the containment reference '{@link org.polymodel.verifier.message.AbstractNodeError#getViolatingDomain <em>Violating Domain</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Violating Domain</em>'.
	 * @see org.polymodel.verifier.message.AbstractNodeError#getViolatingDomain()
	 * @see #getAbstractNodeError()
	 * @generated
	 */
	EReference getAbstractNodeError_ViolatingDomain();

	/**
	 * Returns the meta object for class '{@link org.polymodel.verifier.message.AbstractNodePairError <em>Abstract Node Pair Error</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Abstract Node Pair Error</em>'.
	 * @see org.polymodel.verifier.message.AbstractNodePairError
	 * @generated
	 */
	EClass getAbstractNodePairError();

	/**
	 * Returns the meta object for the reference '{@link org.polymodel.verifier.message.AbstractNodePairError#getNodeA <em>Node A</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Node A</em>'.
	 * @see org.polymodel.verifier.message.AbstractNodePairError#getNodeA()
	 * @see #getAbstractNodePairError()
	 * @generated
	 */
	EReference getAbstractNodePairError_NodeA();

	/**
	 * Returns the meta object for the reference '{@link org.polymodel.verifier.message.AbstractNodePairError#getNodeB <em>Node B</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Node B</em>'.
	 * @see org.polymodel.verifier.message.AbstractNodePairError#getNodeB()
	 * @see #getAbstractNodePairError()
	 * @generated
	 */
	EReference getAbstractNodePairError_NodeB();

	/**
	 * Returns the meta object for class '{@link org.polymodel.verifier.message.AbstractEdgeError <em>Abstract Edge Error</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Abstract Edge Error</em>'.
	 * @see org.polymodel.verifier.message.AbstractEdgeError
	 * @generated
	 */
	EClass getAbstractEdgeError();

	/**
	 * Returns the meta object for the reference '{@link org.polymodel.verifier.message.AbstractEdgeError#getEdge <em>Edge</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Edge</em>'.
	 * @see org.polymodel.verifier.message.AbstractEdgeError#getEdge()
	 * @see #getAbstractEdgeError()
	 * @generated
	 */
	EReference getAbstractEdgeError_Edge();

	/**
	 * Returns the meta object for the containment reference '{@link org.polymodel.verifier.message.AbstractEdgeError#getViolatingDomain <em>Violating Domain</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Violating Domain</em>'.
	 * @see org.polymodel.verifier.message.AbstractEdgeError#getViolatingDomain()
	 * @see #getAbstractEdgeError()
	 * @generated
	 */
	EReference getAbstractEdgeError_ViolatingDomain();

	/**
	 * Returns the meta object for class '{@link org.polymodel.verifier.message.AbstractSpecError <em>Abstract Spec Error</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Abstract Spec Error</em>'.
	 * @see org.polymodel.verifier.message.AbstractSpecError
	 * @generated
	 */
	EClass getAbstractSpecError();

	/**
	 * Returns the meta object for class '{@link org.polymodel.verifier.message.WriteConflictError <em>Write Conflict Error</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Write Conflict Error</em>'.
	 * @see org.polymodel.verifier.message.WriteConflictError
	 * @generated
	 */
	EClass getWriteConflictError();

	/**
	 * Returns the meta object for the attribute '{@link org.polymodel.verifier.message.WriteConflictError#getViolatingDimension <em>Violating Dimension</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Violating Dimension</em>'.
	 * @see org.polymodel.verifier.message.WriteConflictError#getViolatingDimension()
	 * @see #getWriteConflictError()
	 * @generated
	 */
	EAttribute getWriteConflictError_ViolatingDimension();

	/**
	 * Returns the meta object for class '{@link org.polymodel.verifier.message.UnsatisfiedCausalityError <em>Unsatisfied Causality Error</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Unsatisfied Causality Error</em>'.
	 * @see org.polymodel.verifier.message.UnsatisfiedCausalityError
	 * @generated
	 */
	EClass getUnsatisfiedCausalityError();

	/**
	 * Returns the meta object for the attribute '{@link org.polymodel.verifier.message.UnsatisfiedCausalityError#getViolatingDimension <em>Violating Dimension</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Violating Dimension</em>'.
	 * @see org.polymodel.verifier.message.UnsatisfiedCausalityError#getViolatingDimension()
	 * @see #getUnsatisfiedCausalityError()
	 * @generated
	 */
	EAttribute getUnsatisfiedCausalityError_ViolatingDimension();

	/**
	 * Returns the meta object for class '{@link org.polymodel.verifier.message.MismatchedDimensionsError <em>Mismatched Dimensions Error</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Mismatched Dimensions Error</em>'.
	 * @see org.polymodel.verifier.message.MismatchedDimensionsError
	 * @generated
	 */
	EClass getMismatchedDimensionsError();

	/**
	 * Returns the meta object for the attribute '{@link org.polymodel.verifier.message.MismatchedDimensionsError#getMismatchedDimension <em>Mismatched Dimension</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Mismatched Dimension</em>'.
	 * @see org.polymodel.verifier.message.MismatchedDimensionsError#getMismatchedDimension()
	 * @see #getMismatchedDimensionsError()
	 * @generated
	 */
	EAttribute getMismatchedDimensionsError_MismatchedDimension();

	/**
	 * Returns the meta object for class '{@link org.polymodel.verifier.message.MismatchedDimensionalityError <em>Mismatched Dimensionality Error</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Mismatched Dimensionality Error</em>'.
	 * @see org.polymodel.verifier.message.MismatchedDimensionalityError
	 * @generated
	 */
	EClass getMismatchedDimensionalityError();

	/**
	 * Returns the meta object for enum '{@link org.polymodel.verifier.message.CAUSALITY_VIOLATION_TYPE <em>CAUSALITY VIOLATION TYPE</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>CAUSALITY VIOLATION TYPE</em>'.
	 * @see org.polymodel.verifier.message.CAUSALITY_VIOLATION_TYPE
	 * @generated
	 */
	EEnum getCAUSALITY_VIOLATION_TYPE();

	/**
	 * Returns the meta object for enum '{@link org.polymodel.verifier.message.MISMATCHED_DIMENSION_TYPE <em>MISMATCHED DIMENSION TYPE</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>MISMATCHED DIMENSION TYPE</em>'.
	 * @see org.polymodel.verifier.message.MISMATCHED_DIMENSION_TYPE
	 * @generated
	 */
	EEnum getMISMATCHED_DIMENSION_TYPE();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	MessageFactory getMessageFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.polymodel.verifier.message.IVerifierMessage <em>IVerifier Message</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.polymodel.verifier.message.IVerifierMessage
		 * @see org.polymodel.verifier.message.impl.MessagePackageImpl#getIVerifierMessage()
		 * @generated
		 */
		EClass IVERIFIER_MESSAGE = eINSTANCE.getIVerifierMessage();

		/**
		 * The meta object literal for the '{@link org.polymodel.verifier.message.impl.AbstractNodeErrorImpl <em>Abstract Node Error</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.polymodel.verifier.message.impl.AbstractNodeErrorImpl
		 * @see org.polymodel.verifier.message.impl.MessagePackageImpl#getAbstractNodeError()
		 * @generated
		 */
		EClass ABSTRACT_NODE_ERROR = eINSTANCE.getAbstractNodeError();

		/**
		 * The meta object literal for the '<em><b>Node</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ABSTRACT_NODE_ERROR__NODE = eINSTANCE.getAbstractNodeError_Node();

		/**
		 * The meta object literal for the '<em><b>Violating Domain</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ABSTRACT_NODE_ERROR__VIOLATING_DOMAIN = eINSTANCE.getAbstractNodeError_ViolatingDomain();

		/**
		 * The meta object literal for the '{@link org.polymodel.verifier.message.impl.AbstractNodePairErrorImpl <em>Abstract Node Pair Error</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.polymodel.verifier.message.impl.AbstractNodePairErrorImpl
		 * @see org.polymodel.verifier.message.impl.MessagePackageImpl#getAbstractNodePairError()
		 * @generated
		 */
		EClass ABSTRACT_NODE_PAIR_ERROR = eINSTANCE.getAbstractNodePairError();

		/**
		 * The meta object literal for the '<em><b>Node A</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ABSTRACT_NODE_PAIR_ERROR__NODE_A = eINSTANCE.getAbstractNodePairError_NodeA();

		/**
		 * The meta object literal for the '<em><b>Node B</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ABSTRACT_NODE_PAIR_ERROR__NODE_B = eINSTANCE.getAbstractNodePairError_NodeB();

		/**
		 * The meta object literal for the '{@link org.polymodel.verifier.message.impl.AbstractEdgeErrorImpl <em>Abstract Edge Error</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.polymodel.verifier.message.impl.AbstractEdgeErrorImpl
		 * @see org.polymodel.verifier.message.impl.MessagePackageImpl#getAbstractEdgeError()
		 * @generated
		 */
		EClass ABSTRACT_EDGE_ERROR = eINSTANCE.getAbstractEdgeError();

		/**
		 * The meta object literal for the '<em><b>Edge</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ABSTRACT_EDGE_ERROR__EDGE = eINSTANCE.getAbstractEdgeError_Edge();

		/**
		 * The meta object literal for the '<em><b>Violating Domain</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ABSTRACT_EDGE_ERROR__VIOLATING_DOMAIN = eINSTANCE.getAbstractEdgeError_ViolatingDomain();

		/**
		 * The meta object literal for the '{@link org.polymodel.verifier.message.impl.AbstractSpecErrorImpl <em>Abstract Spec Error</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.polymodel.verifier.message.impl.AbstractSpecErrorImpl
		 * @see org.polymodel.verifier.message.impl.MessagePackageImpl#getAbstractSpecError()
		 * @generated
		 */
		EClass ABSTRACT_SPEC_ERROR = eINSTANCE.getAbstractSpecError();

		/**
		 * The meta object literal for the '{@link org.polymodel.verifier.message.impl.WriteConflictErrorImpl <em>Write Conflict Error</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.polymodel.verifier.message.impl.WriteConflictErrorImpl
		 * @see org.polymodel.verifier.message.impl.MessagePackageImpl#getWriteConflictError()
		 * @generated
		 */
		EClass WRITE_CONFLICT_ERROR = eINSTANCE.getWriteConflictError();

		/**
		 * The meta object literal for the '<em><b>Violating Dimension</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute WRITE_CONFLICT_ERROR__VIOLATING_DIMENSION = eINSTANCE.getWriteConflictError_ViolatingDimension();

		/**
		 * The meta object literal for the '{@link org.polymodel.verifier.message.impl.UnsatisfiedCausalityErrorImpl <em>Unsatisfied Causality Error</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.polymodel.verifier.message.impl.UnsatisfiedCausalityErrorImpl
		 * @see org.polymodel.verifier.message.impl.MessagePackageImpl#getUnsatisfiedCausalityError()
		 * @generated
		 */
		EClass UNSATISFIED_CAUSALITY_ERROR = eINSTANCE.getUnsatisfiedCausalityError();

		/**
		 * The meta object literal for the '<em><b>Violating Dimension</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute UNSATISFIED_CAUSALITY_ERROR__VIOLATING_DIMENSION = eINSTANCE.getUnsatisfiedCausalityError_ViolatingDimension();

		/**
		 * The meta object literal for the '{@link org.polymodel.verifier.message.impl.MismatchedDimensionsErrorImpl <em>Mismatched Dimensions Error</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.polymodel.verifier.message.impl.MismatchedDimensionsErrorImpl
		 * @see org.polymodel.verifier.message.impl.MessagePackageImpl#getMismatchedDimensionsError()
		 * @generated
		 */
		EClass MISMATCHED_DIMENSIONS_ERROR = eINSTANCE.getMismatchedDimensionsError();

		/**
		 * The meta object literal for the '<em><b>Mismatched Dimension</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MISMATCHED_DIMENSIONS_ERROR__MISMATCHED_DIMENSION = eINSTANCE.getMismatchedDimensionsError_MismatchedDimension();

		/**
		 * The meta object literal for the '{@link org.polymodel.verifier.message.impl.MismatchedDimensionalityErrorImpl <em>Mismatched Dimensionality Error</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.polymodel.verifier.message.impl.MismatchedDimensionalityErrorImpl
		 * @see org.polymodel.verifier.message.impl.MessagePackageImpl#getMismatchedDimensionalityError()
		 * @generated
		 */
		EClass MISMATCHED_DIMENSIONALITY_ERROR = eINSTANCE.getMismatchedDimensionalityError();

		/**
		 * The meta object literal for the '{@link org.polymodel.verifier.message.CAUSALITY_VIOLATION_TYPE <em>CAUSALITY VIOLATION TYPE</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.polymodel.verifier.message.CAUSALITY_VIOLATION_TYPE
		 * @see org.polymodel.verifier.message.impl.MessagePackageImpl#getCAUSALITY_VIOLATION_TYPE()
		 * @generated
		 */
		EEnum CAUSALITY_VIOLATION_TYPE = eINSTANCE.getCAUSALITY_VIOLATION_TYPE();

		/**
		 * The meta object literal for the '{@link org.polymodel.verifier.message.MISMATCHED_DIMENSION_TYPE <em>MISMATCHED DIMENSION TYPE</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.polymodel.verifier.message.MISMATCHED_DIMENSION_TYPE
		 * @see org.polymodel.verifier.message.impl.MessagePackageImpl#getMISMATCHED_DIMENSION_TYPE()
		 * @generated
		 */
		EEnum MISMATCHED_DIMENSION_TYPE = eINSTANCE.getMISMATCHED_DIMENSION_TYPE();

	}

} //MessagePackage
