package org.polymodel.verifier.message.factory;

import org.polymodel.verifier.VerifierEdge;
import org.polymodel.verifier.VerifierNode;
import org.polymodel.verifier.message.CAUSALITY_VIOLATION_TYPE;
import org.polymodel.verifier.message.MISMATCHED_DIMENSION_TYPE;
import org.polymodel.verifier.message.MessageFactory;
import org.polymodel.verifier.message.MismatchedDimensionalityError;
import org.polymodel.verifier.message.MismatchedDimensionsError;
import org.polymodel.verifier.message.UnsatisfiedCausalityError;
import org.polymodel.verifier.message.WriteConflictError;

import fr.irisa.cairn.model.polymodel.PolyhedralDomain;

public class VerifierMessageUserFactory {
	
	private static MessageFactory factory = MessageFactory.eINSTANCE;
	
	public static WriteConflictError createWriteConflictError(VerifierNode nodeA, VerifierNode nodeB, int violatingDim) {
		WriteConflictError msg = factory.createWriteConflictError();

		msg.setNodeA(nodeA);
		msg.setNodeB(nodeB);
		msg.setViolatingDimension(violatingDim);
		
		return msg;
	}
	
	public static UnsatisfiedCausalityError createCausalityError(VerifierEdge edge, CAUSALITY_VIOLATION_TYPE type, int violatingDim, PolyhedralDomain dom) {
		UnsatisfiedCausalityError msg = factory.createUnsatisfiedCausalityError();
		
		msg.setEdge(edge);
		msg.setType(type);
		msg.setViolatingDimension(violatingDim);
		msg.setViolatingDomain(dom);
		
		return msg;
	}
	
	public static MismatchedDimensionalityError createMismatchedDimensionalityError(MISMATCHED_DIMENSION_TYPE type) {
		MismatchedDimensionalityError msg = factory.createMismatchedDimensionalityError();
		
		msg.setType(type);
		
		return msg;
	}
	
	public static MismatchedDimensionsError createMismatchedDimensionsError(VerifierEdge edge, int dim) {
		MismatchedDimensionsError msg = factory.createMismatchedDimensionsError();
		
		msg.setEdge(edge);
		msg.setMismatchedDimension(dim);
		
		return msg;
	}

}
