/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.polymodel.verifier.message.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.polymodel.verifier.VERBOSITY;
import org.polymodel.verifier.VerifierEdge;
import org.polymodel.verifier.message.AbstractEdgeError;
import org.polymodel.verifier.message.MessagePackage;

import fr.irisa.cairn.model.polymodel.PolyhedralDomain;
import fr.irisa.cairn.model.polymodel.prdg.PRDGEdge;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Abstract Edge Error</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.polymodel.verifier.message.impl.AbstractEdgeErrorImpl#getEdge <em>Edge</em>}</li>
 *   <li>{@link org.polymodel.verifier.message.impl.AbstractEdgeErrorImpl#getViolatingDomain <em>Violating Domain</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public abstract class AbstractEdgeErrorImpl extends EObjectImpl implements AbstractEdgeError {
	/**
	 * The cached value of the '{@link #getEdge() <em>Edge</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEdge()
	 * @generated
	 * @ordered
	 */
	protected VerifierEdge edge;

	/**
	 * The cached value of the '{@link #getViolatingDomain() <em>Violating Domain</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getViolatingDomain()
	 * @generated
	 * @ordered
	 */
	protected PolyhedralDomain violatingDomain;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AbstractEdgeErrorImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return MessagePackage.Literals.ABSTRACT_EDGE_ERROR;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public VerifierEdge getEdge() {
		if (edge != null && edge.eIsProxy()) {
			InternalEObject oldEdge = (InternalEObject)edge;
			edge = (VerifierEdge)eResolveProxy(oldEdge);
			if (edge != oldEdge) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, MessagePackage.ABSTRACT_EDGE_ERROR__EDGE, oldEdge, edge));
			}
		}
		return edge;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public VerifierEdge basicGetEdge() {
		return edge;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEdge(VerifierEdge newEdge) {
		VerifierEdge oldEdge = edge;
		edge = newEdge;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MessagePackage.ABSTRACT_EDGE_ERROR__EDGE, oldEdge, edge));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PolyhedralDomain getViolatingDomain() {
		return violatingDomain;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetViolatingDomain(PolyhedralDomain newViolatingDomain, NotificationChain msgs) {
		PolyhedralDomain oldViolatingDomain = violatingDomain;
		violatingDomain = newViolatingDomain;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, MessagePackage.ABSTRACT_EDGE_ERROR__VIOLATING_DOMAIN, oldViolatingDomain, newViolatingDomain);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setViolatingDomain(PolyhedralDomain newViolatingDomain) {
		if (newViolatingDomain != violatingDomain) {
			NotificationChain msgs = null;
			if (violatingDomain != null)
				msgs = ((InternalEObject)violatingDomain).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - MessagePackage.ABSTRACT_EDGE_ERROR__VIOLATING_DOMAIN, null, msgs);
			if (newViolatingDomain != null)
				msgs = ((InternalEObject)newViolatingDomain).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - MessagePackage.ABSTRACT_EDGE_ERROR__VIOLATING_DOMAIN, null, msgs);
			msgs = basicSetViolatingDomain(newViolatingDomain, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MessagePackage.ABSTRACT_EDGE_ERROR__VIOLATING_DOMAIN, newViolatingDomain, newViolatingDomain));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString(VERBOSITY verbosity) {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case MessagePackage.ABSTRACT_EDGE_ERROR__VIOLATING_DOMAIN:
				return basicSetViolatingDomain(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case MessagePackage.ABSTRACT_EDGE_ERROR__EDGE:
				if (resolve) return getEdge();
				return basicGetEdge();
			case MessagePackage.ABSTRACT_EDGE_ERROR__VIOLATING_DOMAIN:
				return getViolatingDomain();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case MessagePackage.ABSTRACT_EDGE_ERROR__EDGE:
				setEdge((VerifierEdge)newValue);
				return;
			case MessagePackage.ABSTRACT_EDGE_ERROR__VIOLATING_DOMAIN:
				setViolatingDomain((PolyhedralDomain)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case MessagePackage.ABSTRACT_EDGE_ERROR__EDGE:
				setEdge((VerifierEdge)null);
				return;
			case MessagePackage.ABSTRACT_EDGE_ERROR__VIOLATING_DOMAIN:
				setViolatingDomain((PolyhedralDomain)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case MessagePackage.ABSTRACT_EDGE_ERROR__EDGE:
				return edge != null;
			case MessagePackage.ABSTRACT_EDGE_ERROR__VIOLATING_DOMAIN:
				return violatingDomain != null;
		}
		return super.eIsSet(featureID);
	}

} //AbstractEdgeErrorImpl
