/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.polymodel.verifier.message.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.polymodel.verifier.VERBOSITY;
import org.polymodel.verifier.VerifierNode;
import org.polymodel.verifier.message.AbstractNodeError;
import org.polymodel.verifier.message.MessagePackage;

import fr.irisa.cairn.model.polymodel.PolyhedralDomain;
import fr.irisa.cairn.model.polymodel.prdg.PRDGNode;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Abstract Node Error</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.polymodel.verifier.message.impl.AbstractNodeErrorImpl#getNode <em>Node</em>}</li>
 *   <li>{@link org.polymodel.verifier.message.impl.AbstractNodeErrorImpl#getViolatingDomain <em>Violating Domain</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public abstract class AbstractNodeErrorImpl extends EObjectImpl implements AbstractNodeError {
	/**
	 * The cached value of the '{@link #getNode() <em>Node</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNode()
	 * @generated
	 * @ordered
	 */
	protected VerifierNode node;

	/**
	 * The cached value of the '{@link #getViolatingDomain() <em>Violating Domain</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getViolatingDomain()
	 * @generated
	 * @ordered
	 */
	protected PolyhedralDomain violatingDomain;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AbstractNodeErrorImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return MessagePackage.Literals.ABSTRACT_NODE_ERROR;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public VerifierNode getNode() {
		if (node != null && node.eIsProxy()) {
			InternalEObject oldNode = (InternalEObject)node;
			node = (VerifierNode)eResolveProxy(oldNode);
			if (node != oldNode) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, MessagePackage.ABSTRACT_NODE_ERROR__NODE, oldNode, node));
			}
		}
		return node;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public VerifierNode basicGetNode() {
		return node;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setNode(VerifierNode newNode) {
		VerifierNode oldNode = node;
		node = newNode;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MessagePackage.ABSTRACT_NODE_ERROR__NODE, oldNode, node));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PolyhedralDomain getViolatingDomain() {
		return violatingDomain;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetViolatingDomain(PolyhedralDomain newViolatingDomain, NotificationChain msgs) {
		PolyhedralDomain oldViolatingDomain = violatingDomain;
		violatingDomain = newViolatingDomain;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, MessagePackage.ABSTRACT_NODE_ERROR__VIOLATING_DOMAIN, oldViolatingDomain, newViolatingDomain);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setViolatingDomain(PolyhedralDomain newViolatingDomain) {
		if (newViolatingDomain != violatingDomain) {
			NotificationChain msgs = null;
			if (violatingDomain != null)
				msgs = ((InternalEObject)violatingDomain).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - MessagePackage.ABSTRACT_NODE_ERROR__VIOLATING_DOMAIN, null, msgs);
			if (newViolatingDomain != null)
				msgs = ((InternalEObject)newViolatingDomain).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - MessagePackage.ABSTRACT_NODE_ERROR__VIOLATING_DOMAIN, null, msgs);
			msgs = basicSetViolatingDomain(newViolatingDomain, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MessagePackage.ABSTRACT_NODE_ERROR__VIOLATING_DOMAIN, newViolatingDomain, newViolatingDomain));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString(VERBOSITY verbosity) {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case MessagePackage.ABSTRACT_NODE_ERROR__VIOLATING_DOMAIN:
				return basicSetViolatingDomain(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case MessagePackage.ABSTRACT_NODE_ERROR__NODE:
				if (resolve) return getNode();
				return basicGetNode();
			case MessagePackage.ABSTRACT_NODE_ERROR__VIOLATING_DOMAIN:
				return getViolatingDomain();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case MessagePackage.ABSTRACT_NODE_ERROR__NODE:
				setNode((VerifierNode)newValue);
				return;
			case MessagePackage.ABSTRACT_NODE_ERROR__VIOLATING_DOMAIN:
				setViolatingDomain((PolyhedralDomain)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case MessagePackage.ABSTRACT_NODE_ERROR__NODE:
				setNode((VerifierNode)null);
				return;
			case MessagePackage.ABSTRACT_NODE_ERROR__VIOLATING_DOMAIN:
				setViolatingDomain((PolyhedralDomain)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case MessagePackage.ABSTRACT_NODE_ERROR__NODE:
				return node != null;
			case MessagePackage.ABSTRACT_NODE_ERROR__VIOLATING_DOMAIN:
				return violatingDomain != null;
		}
		return super.eIsSet(featureID);
	}

} //AbstractNodeErrorImpl
