/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.polymodel.verifier.message.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.polymodel.verifier.message.*;
import org.polymodel.verifier.message.CAUSALITY_VIOLATION_TYPE;
import org.polymodel.verifier.message.MISMATCHED_DIMENSION_TYPE;
import org.polymodel.verifier.message.MessageFactory;
import org.polymodel.verifier.message.MessagePackage;
import org.polymodel.verifier.message.MismatchedDimensionalityError;
import org.polymodel.verifier.message.MismatchedDimensionsError;
import org.polymodel.verifier.message.UnsatisfiedCausalityError;
import org.polymodel.verifier.message.WriteConflictError;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class MessageFactoryImpl extends EFactoryImpl implements MessageFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static MessageFactory init() {
		try {
			MessageFactory theMessageFactory = (MessageFactory)EPackage.Registry.INSTANCE.getEFactory("http://polymodel/verifier/message"); 
			if (theMessageFactory != null) {
				return theMessageFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new MessageFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MessageFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case MessagePackage.WRITE_CONFLICT_ERROR: return createWriteConflictError();
			case MessagePackage.UNSATISFIED_CAUSALITY_ERROR: return createUnsatisfiedCausalityError();
			case MessagePackage.MISMATCHED_DIMENSIONS_ERROR: return createMismatchedDimensionsError();
			case MessagePackage.MISMATCHED_DIMENSIONALITY_ERROR: return createMismatchedDimensionalityError();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
			case MessagePackage.CAUSALITY_VIOLATION_TYPE:
				return createCAUSALITY_VIOLATION_TYPEFromString(eDataType, initialValue);
			case MessagePackage.MISMATCHED_DIMENSION_TYPE:
				return createMISMATCHED_DIMENSION_TYPEFromString(eDataType, initialValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
			case MessagePackage.CAUSALITY_VIOLATION_TYPE:
				return convertCAUSALITY_VIOLATION_TYPEToString(eDataType, instanceValue);
			case MessagePackage.MISMATCHED_DIMENSION_TYPE:
				return convertMISMATCHED_DIMENSION_TYPEToString(eDataType, instanceValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public WriteConflictError createWriteConflictError() {
		WriteConflictErrorImpl writeConflictError = new WriteConflictErrorImpl();
		return writeConflictError;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public UnsatisfiedCausalityError createUnsatisfiedCausalityError() {
		UnsatisfiedCausalityErrorImpl unsatisfiedCausalityError = new UnsatisfiedCausalityErrorImpl();
		return unsatisfiedCausalityError;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MismatchedDimensionsError createMismatchedDimensionsError() {
		MismatchedDimensionsErrorImpl mismatchedDimensionsError = new MismatchedDimensionsErrorImpl();
		return mismatchedDimensionsError;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MismatchedDimensionalityError createMismatchedDimensionalityError() {
		MismatchedDimensionalityErrorImpl mismatchedDimensionalityError = new MismatchedDimensionalityErrorImpl();
		return mismatchedDimensionalityError;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CAUSALITY_VIOLATION_TYPE createCAUSALITY_VIOLATION_TYPEFromString(EDataType eDataType, String initialValue) {
		CAUSALITY_VIOLATION_TYPE result = CAUSALITY_VIOLATION_TYPE.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertCAUSALITY_VIOLATION_TYPEToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MISMATCHED_DIMENSION_TYPE createMISMATCHED_DIMENSION_TYPEFromString(EDataType eDataType, String initialValue) {
		MISMATCHED_DIMENSION_TYPE result = MISMATCHED_DIMENSION_TYPE.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertMISMATCHED_DIMENSION_TYPEToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MessagePackage getMessagePackage() {
		return (MessagePackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static MessagePackage getPackage() {
		return MessagePackage.eINSTANCE;
	}

} //MessageFactoryImpl
