/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.polymodel.verifier.message.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.polymodel.verifier.VerifierPackage;
import org.polymodel.verifier.impl.VerifierPackageImpl;
import org.polymodel.verifier.message.AbstractEdgeError;
import org.polymodel.verifier.message.AbstractNodeError;
import org.polymodel.verifier.message.AbstractNodePairError;
import org.polymodel.verifier.message.AbstractSpecError;
import org.polymodel.verifier.message.IVerifierMessage;
import org.polymodel.verifier.message.MessageFactory;
import org.polymodel.verifier.message.MessagePackage;
import org.polymodel.verifier.message.MismatchedDimensionalityError;
import org.polymodel.verifier.message.MismatchedDimensionsError;
import org.polymodel.verifier.message.UnsatisfiedCausalityError;
import org.polymodel.verifier.message.WriteConflictError;

import fr.irisa.cairn.model.polymodel.PolymodelPackage;
import fr.irisa.cairn.model.polymodel.prdg.PrdgPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class MessagePackageImpl extends EPackageImpl implements MessagePackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass iVerifierMessageEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass abstractNodeErrorEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass abstractNodePairErrorEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass abstractEdgeErrorEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass abstractSpecErrorEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass writeConflictErrorEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass unsatisfiedCausalityErrorEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass mismatchedDimensionsErrorEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass mismatchedDimensionalityErrorEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum causalitY_VIOLATION_TYPEEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum mismatcheD_DIMENSION_TYPEEEnum = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.polymodel.verifier.message.MessagePackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private MessagePackageImpl() {
		super(eNS_URI, MessageFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 * 
	 * <p>This method is used to initialize {@link MessagePackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static MessagePackage init() {
		if (isInited) return (MessagePackage)EPackage.Registry.INSTANCE.getEPackage(MessagePackage.eNS_URI);

		// Obtain or create and register package
		MessagePackageImpl theMessagePackage = (MessagePackageImpl)(EPackage.Registry.INSTANCE.get(eNS_URI) instanceof MessagePackageImpl ? EPackage.Registry.INSTANCE.get(eNS_URI) : new MessagePackageImpl());

		isInited = true;

		// Initialize simple dependencies
		PolymodelPackage.eINSTANCE.eClass();

		// Obtain or create and register interdependencies
		VerifierPackageImpl theVerifierPackage = (VerifierPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(VerifierPackage.eNS_URI) instanceof VerifierPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(VerifierPackage.eNS_URI) : VerifierPackage.eINSTANCE);

		// Create package meta-data objects
		theMessagePackage.createPackageContents();
		theVerifierPackage.createPackageContents();

		// Initialize created meta-data
		theMessagePackage.initializePackageContents();
		theVerifierPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theMessagePackage.freeze();

  
		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(MessagePackage.eNS_URI, theMessagePackage);
		return theMessagePackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getIVerifierMessage() {
		return iVerifierMessageEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getAbstractNodeError() {
		return abstractNodeErrorEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getAbstractNodeError_Node() {
		return (EReference)abstractNodeErrorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getAbstractNodeError_ViolatingDomain() {
		return (EReference)abstractNodeErrorEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getAbstractNodePairError() {
		return abstractNodePairErrorEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getAbstractNodePairError_NodeA() {
		return (EReference)abstractNodePairErrorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getAbstractNodePairError_NodeB() {
		return (EReference)abstractNodePairErrorEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getAbstractEdgeError() {
		return abstractEdgeErrorEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getAbstractEdgeError_Edge() {
		return (EReference)abstractEdgeErrorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getAbstractEdgeError_ViolatingDomain() {
		return (EReference)abstractEdgeErrorEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getAbstractSpecError() {
		return abstractSpecErrorEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getWriteConflictError() {
		return writeConflictErrorEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getWriteConflictError_ViolatingDimension() {
		return (EAttribute)writeConflictErrorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getUnsatisfiedCausalityError() {
		return unsatisfiedCausalityErrorEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getUnsatisfiedCausalityError_ViolatingDimension() {
		return (EAttribute)unsatisfiedCausalityErrorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getMismatchedDimensionsError() {
		return mismatchedDimensionsErrorEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getMismatchedDimensionsError_MismatchedDimension() {
		return (EAttribute)mismatchedDimensionsErrorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getMismatchedDimensionalityError() {
		return mismatchedDimensionalityErrorEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getCAUSALITY_VIOLATION_TYPE() {
		return causalitY_VIOLATION_TYPEEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getMISMATCHED_DIMENSION_TYPE() {
		return mismatcheD_DIMENSION_TYPEEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MessageFactory getMessageFactory() {
		return (MessageFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		iVerifierMessageEClass = createEClass(IVERIFIER_MESSAGE);

		abstractNodeErrorEClass = createEClass(ABSTRACT_NODE_ERROR);
		createEReference(abstractNodeErrorEClass, ABSTRACT_NODE_ERROR__NODE);
		createEReference(abstractNodeErrorEClass, ABSTRACT_NODE_ERROR__VIOLATING_DOMAIN);

		abstractNodePairErrorEClass = createEClass(ABSTRACT_NODE_PAIR_ERROR);
		createEReference(abstractNodePairErrorEClass, ABSTRACT_NODE_PAIR_ERROR__NODE_A);
		createEReference(abstractNodePairErrorEClass, ABSTRACT_NODE_PAIR_ERROR__NODE_B);

		abstractEdgeErrorEClass = createEClass(ABSTRACT_EDGE_ERROR);
		createEReference(abstractEdgeErrorEClass, ABSTRACT_EDGE_ERROR__EDGE);
		createEReference(abstractEdgeErrorEClass, ABSTRACT_EDGE_ERROR__VIOLATING_DOMAIN);

		abstractSpecErrorEClass = createEClass(ABSTRACT_SPEC_ERROR);

		writeConflictErrorEClass = createEClass(WRITE_CONFLICT_ERROR);
		createEAttribute(writeConflictErrorEClass, WRITE_CONFLICT_ERROR__VIOLATING_DIMENSION);

		unsatisfiedCausalityErrorEClass = createEClass(UNSATISFIED_CAUSALITY_ERROR);
		createEAttribute(unsatisfiedCausalityErrorEClass, UNSATISFIED_CAUSALITY_ERROR__VIOLATING_DIMENSION);

		mismatchedDimensionsErrorEClass = createEClass(MISMATCHED_DIMENSIONS_ERROR);
		createEAttribute(mismatchedDimensionsErrorEClass, MISMATCHED_DIMENSIONS_ERROR__MISMATCHED_DIMENSION);

		mismatchedDimensionalityErrorEClass = createEClass(MISMATCHED_DIMENSIONALITY_ERROR);

		// Create enums
		causalitY_VIOLATION_TYPEEEnum = createEEnum(CAUSALITY_VIOLATION_TYPE);
		mismatcheD_DIMENSION_TYPEEEnum = createEEnum(MISMATCHED_DIMENSION_TYPE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		VerifierPackage theVerifierPackage = (VerifierPackage)EPackage.Registry.INSTANCE.getEPackage(VerifierPackage.eNS_URI);
		PolymodelPackage thePolymodelPackage = (PolymodelPackage)EPackage.Registry.INSTANCE.getEPackage(PolymodelPackage.eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes
		abstractNodeErrorEClass.getESuperTypes().add(this.getIVerifierMessage());
		abstractNodePairErrorEClass.getESuperTypes().add(this.getIVerifierMessage());
		abstractEdgeErrorEClass.getESuperTypes().add(this.getIVerifierMessage());
		abstractSpecErrorEClass.getESuperTypes().add(this.getIVerifierMessage());
		writeConflictErrorEClass.getESuperTypes().add(this.getAbstractNodePairError());
		unsatisfiedCausalityErrorEClass.getESuperTypes().add(this.getAbstractEdgeError());
		mismatchedDimensionsErrorEClass.getESuperTypes().add(this.getAbstractEdgeError());
		mismatchedDimensionalityErrorEClass.getESuperTypes().add(this.getAbstractSpecError());

		// Initialize classes and features; add operations and parameters
		initEClass(iVerifierMessageEClass, IVerifierMessage.class, "IVerifierMessage", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		EOperation op = addEOperation(iVerifierMessageEClass, ecorePackage.getEString(), "toString", 1, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, theVerifierPackage.getVERBOSITY(), "verbosity", 1, 1, IS_UNIQUE, IS_ORDERED);

		initEClass(abstractNodeErrorEClass, AbstractNodeError.class, "AbstractNodeError", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getAbstractNodeError_Node(), theVerifierPackage.getVerifierNode(), null, "node", null, 1, 1, AbstractNodeError.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getAbstractNodeError_ViolatingDomain(), thePolymodelPackage.getPolyhedralDomain(), null, "violatingDomain", null, 1, 1, AbstractNodeError.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(abstractNodePairErrorEClass, AbstractNodePairError.class, "AbstractNodePairError", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getAbstractNodePairError_NodeA(), theVerifierPackage.getVerifierNode(), null, "nodeA", null, 1, 1, AbstractNodePairError.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getAbstractNodePairError_NodeB(), theVerifierPackage.getVerifierNode(), null, "nodeB", null, 1, 1, AbstractNodePairError.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(abstractEdgeErrorEClass, AbstractEdgeError.class, "AbstractEdgeError", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getAbstractEdgeError_Edge(), theVerifierPackage.getVerifierEdge(), null, "edge", null, 1, 1, AbstractEdgeError.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getAbstractEdgeError_ViolatingDomain(), thePolymodelPackage.getPolyhedralDomain(), null, "violatingDomain", null, 1, 1, AbstractEdgeError.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(abstractSpecErrorEClass, AbstractSpecError.class, "AbstractSpecError", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(writeConflictErrorEClass, WriteConflictError.class, "WriteConflictError", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getWriteConflictError_ViolatingDimension(), ecorePackage.getEInt(), "violatingDimension", null, 1, 1, WriteConflictError.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(unsatisfiedCausalityErrorEClass, UnsatisfiedCausalityError.class, "UnsatisfiedCausalityError", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getUnsatisfiedCausalityError_ViolatingDimension(), ecorePackage.getEInt(), "violatingDimension", null, 1, 1, UnsatisfiedCausalityError.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		addEOperation(unsatisfiedCausalityErrorEClass, this.getCAUSALITY_VIOLATION_TYPE(), "getType", 1, 1, IS_UNIQUE, IS_ORDERED);

		op = addEOperation(unsatisfiedCausalityErrorEClass, null, "setType", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, this.getCAUSALITY_VIOLATION_TYPE(), "type", 1, 1, IS_UNIQUE, IS_ORDERED);

		initEClass(mismatchedDimensionsErrorEClass, MismatchedDimensionsError.class, "MismatchedDimensionsError", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getMismatchedDimensionsError_MismatchedDimension(), ecorePackage.getEInt(), "mismatchedDimension", null, 0, 1, MismatchedDimensionsError.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(mismatchedDimensionalityErrorEClass, MismatchedDimensionalityError.class, "MismatchedDimensionalityError", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		addEOperation(mismatchedDimensionalityErrorEClass, this.getMISMATCHED_DIMENSION_TYPE(), "getType", 1, 1, IS_UNIQUE, IS_ORDERED);

		op = addEOperation(mismatchedDimensionalityErrorEClass, null, "setType", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, this.getMISMATCHED_DIMENSION_TYPE(), "type", 1, 1, IS_UNIQUE, IS_ORDERED);

		// Initialize enums and add enum literals
		initEEnum(causalitY_VIOLATION_TYPEEEnum, org.polymodel.verifier.message.CAUSALITY_VIOLATION_TYPE.class, "CAUSALITY_VIOLATION_TYPE");
		addEEnumLiteral(causalitY_VIOLATION_TYPEEEnum, org.polymodel.verifier.message.CAUSALITY_VIOLATION_TYPE.TIME);
		addEEnumLiteral(causalitY_VIOLATION_TYPEEEnum, org.polymodel.verifier.message.CAUSALITY_VIOLATION_TYPE.PROCESSOR);
		addEEnumLiteral(causalitY_VIOLATION_TYPEEEnum, org.polymodel.verifier.message.CAUSALITY_VIOLATION_TYPE.UNSATISFIED);

		initEEnum(mismatcheD_DIMENSION_TYPEEEnum, org.polymodel.verifier.message.MISMATCHED_DIMENSION_TYPE.class, "MISMATCHED_DIMENSION_TYPE");
		addEEnumLiteral(mismatcheD_DIMENSION_TYPEEEnum, org.polymodel.verifier.message.MISMATCHED_DIMENSION_TYPE.SCHEDULES);
		addEEnumLiteral(mismatcheD_DIMENSION_TYPEEEnum, org.polymodel.verifier.message.MISMATCHED_DIMENSION_TYPE.DIM_TYPES);
	}

} //MessagePackageImpl
