/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.polymodel.verifier.message.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.EObject;
import org.polymodel.verifier.message.*;
import org.polymodel.verifier.message.AbstractEdgeError;
import org.polymodel.verifier.message.AbstractNodeError;
import org.polymodel.verifier.message.AbstractNodePairError;
import org.polymodel.verifier.message.AbstractSpecError;
import org.polymodel.verifier.message.IVerifierMessage;
import org.polymodel.verifier.message.MessagePackage;
import org.polymodel.verifier.message.MismatchedDimensionalityError;
import org.polymodel.verifier.message.MismatchedDimensionsError;
import org.polymodel.verifier.message.UnsatisfiedCausalityError;
import org.polymodel.verifier.message.WriteConflictError;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see org.polymodel.verifier.message.MessagePackage
 * @generated
 */
public class MessageAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static MessagePackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MessageAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = MessagePackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MessageSwitch<Adapter> modelSwitch =
		new MessageSwitch<Adapter>() {
			@Override
			public Adapter caseIVerifierMessage(IVerifierMessage object) {
				return createIVerifierMessageAdapter();
			}
			@Override
			public Adapter caseAbstractNodeError(AbstractNodeError object) {
				return createAbstractNodeErrorAdapter();
			}
			@Override
			public Adapter caseAbstractNodePairError(AbstractNodePairError object) {
				return createAbstractNodePairErrorAdapter();
			}
			@Override
			public Adapter caseAbstractEdgeError(AbstractEdgeError object) {
				return createAbstractEdgeErrorAdapter();
			}
			@Override
			public Adapter caseAbstractSpecError(AbstractSpecError object) {
				return createAbstractSpecErrorAdapter();
			}
			@Override
			public Adapter caseWriteConflictError(WriteConflictError object) {
				return createWriteConflictErrorAdapter();
			}
			@Override
			public Adapter caseUnsatisfiedCausalityError(UnsatisfiedCausalityError object) {
				return createUnsatisfiedCausalityErrorAdapter();
			}
			@Override
			public Adapter caseMismatchedDimensionsError(MismatchedDimensionsError object) {
				return createMismatchedDimensionsErrorAdapter();
			}
			@Override
			public Adapter caseMismatchedDimensionalityError(MismatchedDimensionalityError object) {
				return createMismatchedDimensionalityErrorAdapter();
			}
			@Override
			public Adapter defaultCase(EObject object) {
				return createEObjectAdapter();
			}
		};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter(Notifier target) {
		return modelSwitch.doSwitch((EObject)target);
	}


	/**
	 * Creates a new adapter for an object of class '{@link org.polymodel.verifier.message.IVerifierMessage <em>IVerifier Message</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.polymodel.verifier.message.IVerifierMessage
	 * @generated
	 */
	public Adapter createIVerifierMessageAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.polymodel.verifier.message.AbstractNodeError <em>Abstract Node Error</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.polymodel.verifier.message.AbstractNodeError
	 * @generated
	 */
	public Adapter createAbstractNodeErrorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.polymodel.verifier.message.AbstractNodePairError <em>Abstract Node Pair Error</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.polymodel.verifier.message.AbstractNodePairError
	 * @generated
	 */
	public Adapter createAbstractNodePairErrorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.polymodel.verifier.message.AbstractEdgeError <em>Abstract Edge Error</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.polymodel.verifier.message.AbstractEdgeError
	 * @generated
	 */
	public Adapter createAbstractEdgeErrorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.polymodel.verifier.message.AbstractSpecError <em>Abstract Spec Error</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.polymodel.verifier.message.AbstractSpecError
	 * @generated
	 */
	public Adapter createAbstractSpecErrorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.polymodel.verifier.message.WriteConflictError <em>Write Conflict Error</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.polymodel.verifier.message.WriteConflictError
	 * @generated
	 */
	public Adapter createWriteConflictErrorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.polymodel.verifier.message.UnsatisfiedCausalityError <em>Unsatisfied Causality Error</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.polymodel.verifier.message.UnsatisfiedCausalityError
	 * @generated
	 */
	public Adapter createUnsatisfiedCausalityErrorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.polymodel.verifier.message.MismatchedDimensionsError <em>Mismatched Dimensions Error</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.polymodel.verifier.message.MismatchedDimensionsError
	 * @generated
	 */
	public Adapter createMismatchedDimensionsErrorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.polymodel.verifier.message.MismatchedDimensionalityError <em>Mismatched Dimensionality Error</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.polymodel.verifier.message.MismatchedDimensionalityError
	 * @generated
	 */
	public Adapter createMismatchedDimensionalityErrorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} //MessageAdapterFactory
