/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.polymodel.verifier.message.util;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.Switch;
import org.polymodel.verifier.message.*;
import org.polymodel.verifier.message.AbstractEdgeError;
import org.polymodel.verifier.message.AbstractNodeError;
import org.polymodel.verifier.message.AbstractNodePairError;
import org.polymodel.verifier.message.AbstractSpecError;
import org.polymodel.verifier.message.IVerifierMessage;
import org.polymodel.verifier.message.MessagePackage;
import org.polymodel.verifier.message.MismatchedDimensionalityError;
import org.polymodel.verifier.message.MismatchedDimensionsError;
import org.polymodel.verifier.message.UnsatisfiedCausalityError;
import org.polymodel.verifier.message.WriteConflictError;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.polymodel.verifier.message.MessagePackage
 * @generated
 */
public class MessageSwitch<T> extends Switch<T> {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static MessagePackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MessageSwitch() {
		if (modelPackage == null) {
			modelPackage = MessagePackage.eINSTANCE;
		}
	}

	/**
	 * Checks whether this is a switch for the given package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @parameter ePackage the package in question.
	 * @return whether this is a switch for the given package.
	 * @generated
	 */
	@Override
	protected boolean isSwitchFor(EPackage ePackage) {
		return ePackage == modelPackage;
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	@Override
	protected T doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case MessagePackage.IVERIFIER_MESSAGE: {
				IVerifierMessage iVerifierMessage = (IVerifierMessage)theEObject;
				T result = caseIVerifierMessage(iVerifierMessage);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MessagePackage.ABSTRACT_NODE_ERROR: {
				AbstractNodeError abstractNodeError = (AbstractNodeError)theEObject;
				T result = caseAbstractNodeError(abstractNodeError);
				if (result == null) result = caseIVerifierMessage(abstractNodeError);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MessagePackage.ABSTRACT_NODE_PAIR_ERROR: {
				AbstractNodePairError abstractNodePairError = (AbstractNodePairError)theEObject;
				T result = caseAbstractNodePairError(abstractNodePairError);
				if (result == null) result = caseIVerifierMessage(abstractNodePairError);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MessagePackage.ABSTRACT_EDGE_ERROR: {
				AbstractEdgeError abstractEdgeError = (AbstractEdgeError)theEObject;
				T result = caseAbstractEdgeError(abstractEdgeError);
				if (result == null) result = caseIVerifierMessage(abstractEdgeError);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MessagePackage.ABSTRACT_SPEC_ERROR: {
				AbstractSpecError abstractSpecError = (AbstractSpecError)theEObject;
				T result = caseAbstractSpecError(abstractSpecError);
				if (result == null) result = caseIVerifierMessage(abstractSpecError);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MessagePackage.WRITE_CONFLICT_ERROR: {
				WriteConflictError writeConflictError = (WriteConflictError)theEObject;
				T result = caseWriteConflictError(writeConflictError);
				if (result == null) result = caseAbstractNodePairError(writeConflictError);
				if (result == null) result = caseIVerifierMessage(writeConflictError);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MessagePackage.UNSATISFIED_CAUSALITY_ERROR: {
				UnsatisfiedCausalityError unsatisfiedCausalityError = (UnsatisfiedCausalityError)theEObject;
				T result = caseUnsatisfiedCausalityError(unsatisfiedCausalityError);
				if (result == null) result = caseAbstractEdgeError(unsatisfiedCausalityError);
				if (result == null) result = caseIVerifierMessage(unsatisfiedCausalityError);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MessagePackage.MISMATCHED_DIMENSIONS_ERROR: {
				MismatchedDimensionsError mismatchedDimensionsError = (MismatchedDimensionsError)theEObject;
				T result = caseMismatchedDimensionsError(mismatchedDimensionsError);
				if (result == null) result = caseAbstractEdgeError(mismatchedDimensionsError);
				if (result == null) result = caseIVerifierMessage(mismatchedDimensionsError);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MessagePackage.MISMATCHED_DIMENSIONALITY_ERROR: {
				MismatchedDimensionalityError mismatchedDimensionalityError = (MismatchedDimensionalityError)theEObject;
				T result = caseMismatchedDimensionalityError(mismatchedDimensionalityError);
				if (result == null) result = caseAbstractSpecError(mismatchedDimensionalityError);
				if (result == null) result = caseIVerifierMessage(mismatchedDimensionalityError);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>IVerifier Message</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>IVerifier Message</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIVerifierMessage(IVerifierMessage object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Abstract Node Error</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Abstract Node Error</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAbstractNodeError(AbstractNodeError object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Abstract Node Pair Error</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Abstract Node Pair Error</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAbstractNodePairError(AbstractNodePairError object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Abstract Edge Error</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Abstract Edge Error</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAbstractEdgeError(AbstractEdgeError object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Abstract Spec Error</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Abstract Spec Error</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAbstractSpecError(AbstractSpecError object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Write Conflict Error</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Write Conflict Error</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseWriteConflictError(WriteConflictError object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Unsatisfied Causality Error</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Unsatisfied Causality Error</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseUnsatisfiedCausalityError(UnsatisfiedCausalityError object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Mismatched Dimensions Error</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Mismatched Dimensions Error</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMismatchedDimensionsError(MismatchedDimensionsError object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Mismatched Dimensionality Error</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Mismatched Dimensionality Error</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMismatchedDimensionalityError(MismatchedDimensionalityError object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	@Override
	public T defaultCase(EObject object) {
		return null;
	}

} //MessageSwitch
