package fr.irisa.cairn.model.integerLinearAlgebra.tom;

import tom.library.sl.*;
import java.util.List;

  

import fr.irisa.cairn.model.integerLinearAlgebra.*;
import fr.irisa.cairn.model.integerLinearAlgebra.adapter.*;
import static fr.irisa.cairn.model.integerLinearAlgebra.factory.IntegerExpressionUserFactory.*;
import fr.irisa.cairn.model.integerLinearAlgebra.factory.IntegerExpressionUserFactory;
import java.util.List;
import tom.library.sl.VisitFailure;

/**
 * Variable isolation tool.
 * 
 * @author antoine
 * 
 */
public class Isolate{

	%include { sl.tom }
	%include { integerlinearalgebra.tom}

	private static boolean DEBUG=false;

	private static void debug(String mess) {
		if(DEBUG) {
			System.out.println(mess);
		}
	}
	/**
	 * Build an expression corresponding to a variable isolation. Variable is removed and
	 * other terms are negated. Input expression isn't modified.
	 * 
	 * @param expression 
	 * @param var variable to isolate
	 * @return a new expression
	 */
	public static IntExpression isolate(IntExpression expression, IVariable var) {
		try {
			IntExpressionAdapter adapter = (IntExpressionAdapter)
					`OnceTopDown(VariableIsolation(var)).visitLight(new IntExpressionAdapter(expression.simplify()));
			return adapter.expr().simplify();
		} catch(Exception e) { 
			e.printStackTrace(); 
			throw new RuntimeException("Visitor failure on "+expression+ ":"+e.getMessage());
		}
	}

	%strategy VariableIsolation(var:Variable) extends Identity() {
		visit IntExpression {
			a@sum(list(x1*,b@term(k,var),x2*)) 	-> { 
				if(`var==var) {
					debug("Rule 1 on "+`a.expr()+" with " +`var+" for "+var);
					switch (`k) {
					case 1:
						return `mul(-1,sum(list(x1,x2))); 
					case -1:
						return `sum(list(x1,x2)); 
					default:
						return `floord(mul(-1,sum(list(x1,x2))),k); 
					}
				}		 		
			}
			a@sum(list(x0,x1*,b@term(k,var),x2*)) 	-> { 
				if(`var==var) {
					debug("Rule 1 on "+`a.expr()+" with " +`var+" for "+var);
					switch (`k) {
					case 1:
						return `mul(-1,sum(list(x0,x1,x2))); 
					case -1:
						return `sum(list(x0,x1,x2)); 
					default:
						return `floord(mul(-1,sum(list(x0,x1,x2))),k); 
					}
				}		 		
			}
			a@sum(list(x1*,term(k,var),x2*,x3)) 	-> { 
				if(`var==var) {
					debug("Rule 2 on "+`a.expr()+" with " +`var+" for "+var);
					switch (`k) {
					case 1:
						return `mul(-1,sum(list(x1,x2,x3))); 
					case -1:
						return `sum(list(x1,x2,x3)); 
					default:
						return `floord(mul(-1,sum(list(x1,x2,x3))),k); 
					}
				}
		
			}
			a -> {
					debug("Fail on "+`a.expr()+" with " +`var+" for "+var);`
					throw new RuntimeException("Fail in Isolate("+`a.expr()+") for "+var);
			}
	
		} 
	}
}