package fr.irisa.cairn.model.integerLinearAlgebra.tom;

import tom.library.sl.*;
import java.util.List;

  

import fr.irisa.cairn.model.integerLinearAlgebra.*;
import fr.irisa.cairn.model.integerLinearAlgebra.adapter.*;
import static fr.irisa.cairn.model.integerLinearAlgebra.factory.IntegerExpressionUserFactory.*;
import fr.irisa.cairn.model.integerLinearAlgebra.factory.IntegerExpressionUserFactory;
import java.util.List;
import tom.library.sl.VisitFailure;

/**
 * Variable isolation tool.
 * 
 * @author antoine
 * 
 */
public class Replace{

	%include { sl.tom }
	%include { integerlinearalgebra.tom}

	/**
	 * Build an expression corresponding to a variable isolation. Variable is removed and
	 * other terms are negated. Input expression isn't modified.
	 * 
	 * @param expression 
	 * @param var variable to isolate
	 * @return a new expression
	 */
	static IntExpression newExpr;

	public static IntExpression replace(IntExpression expression, IVariable var,IntExpression anewExpr) {
		try {
			newExpr=anewExpr;
			IntExpressionAdapter adapter = (IntExpressionAdapter)
					`OnceTopDown(VariableReplacement(var)).visitLight(new IntExpressionAdapter(expression.copy()));
			return adapter.expr().simplify();
		} catch(Exception e) { 
			e.printStackTrace(); 
			throw new RuntimeException("Visitor failure on "+expression+ ":"+e.getMessage());
		}
	}

	%strategy VariableReplacement(var:Variable) extends Identity() {
		visit IntExpression {
			term(k,var) -> { 
				IntExpressionAdapter newRes = new IntExpressionAdapter(newExpr.copy()); 
				switch (`k) {
					case 1:
						return newRes; 
				default:
						return `mul(k,newRes); 
				}
			}
	
		} 
	}
}