/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package fr.irisa.cairn.model.integerLinearAlgebra;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntegerLinearAlgebraFactory
 * @model kind="package"
 * @generated
 */
public interface IntegerLinearAlgebraPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "integerLinearAlgebra";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://integerLinearAlgebra/1.0/";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "integerLinearAlgebra";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	IntegerLinearAlgebraPackage eINSTANCE = fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl.init();

	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerMappingExpressionImpl <em>Integer Mapping Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerMappingExpressionImpl
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntegerMappingExpression()
	 * @generated
	 */
	int INTEGER_MAPPING_EXPRESSION = 0;

	/**
	 * The feature id for the '<em><b>Src</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTEGER_MAPPING_EXPRESSION__SRC = 0;

	/**
	 * The feature id for the '<em><b>Dst</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTEGER_MAPPING_EXPRESSION__DST = 1;

	/**
	 * The number of structural features of the '<em>Integer Mapping Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTEGER_MAPPING_EXPRESSION_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.ScopeContainer <em>Scope Container</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.ScopeContainer
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getScopeContainer()
	 * @generated
	 */
	int SCOPE_CONTAINER = 3;

	/**
	 * The feature id for the '<em><b>Scope</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCOPE_CONTAINER__SCOPE = 0;

	/**
	 * The number of structural features of the '<em>Scope Container</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCOPE_CONTAINER_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearConstraintProblemImpl <em>Integer Linear Constraint Problem</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearConstraintProblemImpl
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntegerLinearConstraintProblem()
	 * @generated
	 */
	int INTEGER_LINEAR_CONSTRAINT_PROBLEM = 1;

	/**
	 * The feature id for the '<em><b>Scope</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTEGER_LINEAR_CONSTRAINT_PROBLEM__SCOPE = SCOPE_CONTAINER__SCOPE;

	/**
	 * The feature id for the '<em><b>System</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTEGER_LINEAR_CONSTRAINT_PROBLEM__SYSTEM = SCOPE_CONTAINER_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Integer Linear Constraint Problem</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTEGER_LINEAR_CONSTRAINT_PROBLEM_FEATURE_COUNT = SCOPE_CONTAINER_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.IPrettyPrint <em>IPretty Print</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IPrettyPrint
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIPrettyPrint()
	 * @generated
	 */
	int IPRETTY_PRINT = 2;

	/**
	 * The number of structural features of the '<em>IPretty Print</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IPRETTY_PRINT_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.ScopeImpl <em>Scope</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.ScopeImpl
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getScope()
	 * @generated
	 */
	int SCOPE = 4;

	/**
	 * The feature id for the '<em><b>Symbols</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCOPE__SYMBOLS = 0;

	/**
	 * The number of structural features of the '<em>Scope</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCOPE_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.IVariable <em>IVariable</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IVariable
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIVariable()
	 * @generated
	 */
	int IVARIABLE = 5;

	/**
	 * The number of structural features of the '<em>IVariable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IVARIABLE_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntExpressionImpl <em>Int Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntExpressionImpl
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntExpression()
	 * @generated
	 */
	int INT_EXPRESSION = 6;

	/**
	 * The number of structural features of the '<em>Int Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_EXPRESSION_FEATURE_COUNT = IPRETTY_PRINT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntMaxImpl <em>Int Max</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntMaxImpl
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntMax()
	 * @generated
	 */
	int INT_MAX = 7;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_MAX__WIDTH = INT_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Signed</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_MAX__SIGNED = INT_EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Int Max</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_MAX_FEATURE_COUNT = INT_EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntMinImpl <em>Int Min</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntMinImpl
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntMin()
	 * @generated
	 */
	int INT_MIN = 8;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_MIN__WIDTH = INT_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Signed</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_MIN__SIGNED = INT_EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Int Min</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_MIN_FEATURE_COUNT = INT_EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntTermExpressionImpl <em>Int Term Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntTermExpressionImpl
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntTermExpression()
	 * @generated
	 */
	int INT_TERM_EXPRESSION = 9;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_TERM_EXPRESSION__VALUE = INT_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Var</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_TERM_EXPRESSION__VAR = INT_EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Int Term Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_TERM_EXPRESSION_FEATURE_COUNT = INT_EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntDivExpressionImpl <em>Int Div Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntDivExpressionImpl
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntDivExpression()
	 * @generated
	 */
	int INT_DIV_EXPRESSION = 10;

	/**
	 * The feature id for the '<em><b>Denum</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_DIV_EXPRESSION__DENUM = INT_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Expr</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_DIV_EXPRESSION__EXPR = INT_EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Int Div Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_DIV_EXPRESSION_FEATURE_COUNT = INT_EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntModExpressionImpl <em>Int Mod Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntModExpressionImpl
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntModExpression()
	 * @generated
	 */
	int INT_MOD_EXPRESSION = 11;

	/**
	 * The feature id for the '<em><b>Denum</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_MOD_EXPRESSION__DENUM = INT_DIV_EXPRESSION__DENUM;

	/**
	 * The feature id for the '<em><b>Expr</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_MOD_EXPRESSION__EXPR = INT_DIV_EXPRESSION__EXPR;

	/**
	 * The number of structural features of the '<em>Int Mod Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_MOD_EXPRESSION_FEATURE_COUNT = INT_DIV_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntFloorDExpressionImpl <em>Int Floor DExpression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntFloorDExpressionImpl
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntFloorDExpression()
	 * @generated
	 */
	int INT_FLOOR_DEXPRESSION = 12;

	/**
	 * The feature id for the '<em><b>Denum</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_FLOOR_DEXPRESSION__DENUM = INT_DIV_EXPRESSION__DENUM;

	/**
	 * The feature id for the '<em><b>Expr</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_FLOOR_DEXPRESSION__EXPR = INT_DIV_EXPRESSION__EXPR;

	/**
	 * The number of structural features of the '<em>Int Floor DExpression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_FLOOR_DEXPRESSION_FEATURE_COUNT = INT_DIV_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntCeilDExpressionImpl <em>Int Ceil DExpression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntCeilDExpressionImpl
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntCeilDExpression()
	 * @generated
	 */
	int INT_CEIL_DEXPRESSION = 13;

	/**
	 * The feature id for the '<em><b>Denum</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_CEIL_DEXPRESSION__DENUM = INT_DIV_EXPRESSION__DENUM;

	/**
	 * The feature id for the '<em><b>Expr</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_CEIL_DEXPRESSION__EXPR = INT_DIV_EXPRESSION__EXPR;

	/**
	 * The number of structural features of the '<em>Int Ceil DExpression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_CEIL_DEXPRESSION_FEATURE_COUNT = INT_DIV_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntMulExpressionImpl <em>Int Mul Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntMulExpressionImpl
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntMulExpression()
	 * @generated
	 */
	int INT_MUL_EXPRESSION = 14;

	/**
	 * The feature id for the '<em><b>Factor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_MUL_EXPRESSION__FACTOR = INT_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Expr</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_MUL_EXPRESSION__EXPR = INT_EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Int Mul Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_MUL_EXPRESSION_FEATURE_COUNT = INT_EXPRESSION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntReductionExpressionImpl <em>Int Reduction Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntReductionExpressionImpl
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntReductionExpression()
	 * @generated
	 */
	int INT_REDUCTION_EXPRESSION = 15;

	/**
	 * The feature id for the '<em><b>Terms</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_REDUCTION_EXPRESSION__TERMS = INT_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Int Reduction Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_REDUCTION_EXPRESSION_FEATURE_COUNT = INT_EXPRESSION_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntSumExpressionImpl <em>Int Sum Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntSumExpressionImpl
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntSumExpression()
	 * @generated
	 */
	int INT_SUM_EXPRESSION = 16;

	/**
	 * The feature id for the '<em><b>Terms</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_SUM_EXPRESSION__TERMS = INT_REDUCTION_EXPRESSION__TERMS;

	/**
	 * The number of structural features of the '<em>Int Sum Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_SUM_EXPRESSION_FEATURE_COUNT = INT_REDUCTION_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntProdExpressionImpl <em>Int Prod Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntProdExpressionImpl
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntProdExpression()
	 * @generated
	 */
	int INT_PROD_EXPRESSION = 17;

	/**
	 * The feature id for the '<em><b>Terms</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_PROD_EXPRESSION__TERMS = INT_REDUCTION_EXPRESSION__TERMS;

	/**
	 * The number of structural features of the '<em>Int Prod Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_PROD_EXPRESSION_FEATURE_COUNT = INT_REDUCTION_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntLinearExpressionImpl <em>Int Linear Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntLinearExpressionImpl
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntLinearExpression()
	 * @generated
	 */
	int INT_LINEAR_EXPRESSION = 18;

	/**
	 * The feature id for the '<em><b>Terms</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_LINEAR_EXPRESSION__TERMS = INT_SUM_EXPRESSION__TERMS;

	/**
	 * The number of structural features of the '<em>Int Linear Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_LINEAR_EXPRESSION_FEATURE_COUNT = INT_SUM_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntMaxExpressionImpl <em>Int Max Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntMaxExpressionImpl
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntMaxExpression()
	 * @generated
	 */
	int INT_MAX_EXPRESSION = 19;

	/**
	 * The feature id for the '<em><b>Terms</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_MAX_EXPRESSION__TERMS = INT_REDUCTION_EXPRESSION__TERMS;

	/**
	 * The number of structural features of the '<em>Int Max Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_MAX_EXPRESSION_FEATURE_COUNT = INT_REDUCTION_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntMinExpressionImpl <em>Int Min Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntMinExpressionImpl
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntMinExpression()
	 * @generated
	 */
	int INT_MIN_EXPRESSION = 20;

	/**
	 * The feature id for the '<em><b>Terms</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_MIN_EXPRESSION__TERMS = INT_REDUCTION_EXPRESSION__TERMS;

	/**
	 * The number of structural features of the '<em>Int Min Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_MIN_EXPRESSION_FEATURE_COUNT = INT_REDUCTION_EXPRESSION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntConstraintSystemImpl <em>Int Constraint System</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntConstraintSystemImpl
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntConstraintSystem()
	 * @generated
	 */
	int INT_CONSTRAINT_SYSTEM = 25;

	/**
	 * The feature id for the '<em><b>Constraints</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_CONSTRAINT_SYSTEM__CONSTRAINTS = IPRETTY_PRINT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Scope Containter</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_CONSTRAINT_SYSTEM__SCOPE_CONTAINTER = IPRETTY_PRINT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Int Constraint System</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_CONSTRAINT_SYSTEM_FEATURE_COUNT = IPRETTY_PRINT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntLinearConstraintSystemImpl <em>Int Linear Constraint System</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntLinearConstraintSystemImpl
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntLinearConstraintSystem()
	 * @generated
	 */
	int INT_LINEAR_CONSTRAINT_SYSTEM = 21;

	/**
	 * The feature id for the '<em><b>Constraints</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_LINEAR_CONSTRAINT_SYSTEM__CONSTRAINTS = INT_CONSTRAINT_SYSTEM__CONSTRAINTS;

	/**
	 * The feature id for the '<em><b>Scope Containter</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_LINEAR_CONSTRAINT_SYSTEM__SCOPE_CONTAINTER = INT_CONSTRAINT_SYSTEM__SCOPE_CONTAINTER;

	/**
	 * The feature id for the '<em><b>Linear Constraints</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_LINEAR_CONSTRAINT_SYSTEM__LINEAR_CONSTRAINTS = INT_CONSTRAINT_SYSTEM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Int Linear Constraint System</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_LINEAR_CONSTRAINT_SYSTEM_FEATURE_COUNT = INT_CONSTRAINT_SYSTEM_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntLinearConstraintImpl <em>Int Linear Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntLinearConstraintImpl
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntLinearConstraint()
	 * @generated
	 */
	int INT_LINEAR_CONSTRAINT = 22;

	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.SymbolVariableImpl <em>Symbol Variable</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.SymbolVariableImpl
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getSymbolVariable()
	 * @generated
	 */
	int SYMBOL_VARIABLE = 23;

	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntConstraintImpl <em>Int Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntConstraintImpl
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntConstraint()
	 * @generated
	 */
	int INT_CONSTRAINT = 24;

	/**
	 * The feature id for the '<em><b>Comparison Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_CONSTRAINT__COMPARISON_OPERATOR = IPRETTY_PRINT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Expr</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_CONSTRAINT__EXPR = IPRETTY_PRINT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Int Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_CONSTRAINT_FEATURE_COUNT = IPRETTY_PRINT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Comparison Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_LINEAR_CONSTRAINT__COMPARISON_OPERATOR = INT_CONSTRAINT__COMPARISON_OPERATOR;

	/**
	 * The feature id for the '<em><b>Expr</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_LINEAR_CONSTRAINT__EXPR = INT_CONSTRAINT__EXPR;

	/**
	 * The feature id for the '<em><b>Linexpr</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_LINEAR_CONSTRAINT__LINEXPR = INT_CONSTRAINT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Int Linear Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_LINEAR_CONSTRAINT_FEATURE_COUNT = INT_CONSTRAINT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYMBOL_VARIABLE__NAME = IVARIABLE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Symbol Variable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYMBOL_VARIABLE_FEATURE_COUNT = IVARIABLE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerMappingSystemImpl <em>Integer Mapping System</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerMappingSystemImpl
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntegerMappingSystem()
	 * @generated
	 */
	int INTEGER_MAPPING_SYSTEM = 26;

	/**
	 * The feature id for the '<em><b>Mappings</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTEGER_MAPPING_SYSTEM__MAPPINGS = 0;

	/**
	 * The number of structural features of the '<em>Integer Mapping System</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTEGER_MAPPING_SYSTEM_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntConstraintExpressionImpl <em>Int Constraint Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntConstraintExpressionImpl
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntConstraintExpression()
	 * @generated
	 */
	int INT_CONSTRAINT_EXPRESSION = 27;

	/**
	 * The feature id for the '<em><b>Comparison Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_CONSTRAINT_EXPRESSION__COMPARISON_OPERATOR = IPRETTY_PRINT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Lhs</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_CONSTRAINT_EXPRESSION__LHS = IPRETTY_PRINT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Rhs</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_CONSTRAINT_EXPRESSION__RHS = IPRETTY_PRINT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Int Constraint Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INT_CONSTRAINT_EXPRESSION_FEATURE_COUNT = IPRETTY_PRINT_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.Operator <em>Operator</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.Operator
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getOperator()
	 * @generated
	 */
	int OPERATOR = 28;


	/**
	 * The meta object id for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.OUTPUT_FORMAT <em>OUTPUT FORMAT</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.OUTPUT_FORMAT
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getOUTPUT_FORMAT()
	 * @generated
	 */
	int OUTPUT_FORMAT = 29;


	/**
	 * Returns the meta object for class '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntegerMappingExpression <em>Integer Mapping Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Integer Mapping Expression</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntegerMappingExpression
	 * @generated
	 */
	EClass getIntegerMappingExpression();

	/**
	 * Returns the meta object for the containment reference '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntegerMappingExpression#getSrc <em>Src</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Src</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntegerMappingExpression#getSrc()
	 * @see #getIntegerMappingExpression()
	 * @generated
	 */
	EReference getIntegerMappingExpression_Src();

	/**
	 * Returns the meta object for the reference '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntegerMappingExpression#getDst <em>Dst</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Dst</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntegerMappingExpression#getDst()
	 * @see #getIntegerMappingExpression()
	 * @generated
	 */
	EReference getIntegerMappingExpression_Dst();

	/**
	 * Returns the meta object for class '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntegerLinearConstraintProblem <em>Integer Linear Constraint Problem</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Integer Linear Constraint Problem</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntegerLinearConstraintProblem
	 * @generated
	 */
	EClass getIntegerLinearConstraintProblem();

	/**
	 * Returns the meta object for the containment reference '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntegerLinearConstraintProblem#getSystem <em>System</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>System</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntegerLinearConstraintProblem#getSystem()
	 * @see #getIntegerLinearConstraintProblem()
	 * @generated
	 */
	EReference getIntegerLinearConstraintProblem_System();

	/**
	 * Returns the meta object for class '{@link fr.irisa.cairn.model.integerLinearAlgebra.IPrettyPrint <em>IPretty Print</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>IPretty Print</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IPrettyPrint
	 * @generated
	 */
	EClass getIPrettyPrint();

	/**
	 * Returns the meta object for class '{@link fr.irisa.cairn.model.integerLinearAlgebra.ScopeContainer <em>Scope Container</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Scope Container</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.ScopeContainer
	 * @generated
	 */
	EClass getScopeContainer();

	/**
	 * Returns the meta object for the containment reference '{@link fr.irisa.cairn.model.integerLinearAlgebra.ScopeContainer#getScope <em>Scope</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Scope</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.ScopeContainer#getScope()
	 * @see #getScopeContainer()
	 * @generated
	 */
	EReference getScopeContainer_Scope();

	/**
	 * Returns the meta object for class '{@link fr.irisa.cairn.model.integerLinearAlgebra.Scope <em>Scope</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Scope</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.Scope
	 * @generated
	 */
	EClass getScope();

	/**
	 * Returns the meta object for the containment reference list '{@link fr.irisa.cairn.model.integerLinearAlgebra.Scope#getSymbols <em>Symbols</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Symbols</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.Scope#getSymbols()
	 * @see #getScope()
	 * @generated
	 */
	EReference getScope_Symbols();

	/**
	 * Returns the meta object for class '{@link fr.irisa.cairn.model.integerLinearAlgebra.IVariable <em>IVariable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>IVariable</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IVariable
	 * @generated
	 */
	EClass getIVariable();

	/**
	 * Returns the meta object for class '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntExpression <em>Int Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Int Expression</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntExpression
	 * @generated
	 */
	EClass getIntExpression();

	/**
	 * Returns the meta object for class '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntMax <em>Int Max</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Int Max</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntMax
	 * @generated
	 */
	EClass getIntMax();

	/**
	 * Returns the meta object for the attribute '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntMax#getWidth <em>Width</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Width</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntMax#getWidth()
	 * @see #getIntMax()
	 * @generated
	 */
	EAttribute getIntMax_Width();

	/**
	 * Returns the meta object for the attribute '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntMax#isSigned <em>Signed</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Signed</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntMax#isSigned()
	 * @see #getIntMax()
	 * @generated
	 */
	EAttribute getIntMax_Signed();

	/**
	 * Returns the meta object for class '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntMin <em>Int Min</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Int Min</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntMin
	 * @generated
	 */
	EClass getIntMin();

	/**
	 * Returns the meta object for the attribute '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntMin#getWidth <em>Width</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Width</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntMin#getWidth()
	 * @see #getIntMin()
	 * @generated
	 */
	EAttribute getIntMin_Width();

	/**
	 * Returns the meta object for the attribute '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntMin#isSigned <em>Signed</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Signed</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntMin#isSigned()
	 * @see #getIntMin()
	 * @generated
	 */
	EAttribute getIntMin_Signed();

	/**
	 * Returns the meta object for class '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntTermExpression <em>Int Term Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Int Term Expression</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntTermExpression
	 * @generated
	 */
	EClass getIntTermExpression();

	/**
	 * Returns the meta object for the attribute '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntTermExpression#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntTermExpression#getValue()
	 * @see #getIntTermExpression()
	 * @generated
	 */
	EAttribute getIntTermExpression_Value();

	/**
	 * Returns the meta object for the reference '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntTermExpression#getVar <em>Var</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Var</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntTermExpression#getVar()
	 * @see #getIntTermExpression()
	 * @generated
	 */
	EReference getIntTermExpression_Var();

	/**
	 * Returns the meta object for class '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntDivExpression <em>Int Div Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Int Div Expression</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntDivExpression
	 * @generated
	 */
	EClass getIntDivExpression();

	/**
	 * Returns the meta object for the attribute '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntDivExpression#getDenum <em>Denum</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Denum</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntDivExpression#getDenum()
	 * @see #getIntDivExpression()
	 * @generated
	 */
	EAttribute getIntDivExpression_Denum();

	/**
	 * Returns the meta object for the containment reference '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntDivExpression#getExpr <em>Expr</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expr</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntDivExpression#getExpr()
	 * @see #getIntDivExpression()
	 * @generated
	 */
	EReference getIntDivExpression_Expr();

	/**
	 * Returns the meta object for class '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntModExpression <em>Int Mod Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Int Mod Expression</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntModExpression
	 * @generated
	 */
	EClass getIntModExpression();

	/**
	 * Returns the meta object for class '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntFloorDExpression <em>Int Floor DExpression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Int Floor DExpression</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntFloorDExpression
	 * @generated
	 */
	EClass getIntFloorDExpression();

	/**
	 * Returns the meta object for class '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntCeilDExpression <em>Int Ceil DExpression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Int Ceil DExpression</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntCeilDExpression
	 * @generated
	 */
	EClass getIntCeilDExpression();

	/**
	 * Returns the meta object for class '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntMulExpression <em>Int Mul Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Int Mul Expression</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntMulExpression
	 * @generated
	 */
	EClass getIntMulExpression();

	/**
	 * Returns the meta object for the attribute '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntMulExpression#getFactor <em>Factor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Factor</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntMulExpression#getFactor()
	 * @see #getIntMulExpression()
	 * @generated
	 */
	EAttribute getIntMulExpression_Factor();

	/**
	 * Returns the meta object for the containment reference '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntMulExpression#getExpr <em>Expr</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expr</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntMulExpression#getExpr()
	 * @see #getIntMulExpression()
	 * @generated
	 */
	EReference getIntMulExpression_Expr();

	/**
	 * Returns the meta object for class '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntReductionExpression <em>Int Reduction Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Int Reduction Expression</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntReductionExpression
	 * @generated
	 */
	EClass getIntReductionExpression();

	/**
	 * Returns the meta object for the containment reference list '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntReductionExpression#getTerms <em>Terms</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Terms</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntReductionExpression#getTerms()
	 * @see #getIntReductionExpression()
	 * @generated
	 */
	EReference getIntReductionExpression_Terms();

	/**
	 * Returns the meta object for class '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntSumExpression <em>Int Sum Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Int Sum Expression</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntSumExpression
	 * @generated
	 */
	EClass getIntSumExpression();

	/**
	 * Returns the meta object for class '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntProdExpression <em>Int Prod Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Int Prod Expression</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntProdExpression
	 * @generated
	 */
	EClass getIntProdExpression();

	/**
	 * Returns the meta object for class '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntLinearExpression <em>Int Linear Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Int Linear Expression</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntLinearExpression
	 * @generated
	 */
	EClass getIntLinearExpression();

	/**
	 * Returns the meta object for class '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntMaxExpression <em>Int Max Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Int Max Expression</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntMaxExpression
	 * @generated
	 */
	EClass getIntMaxExpression();

	/**
	 * Returns the meta object for class '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntMinExpression <em>Int Min Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Int Min Expression</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntMinExpression
	 * @generated
	 */
	EClass getIntMinExpression();

	/**
	 * Returns the meta object for class '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntLinearConstraintSystem <em>Int Linear Constraint System</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Int Linear Constraint System</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntLinearConstraintSystem
	 * @generated
	 */
	EClass getIntLinearConstraintSystem();

	/**
	 * Returns the meta object for the reference list '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntLinearConstraintSystem#getLinearConstraints <em>Linear Constraints</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Linear Constraints</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntLinearConstraintSystem#getLinearConstraints()
	 * @see #getIntLinearConstraintSystem()
	 * @generated
	 */
	EReference getIntLinearConstraintSystem_LinearConstraints();

	/**
	 * Returns the meta object for class '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntLinearConstraint <em>Int Linear Constraint</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Int Linear Constraint</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntLinearConstraint
	 * @generated
	 */
	EClass getIntLinearConstraint();

	/**
	 * Returns the meta object for the reference '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntLinearConstraint#getLinexpr <em>Linexpr</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Linexpr</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntLinearConstraint#getLinexpr()
	 * @see #getIntLinearConstraint()
	 * @generated
	 */
	EReference getIntLinearConstraint_Linexpr();

	/**
	 * Returns the meta object for class '{@link fr.irisa.cairn.model.integerLinearAlgebra.SymbolVariable <em>Symbol Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Symbol Variable</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.SymbolVariable
	 * @generated
	 */
	EClass getSymbolVariable();

	/**
	 * Returns the meta object for the attribute '{@link fr.irisa.cairn.model.integerLinearAlgebra.SymbolVariable#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.SymbolVariable#getName()
	 * @see #getSymbolVariable()
	 * @generated
	 */
	EAttribute getSymbolVariable_Name();

	/**
	 * Returns the meta object for class '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntConstraint <em>Int Constraint</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Int Constraint</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntConstraint
	 * @generated
	 */
	EClass getIntConstraint();

	/**
	 * Returns the meta object for the attribute '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntConstraint#getComparisonOperator <em>Comparison Operator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Comparison Operator</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntConstraint#getComparisonOperator()
	 * @see #getIntConstraint()
	 * @generated
	 */
	EAttribute getIntConstraint_ComparisonOperator();

	/**
	 * Returns the meta object for the containment reference '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntConstraint#getExpr <em>Expr</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expr</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntConstraint#getExpr()
	 * @see #getIntConstraint()
	 * @generated
	 */
	EReference getIntConstraint_Expr();

	/**
	 * Returns the meta object for class '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntConstraintSystem <em>Int Constraint System</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Int Constraint System</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntConstraintSystem
	 * @generated
	 */
	EClass getIntConstraintSystem();

	/**
	 * Returns the meta object for the containment reference list '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntConstraintSystem#getConstraints <em>Constraints</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Constraints</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntConstraintSystem#getConstraints()
	 * @see #getIntConstraintSystem()
	 * @generated
	 */
	EReference getIntConstraintSystem_Constraints();

	/**
	 * Returns the meta object for the reference '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntConstraintSystem#getScopeContainter <em>Scope Containter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Scope Containter</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntConstraintSystem#getScopeContainter()
	 * @see #getIntConstraintSystem()
	 * @generated
	 */
	EReference getIntConstraintSystem_ScopeContainter();

	/**
	 * Returns the meta object for class '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntegerMappingSystem <em>Integer Mapping System</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Integer Mapping System</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntegerMappingSystem
	 * @generated
	 */
	EClass getIntegerMappingSystem();

	/**
	 * Returns the meta object for the containment reference list '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntegerMappingSystem#getMappings <em>Mappings</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Mappings</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntegerMappingSystem#getMappings()
	 * @see #getIntegerMappingSystem()
	 * @generated
	 */
	EReference getIntegerMappingSystem_Mappings();

	/**
	 * Returns the meta object for class '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntConstraintExpression <em>Int Constraint Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Int Constraint Expression</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntConstraintExpression
	 * @generated
	 */
	EClass getIntConstraintExpression();

	/**
	 * Returns the meta object for the attribute '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntConstraintExpression#getComparisonOperator <em>Comparison Operator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Comparison Operator</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntConstraintExpression#getComparisonOperator()
	 * @see #getIntConstraintExpression()
	 * @generated
	 */
	EAttribute getIntConstraintExpression_ComparisonOperator();

	/**
	 * Returns the meta object for the containment reference '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntConstraintExpression#getLhs <em>Lhs</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Lhs</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntConstraintExpression#getLhs()
	 * @see #getIntConstraintExpression()
	 * @generated
	 */
	EReference getIntConstraintExpression_Lhs();

	/**
	 * Returns the meta object for the containment reference '{@link fr.irisa.cairn.model.integerLinearAlgebra.IntConstraintExpression#getRhs <em>Rhs</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Rhs</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntConstraintExpression#getRhs()
	 * @see #getIntConstraintExpression()
	 * @generated
	 */
	EReference getIntConstraintExpression_Rhs();

	/**
	 * Returns the meta object for enum '{@link fr.irisa.cairn.model.integerLinearAlgebra.Operator <em>Operator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Operator</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.Operator
	 * @generated
	 */
	EEnum getOperator();

	/**
	 * Returns the meta object for enum '{@link fr.irisa.cairn.model.integerLinearAlgebra.OUTPUT_FORMAT <em>OUTPUT FORMAT</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>OUTPUT FORMAT</em>'.
	 * @see fr.irisa.cairn.model.integerLinearAlgebra.OUTPUT_FORMAT
	 * @generated
	 */
	EEnum getOUTPUT_FORMAT();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	IntegerLinearAlgebraFactory getIntegerLinearAlgebraFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerMappingExpressionImpl <em>Integer Mapping Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerMappingExpressionImpl
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntegerMappingExpression()
		 * @generated
		 */
		EClass INTEGER_MAPPING_EXPRESSION = eINSTANCE.getIntegerMappingExpression();

		/**
		 * The meta object literal for the '<em><b>Src</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference INTEGER_MAPPING_EXPRESSION__SRC = eINSTANCE.getIntegerMappingExpression_Src();

		/**
		 * The meta object literal for the '<em><b>Dst</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference INTEGER_MAPPING_EXPRESSION__DST = eINSTANCE.getIntegerMappingExpression_Dst();

		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearConstraintProblemImpl <em>Integer Linear Constraint Problem</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearConstraintProblemImpl
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntegerLinearConstraintProblem()
		 * @generated
		 */
		EClass INTEGER_LINEAR_CONSTRAINT_PROBLEM = eINSTANCE.getIntegerLinearConstraintProblem();

		/**
		 * The meta object literal for the '<em><b>System</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference INTEGER_LINEAR_CONSTRAINT_PROBLEM__SYSTEM = eINSTANCE.getIntegerLinearConstraintProblem_System();

		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.IPrettyPrint <em>IPretty Print</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.IPrettyPrint
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIPrettyPrint()
		 * @generated
		 */
		EClass IPRETTY_PRINT = eINSTANCE.getIPrettyPrint();

		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.ScopeContainer <em>Scope Container</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.ScopeContainer
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getScopeContainer()
		 * @generated
		 */
		EClass SCOPE_CONTAINER = eINSTANCE.getScopeContainer();

		/**
		 * The meta object literal for the '<em><b>Scope</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SCOPE_CONTAINER__SCOPE = eINSTANCE.getScopeContainer_Scope();

		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.ScopeImpl <em>Scope</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.ScopeImpl
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getScope()
		 * @generated
		 */
		EClass SCOPE = eINSTANCE.getScope();

		/**
		 * The meta object literal for the '<em><b>Symbols</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SCOPE__SYMBOLS = eINSTANCE.getScope_Symbols();

		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.IVariable <em>IVariable</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.IVariable
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIVariable()
		 * @generated
		 */
		EClass IVARIABLE = eINSTANCE.getIVariable();

		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntExpressionImpl <em>Int Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntExpressionImpl
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntExpression()
		 * @generated
		 */
		EClass INT_EXPRESSION = eINSTANCE.getIntExpression();

		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntMaxImpl <em>Int Max</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntMaxImpl
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntMax()
		 * @generated
		 */
		EClass INT_MAX = eINSTANCE.getIntMax();

		/**
		 * The meta object literal for the '<em><b>Width</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute INT_MAX__WIDTH = eINSTANCE.getIntMax_Width();

		/**
		 * The meta object literal for the '<em><b>Signed</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute INT_MAX__SIGNED = eINSTANCE.getIntMax_Signed();

		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntMinImpl <em>Int Min</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntMinImpl
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntMin()
		 * @generated
		 */
		EClass INT_MIN = eINSTANCE.getIntMin();

		/**
		 * The meta object literal for the '<em><b>Width</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute INT_MIN__WIDTH = eINSTANCE.getIntMin_Width();

		/**
		 * The meta object literal for the '<em><b>Signed</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute INT_MIN__SIGNED = eINSTANCE.getIntMin_Signed();

		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntTermExpressionImpl <em>Int Term Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntTermExpressionImpl
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntTermExpression()
		 * @generated
		 */
		EClass INT_TERM_EXPRESSION = eINSTANCE.getIntTermExpression();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute INT_TERM_EXPRESSION__VALUE = eINSTANCE.getIntTermExpression_Value();

		/**
		 * The meta object literal for the '<em><b>Var</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference INT_TERM_EXPRESSION__VAR = eINSTANCE.getIntTermExpression_Var();

		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntDivExpressionImpl <em>Int Div Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntDivExpressionImpl
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntDivExpression()
		 * @generated
		 */
		EClass INT_DIV_EXPRESSION = eINSTANCE.getIntDivExpression();

		/**
		 * The meta object literal for the '<em><b>Denum</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute INT_DIV_EXPRESSION__DENUM = eINSTANCE.getIntDivExpression_Denum();

		/**
		 * The meta object literal for the '<em><b>Expr</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference INT_DIV_EXPRESSION__EXPR = eINSTANCE.getIntDivExpression_Expr();

		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntModExpressionImpl <em>Int Mod Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntModExpressionImpl
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntModExpression()
		 * @generated
		 */
		EClass INT_MOD_EXPRESSION = eINSTANCE.getIntModExpression();

		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntFloorDExpressionImpl <em>Int Floor DExpression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntFloorDExpressionImpl
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntFloorDExpression()
		 * @generated
		 */
		EClass INT_FLOOR_DEXPRESSION = eINSTANCE.getIntFloorDExpression();

		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntCeilDExpressionImpl <em>Int Ceil DExpression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntCeilDExpressionImpl
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntCeilDExpression()
		 * @generated
		 */
		EClass INT_CEIL_DEXPRESSION = eINSTANCE.getIntCeilDExpression();

		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntMulExpressionImpl <em>Int Mul Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntMulExpressionImpl
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntMulExpression()
		 * @generated
		 */
		EClass INT_MUL_EXPRESSION = eINSTANCE.getIntMulExpression();

		/**
		 * The meta object literal for the '<em><b>Factor</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute INT_MUL_EXPRESSION__FACTOR = eINSTANCE.getIntMulExpression_Factor();

		/**
		 * The meta object literal for the '<em><b>Expr</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference INT_MUL_EXPRESSION__EXPR = eINSTANCE.getIntMulExpression_Expr();

		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntReductionExpressionImpl <em>Int Reduction Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntReductionExpressionImpl
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntReductionExpression()
		 * @generated
		 */
		EClass INT_REDUCTION_EXPRESSION = eINSTANCE.getIntReductionExpression();

		/**
		 * The meta object literal for the '<em><b>Terms</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference INT_REDUCTION_EXPRESSION__TERMS = eINSTANCE.getIntReductionExpression_Terms();

		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntSumExpressionImpl <em>Int Sum Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntSumExpressionImpl
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntSumExpression()
		 * @generated
		 */
		EClass INT_SUM_EXPRESSION = eINSTANCE.getIntSumExpression();

		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntProdExpressionImpl <em>Int Prod Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntProdExpressionImpl
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntProdExpression()
		 * @generated
		 */
		EClass INT_PROD_EXPRESSION = eINSTANCE.getIntProdExpression();

		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntLinearExpressionImpl <em>Int Linear Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntLinearExpressionImpl
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntLinearExpression()
		 * @generated
		 */
		EClass INT_LINEAR_EXPRESSION = eINSTANCE.getIntLinearExpression();

		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntMaxExpressionImpl <em>Int Max Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntMaxExpressionImpl
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntMaxExpression()
		 * @generated
		 */
		EClass INT_MAX_EXPRESSION = eINSTANCE.getIntMaxExpression();

		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntMinExpressionImpl <em>Int Min Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntMinExpressionImpl
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntMinExpression()
		 * @generated
		 */
		EClass INT_MIN_EXPRESSION = eINSTANCE.getIntMinExpression();

		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntLinearConstraintSystemImpl <em>Int Linear Constraint System</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntLinearConstraintSystemImpl
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntLinearConstraintSystem()
		 * @generated
		 */
		EClass INT_LINEAR_CONSTRAINT_SYSTEM = eINSTANCE.getIntLinearConstraintSystem();

		/**
		 * The meta object literal for the '<em><b>Linear Constraints</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference INT_LINEAR_CONSTRAINT_SYSTEM__LINEAR_CONSTRAINTS = eINSTANCE.getIntLinearConstraintSystem_LinearConstraints();

		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntLinearConstraintImpl <em>Int Linear Constraint</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntLinearConstraintImpl
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntLinearConstraint()
		 * @generated
		 */
		EClass INT_LINEAR_CONSTRAINT = eINSTANCE.getIntLinearConstraint();

		/**
		 * The meta object literal for the '<em><b>Linexpr</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference INT_LINEAR_CONSTRAINT__LINEXPR = eINSTANCE.getIntLinearConstraint_Linexpr();

		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.SymbolVariableImpl <em>Symbol Variable</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.SymbolVariableImpl
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getSymbolVariable()
		 * @generated
		 */
		EClass SYMBOL_VARIABLE = eINSTANCE.getSymbolVariable();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SYMBOL_VARIABLE__NAME = eINSTANCE.getSymbolVariable_Name();

		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntConstraintImpl <em>Int Constraint</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntConstraintImpl
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntConstraint()
		 * @generated
		 */
		EClass INT_CONSTRAINT = eINSTANCE.getIntConstraint();

		/**
		 * The meta object literal for the '<em><b>Comparison Operator</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute INT_CONSTRAINT__COMPARISON_OPERATOR = eINSTANCE.getIntConstraint_ComparisonOperator();

		/**
		 * The meta object literal for the '<em><b>Expr</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference INT_CONSTRAINT__EXPR = eINSTANCE.getIntConstraint_Expr();

		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntConstraintSystemImpl <em>Int Constraint System</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntConstraintSystemImpl
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntConstraintSystem()
		 * @generated
		 */
		EClass INT_CONSTRAINT_SYSTEM = eINSTANCE.getIntConstraintSystem();

		/**
		 * The meta object literal for the '<em><b>Constraints</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference INT_CONSTRAINT_SYSTEM__CONSTRAINTS = eINSTANCE.getIntConstraintSystem_Constraints();

		/**
		 * The meta object literal for the '<em><b>Scope Containter</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference INT_CONSTRAINT_SYSTEM__SCOPE_CONTAINTER = eINSTANCE.getIntConstraintSystem_ScopeContainter();

		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerMappingSystemImpl <em>Integer Mapping System</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerMappingSystemImpl
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntegerMappingSystem()
		 * @generated
		 */
		EClass INTEGER_MAPPING_SYSTEM = eINSTANCE.getIntegerMappingSystem();

		/**
		 * The meta object literal for the '<em><b>Mappings</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference INTEGER_MAPPING_SYSTEM__MAPPINGS = eINSTANCE.getIntegerMappingSystem_Mappings();

		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntConstraintExpressionImpl <em>Int Constraint Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntConstraintExpressionImpl
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getIntConstraintExpression()
		 * @generated
		 */
		EClass INT_CONSTRAINT_EXPRESSION = eINSTANCE.getIntConstraintExpression();

		/**
		 * The meta object literal for the '<em><b>Comparison Operator</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute INT_CONSTRAINT_EXPRESSION__COMPARISON_OPERATOR = eINSTANCE.getIntConstraintExpression_ComparisonOperator();

		/**
		 * The meta object literal for the '<em><b>Lhs</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference INT_CONSTRAINT_EXPRESSION__LHS = eINSTANCE.getIntConstraintExpression_Lhs();

		/**
		 * The meta object literal for the '<em><b>Rhs</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference INT_CONSTRAINT_EXPRESSION__RHS = eINSTANCE.getIntConstraintExpression_Rhs();

		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.Operator <em>Operator</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.Operator
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getOperator()
		 * @generated
		 */
		EEnum OPERATOR = eINSTANCE.getOperator();

		/**
		 * The meta object literal for the '{@link fr.irisa.cairn.model.integerLinearAlgebra.OUTPUT_FORMAT <em>OUTPUT FORMAT</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.OUTPUT_FORMAT
		 * @see fr.irisa.cairn.model.integerLinearAlgebra.impl.IntegerLinearAlgebraPackageImpl#getOUTPUT_FORMAT()
		 * @generated
		 */
		EEnum OUTPUT_FORMAT = eINSTANCE.getOUTPUT_FORMAT();

	}

} //IntegerLinearAlgebraPackage
