package fr.irisa.cairn.model.integerLinearAlgebra.adapter;

import fr.irisa.cairn.model.integerLinearAlgebra.IntExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntReductionExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.util.IntegerLinearAlgebraSwitch;

import java.util.ArrayList;
import java.util.List;

import tom.engine.adt.il.types.substitution.undefsubs;
import tom.library.sl.VisitFailure;
import tom.library.sl.Visitable;

/**
 * Instruction adapter allow use of TOM stragegies for instructions. An adapter
 * contain an instruction and inmplements {@link Visitable}. When setting
 * children adapters, instructions are copied in order to avoid modification of
 * original instructions.
 * 
 * @author antoine
 * 
 */
public class IntExpressionListAdapter implements Visitable {
	private List<IntExpression> list;
	private IntExpression[] childrenCache;
	private IntExpressionAdapter[] childrenAdapter;
	private IntExpression container =null;
	
	public IntExpressionListAdapter(List<IntExpression> expr) {
		this.list = expr;
	}

	public IntExpressionListAdapter() {
		this.list = new ArrayList<IntExpression>();
	}

	public List<IntExpression> list() {
		return list;
	}


	private IntExpressionAdapter[] getChildrenAdapters() {
		if (childrenAdapter == null) {
			
			childrenAdapter = new IntExpressionAdapter[list.size()];
			for (int i = 0; i < list.size(); ++i) {
				childrenAdapter[i] = new IntExpressionAdapter(list.get(i));
			}
		}
		return childrenAdapter;
	}

	public Visitable getChildAt(int i) {
		return getChildrenAdapters()[i];
	}

	public int getChildCount() {
		return list.size();
	}

	public Visitable[] getChildren() {
		return getChildrenAdapters();
	}

	public Visitable setChildAt(int i, Visitable newchild) {
		if (newchild instanceof IntExpressionAdapter) {
			List<IntExpression> res = new ArrayList<IntExpression>();
			int offset =0;
			for (IntExpression child : list) {
				if(offset==i) {
					res.add(((IntExpressionAdapter)newchild).expr().copy());
				} else {
					res.add(child.copy());
				}
				offset++;
			}
			return  new IntExpressionListAdapter(res);
		} else {
			throw new RuntimeException("Unsupported adapter "+newchild.getClass().getSimpleName());
		}
	}

	public Visitable setChildren(Visitable[] children) {
		List<IntExpression> res = new ArrayList<IntExpression>();
		for (Visitable visitable : children) {
			if (visitable instanceof IntExpressionAdapter) {
				res.add((((IntExpressionAdapter)visitable)).expr().copy());
			} else {
				throw new RuntimeException("Unsupported adapter "+visitable.getClass().getSimpleName());
			}
		}
		return  new IntExpressionListAdapter(res);
	}

	public IntExpressionListAdapter accept(IntExpressionStrategy strategy)
			throws VisitFailure {
		return strategy.visit_ListInstr(this);
	}

	@Override
	public String toString() {
		return "A:" + list.toString();
	}

	public void setContainer(IntExpression copy) {
		container=copy;
	}

	public IntExpression getContainer() {
		return container;
	}



}
