package fr.irisa.cairn.model.integerLinearAlgebra.factory;

import static fr.irisa.cairn.model.integerLinearAlgebra.factory.IntegerExpressionUserFactory.linConstraint;
import static fr.irisa.cairn.model.integerLinearAlgebra.factory.IntegerExpressionUserFactory.linexp;
import static fr.irisa.cairn.model.integerLinearAlgebra.factory.IntegerExpressionUserFactory.term;
import static fr.irisa.cairn.model.integerLinearAlgebra.factory.IntegerExpressionUserFactory.var;

import fr.irisa.cairn.model.integerLinearAlgebra.IntLinearConstraint;
import fr.irisa.cairn.model.integerLinearAlgebra.IntLinearExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntTermExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.Operator;
import fr.irisa.cairn.model.integerLinearAlgebra.SymbolVariable;

/**
 * 
 * Add static methods whose name starts with "expr_"
 * 
 * @author amorvan
 *
 */
public class TestExprBuilder {

	public static class TestExpr {
		public SymbolVariable[] symbols;
		public IntLinearConstraint constraint;
		public String exprStr;
	}
	
	public static TestExpr expr_1() {
		TestExpr res = new TestExpr();
		res.symbols = new SymbolVariable[]{var("j")};
		res.exprStr = "-1j >= 0";
		IntTermExpression term = term(-1, res.symbols[0]); // -1*j
		IntLinearExpression exp = linexp(term);
		exp = linexp(exp.simplify());
		res.constraint = linConstraint(exp, Operator.GE); // -1*j >= 0
		return res;
	}
	
	public static TestExpr expr_2() {
		TestExpr res = new TestExpr();
		res.symbols = new SymbolVariable[]{var("j")};
		res.exprStr = "0+j >= 0";
		IntTermExpression term1 = term(0); //0
		IntTermExpression term2 = term(1, res.symbols[0]); // j
		IntLinearExpression exp = linexp(term1,term2); //0 + j
		exp = linexp(exp.simplify());
		res.constraint = linConstraint(exp, Operator.GE); //0 + j >= 0
		return res;
	}
	
	public static TestExpr expr_3() {
		TestExpr res = new TestExpr();
		res.symbols = new SymbolVariable[]{var("j")};
		res.exprStr = "1+j >= 0";
		IntTermExpression term1 = term(1); //1
		IntTermExpression term2 = term(1, res.symbols[0]); // j
		IntLinearExpression exp = linexp(term1,term2); //1 + j
		exp = linexp(exp.simplify());
		res.constraint = linConstraint(exp, Operator.GE); //1 + j >= 0
		return res;
	}
	
	public static TestExpr expr_4() {
		TestExpr res = new TestExpr();
		res.symbols = new SymbolVariable[]{};
		res.exprStr = "0+1 >= 0";
		IntTermExpression term1 = term(0); // 0
		IntTermExpression term2 = term(1); // 1
		IntLinearExpression exp = linexp(term1,term2); // 0 + 1
		exp = linexp(exp.simplify());
		res.constraint = linConstraint(exp, Operator.GE); // 0 + 1 >= 0
		return res;
	}
	
	public static TestExpr expr_5() {
		TestExpr res = new TestExpr();
		res.symbols = new SymbolVariable[]{var("j")};
		res.exprStr = "+(1j)>= 0";
		IntTermExpression term1 = term(1,res.symbols[0]); // j
		IntLinearExpression exp = linexp(term1); // j
		exp = linexp(exp.simplify());
		res.constraint = linConstraint(exp, Operator.GE); // j >= 0
		return res;
	}
	
	
	public static void main(String[] args) {
		TestIntExpressionParser.main(args);
	}
}
