package fr.irisa.cairn.model.integerLinearAlgebra.factory;

import static fr.irisa.cairn.model.integerLinearAlgebra.factory.IntegerExpressionUserFactory.linexp;
import static fr.irisa.cairn.model.integerLinearAlgebra.factory.IntegerExpressionUserFactory.sub;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import fr.irisa.cairn.model.integerLinearAlgebra.IntLinearConstraint;
import fr.irisa.cairn.model.integerLinearAlgebra.IntLinearExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.SymbolVariable;
import fr.irisa.cairn.model.integerLinearAlgebra.factory.TestExprBuilder.TestExpr;


public class TestIntExpressionParser {
	
	static final List<TestExpr> tests = new LinkedList<TestExprBuilder.TestExpr>() {
		private static final long serialVersionUID = 1L;
		{
			Class<TestExprBuilder> c = TestExprBuilder.class;
			for (Method m : c.getMethods()) {
				String name = m.getName();
				if (name.startsWith("expr_")) {
					try {
						Object o = m.invoke(null);
						if (TestExpr.class.isInstance(o)) add(TestExpr.class.cast(o));
					} catch (Exception e) {
						System.out.println(e);
					}
				}
			}
		}
	};
	
	public static void main(String[] args) {
		List<String> errs = new ArrayList<String>();
		for (TestExpr e : tests) {
			String expString = e.exprStr;
			IntLinearConstraint expectedResult = e.constraint;
			SymbolVariable[] symbols = e.symbols;
			//System.out.println("testing string {"+expString+"}.");
			IntExpressionParser parser = new IntExpressionParser();
			IntLinearConstraint c = parser.parseIntLinearConstraint(expString, symbols);
			IntLinearExpression res = linexp(sub(c.getExpr(),expectedResult.getExpr()));
			boolean b = (res != null) 
				&& (res.getSimpleTerms().size() == 1)
				&& (res.getSimpleTerms().get(0).getValue() == 0)
				&& (c.getComparisonOperator() == expectedResult.getComparisonOperator());
				//!c.toString().equals(expectedResult.toString()); 
				//!c.equals(expectedResult);
			if (!b) {
				errs.add("Built expression {"+c+"} from string {"+expString+"} is different from exptected expression {"+expectedResult+"} ");
			}
		}
		if (errs.isEmpty()) System.out.println("no errors.");
		else {
			System.out.flush();
			System.err.flush();
			for (String s : errs) System.err.println(s);
		}
	}
	
}
