/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package fr.irisa.cairn.model.integerLinearAlgebra.impl;

import fr.irisa.cairn.model.integerLinearAlgebra.IntConstraint;
import fr.irisa.cairn.model.integerLinearAlgebra.IntExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntLinearConstraint;
import fr.irisa.cairn.model.integerLinearAlgebra.IntLinearExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntegerLinearAlgebraPackage;
import fr.irisa.cairn.model.integerLinearAlgebra.OUTPUT_FORMAT;
import fr.irisa.cairn.model.integerLinearAlgebra.Operator;
import fr.irisa.cairn.model.integerLinearAlgebra.factory.IntegerExpressionUserFactory;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Int Constraint</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntConstraintImpl#getComparisonOperator <em>Comparison Operator</em>}</li>
 *   <li>{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntConstraintImpl#getExpr <em>Expr</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class IntConstraintImpl extends EObjectImpl implements IntConstraint {
	/**
	 * The default value of the '{@link #getComparisonOperator() <em>Comparison Operator</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getComparisonOperator()
	 * @generated
	 * @ordered
	 */
	protected static final Operator COMPARISON_OPERATOR_EDEFAULT = Operator.EQ;

	/**
	 * The cached value of the '{@link #getComparisonOperator() <em>Comparison Operator</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getComparisonOperator()
	 * @generated
	 * @ordered
	 */
	protected Operator comparisonOperator = COMPARISON_OPERATOR_EDEFAULT;

	/**
	 * The cached value of the '{@link #getExpr() <em>Expr</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExpr()
	 * @generated
	 * @ordered
	 */
	protected IntExpression expr;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IntConstraintImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return IntegerLinearAlgebraPackage.Literals.INT_CONSTRAINT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Operator getComparisonOperator() {
		return comparisonOperator;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setComparisonOperator(Operator newComparisonOperator) {
		Operator oldComparisonOperator = comparisonOperator;
		comparisonOperator = newComparisonOperator == null ? COMPARISON_OPERATOR_EDEFAULT : newComparisonOperator;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IntegerLinearAlgebraPackage.INT_CONSTRAINT__COMPARISON_OPERATOR, oldComparisonOperator, comparisonOperator));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IntExpression getExpr() {
		return expr;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetExpr(IntExpression newExpr, NotificationChain msgs) {
		IntExpression oldExpr = expr;
		expr = newExpr;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, IntegerLinearAlgebraPackage.INT_CONSTRAINT__EXPR, oldExpr, newExpr);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setExpr(IntExpression newExpr) {
		if (newExpr != expr) {
			NotificationChain msgs = null;
			if (expr != null)
				msgs = ((InternalEObject)expr).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - IntegerLinearAlgebraPackage.INT_CONSTRAINT__EXPR, null, msgs);
			if (newExpr != null)
				msgs = ((InternalEObject)newExpr).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - IntegerLinearAlgebraPackage.INT_CONSTRAINT__EXPR, null, msgs);
			msgs = basicSetExpr(newExpr, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IntegerLinearAlgebraPackage.INT_CONSTRAINT__EXPR, newExpr, newExpr));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public String toString(OUTPUT_FORMAT format) {
		
		switch (format) {
			case DEFAULT:
				return toString();
		}
		
		//Printing for C and Alphabets
		switch (getComparisonOperator().ordinal()) {
			case Operator.EQ_VALUE:
				return "" +expr.toString(format) + "== 0";			
			case Operator.GT_VALUE:
				return "" +expr.toString(format) + "> 0";			
			case Operator.GE_VALUE:
				return "" +expr.toString(format) + ">= 0";			
			case Operator.LE_VALUE:
				return "" +expr.toString(format) + "<= 0";			
			case Operator.LT_VALUE:
				return "" +expr.toString(format) + "< 0";			
			default:
				return "" +expr.toString(format) + "("+getComparisonOperator()+") 0";			
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case IntegerLinearAlgebraPackage.INT_CONSTRAINT__EXPR:
				return basicSetExpr(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case IntegerLinearAlgebraPackage.INT_CONSTRAINT__COMPARISON_OPERATOR:
				return getComparisonOperator();
			case IntegerLinearAlgebraPackage.INT_CONSTRAINT__EXPR:
				return getExpr();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case IntegerLinearAlgebraPackage.INT_CONSTRAINT__COMPARISON_OPERATOR:
				setComparisonOperator((Operator)newValue);
				return;
			case IntegerLinearAlgebraPackage.INT_CONSTRAINT__EXPR:
				setExpr((IntExpression)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case IntegerLinearAlgebraPackage.INT_CONSTRAINT__COMPARISON_OPERATOR:
				setComparisonOperator(COMPARISON_OPERATOR_EDEFAULT);
				return;
			case IntegerLinearAlgebraPackage.INT_CONSTRAINT__EXPR:
				setExpr((IntExpression)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case IntegerLinearAlgebraPackage.INT_CONSTRAINT__COMPARISON_OPERATOR:
				return comparisonOperator != COMPARISON_OPERATOR_EDEFAULT;
			case IntegerLinearAlgebraPackage.INT_CONSTRAINT__EXPR:
				return expr != null;
		}
		return super.eIsSet(featureID);
	}


	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	@Override
	public String toString() {
		switch (getComparisonOperator().ordinal()) {
		case Operator.EQ_VALUE:
			return "" +expr + "= 0";			
		case Operator.GT_VALUE:
			return "" +expr + "> 0";			
		case Operator.GE_VALUE:
			return "" +expr + ">= 0";			
		case Operator.LE_VALUE:
			return "" +expr + "<= 0";			
		case Operator.LT_VALUE:
			return "" +expr + "< 0";			
		default:
			return "" +expr + "("+getComparisonOperator()+") 0";			
		}
		
	}


	public IntConstraint copy() {
		IntConstraintImpl contr = new IntConstraintImpl();
		contr.setComparisonOperator(this.getComparisonOperator());
		contr.setExpr(this.getExpr().copy());
		return contr;
	}

	public IntConstraint simplify() {
		IntExpression simplify = getExpr().simplify();
		return IntegerExpressionUserFactory.constraint(simplify, getComparisonOperator());
		
	}

	public boolean isAffine() {
		return (this instanceof IntLinearConstraint);
	}


} //IntConstraintImpl
