/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package fr.irisa.cairn.model.integerLinearAlgebra.impl;

import fr.irisa.cairn.model.integerLinearAlgebra.IntDivExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntegerLinearAlgebraPackage;
import fr.irisa.cairn.model.integerLinearAlgebra.OUTPUT_FORMAT;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Int Div Expression</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntDivExpressionImpl#getDenum <em>Denum</em>}</li>
 *   <li>{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntDivExpressionImpl#getExpr <em>Expr</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public abstract class IntDivExpressionImpl extends IntExpressionImpl implements IntDivExpression {
	
	@Override
	public boolean isQuasiAffine() {
		return getExpr().isAffine();
	}

	/**
	 * The default value of the '{@link #getDenum() <em>Denum</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDenum()
	 * @generated
	 * @ordered
	 */
	protected static final int DENUM_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getDenum() <em>Denum</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDenum()
	 * @generated
	 * @ordered
	 */
	protected int denum = DENUM_EDEFAULT;

	/**
	 * The cached value of the '{@link #getExpr() <em>Expr</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExpr()
	 * @generated
	 * @ordered
	 */
	protected IntExpression expr;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IntDivExpressionImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return IntegerLinearAlgebraPackage.Literals.INT_DIV_EXPRESSION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getDenum() {
		return denum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDenum(int newDenum) {
		int oldDenum = denum;
		denum = newDenum;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IntegerLinearAlgebraPackage.INT_DIV_EXPRESSION__DENUM, oldDenum, denum));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IntExpression getExpr() {
		return expr;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetExpr(IntExpression newExpr, NotificationChain msgs) {
		IntExpression oldExpr = expr;
		expr = newExpr;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, IntegerLinearAlgebraPackage.INT_DIV_EXPRESSION__EXPR, oldExpr, newExpr);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setExpr(IntExpression newExpr) {
		if (newExpr != expr) {
			NotificationChain msgs = null;
			if (expr != null)
				msgs = ((InternalEObject)expr).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - IntegerLinearAlgebraPackage.INT_DIV_EXPRESSION__EXPR, null, msgs);
			if (newExpr != null)
				msgs = ((InternalEObject)newExpr).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - IntegerLinearAlgebraPackage.INT_DIV_EXPRESSION__EXPR, null, msgs);
			msgs = basicSetExpr(newExpr, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IntegerLinearAlgebraPackage.INT_DIV_EXPRESSION__EXPR, newExpr, newExpr));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case IntegerLinearAlgebraPackage.INT_DIV_EXPRESSION__EXPR:
				return basicSetExpr(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case IntegerLinearAlgebraPackage.INT_DIV_EXPRESSION__DENUM:
				return getDenum();
			case IntegerLinearAlgebraPackage.INT_DIV_EXPRESSION__EXPR:
				return getExpr();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case IntegerLinearAlgebraPackage.INT_DIV_EXPRESSION__DENUM:
				setDenum((Integer)newValue);
				return;
			case IntegerLinearAlgebraPackage.INT_DIV_EXPRESSION__EXPR:
				setExpr((IntExpression)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case IntegerLinearAlgebraPackage.INT_DIV_EXPRESSION__DENUM:
				setDenum(DENUM_EDEFAULT);
				return;
			case IntegerLinearAlgebraPackage.INT_DIV_EXPRESSION__EXPR:
				setExpr((IntExpression)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case IntegerLinearAlgebraPackage.INT_DIV_EXPRESSION__DENUM:
				return denum != DENUM_EDEFAULT;
			case IntegerLinearAlgebraPackage.INT_DIV_EXPRESSION__EXPR:
				return expr != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	@Override
	public String toString() {
		return "div("+getExpr()+','+getDenum()+')';
	}

	@Override
	public String toString(OUTPUT_FORMAT format) {
		switch (format) {
		case ISL:
			String exp = this.getExpr().toString(format);
			return "[("+exp+")/"+getDenum()+"]+";

		default:
			throw new UnsupportedOperationException("Not yet implemented");
		}
	}

} //IntDivExpressionImpl
