/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package fr.irisa.cairn.model.integerLinearAlgebra.impl;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EcoreUtil.Copier;

import tom.library.sl.VisitFailure;
import fr.irisa.cairn.model.integerLinearAlgebra.IVariable;
import fr.irisa.cairn.model.integerLinearAlgebra.IntExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntegerLinearAlgebraPackage;
import fr.irisa.cairn.model.integerLinearAlgebra.OUTPUT_FORMAT;
import fr.irisa.cairn.model.integerLinearAlgebra.tom.Replace;
import fr.irisa.cairn.model.integerLinearAlgebra.tom.SimplifyIntExpression;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Int Expression</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * </p>
 *
 * @generated
 */
public abstract class IntExpressionImpl extends EObjectImpl implements IntExpression {
	
	

	public boolean isAffine() {
		return false;
	}

	public boolean isQuasiAffine() {
		return false;
	}

	public boolean isModuloQuasiAffine() {
		return false;
	}

	public boolean isFloordQuasiAffine() {
		return false;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IntExpressionImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return IntegerLinearAlgebraPackage.Literals.INT_EXPRESSION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @throws VisitFailure 
	 * @generated NOT
	 */
	public IntExpression simplify()  {
		return SimplifyIntExpression.simplify(this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public IntExpression copy() {
		Copier copier = new Copier();
		IntExpression  res = (IntExpression) copier.copy(this);
		copier.copyReferences();
		return res;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public String toString(OUTPUT_FORMAT format) {
		//default behavior
		return toString();
	}

	
	public IntExpression substituteVarWith(IVariable var, IntExpression exp) {
		return Replace.replace(this, var, exp);
		
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc --> 
	 * @generated NOT
	 */
	public void substituteWith(IntExpression inst) {
		if(inst==null) throw new UnsupportedOperationException("Cannot substitute "+this+ " with null");

		EObject container = this.eContainer();
		//System.out.println("substitute "+this+ " by "+inst +" in "+container);
		if(container!=null) {
			EStructuralFeature feature = this.eContainingFeature();
			//System.out.println("feature= "+feature);
			if(feature.isMany()) {
				EList list= (EList) container.eGet(feature);
				//System.out.println("list = "+list);
				int pos = list.indexOf(this);
				if(pos==-1) {
					System.out.println();
				} else {
					list.set(pos, inst);
				}
			} else {
				container.eSet(feature,inst);
			}
		} else {
			throw new UnsupportedOperationException("Cannot substitute "+this+ " with "+inst+ " as it not contained");
		}
	}

} //IntExpressionImpl
