/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package fr.irisa.cairn.model.integerLinearAlgebra.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import fr.irisa.cairn.model.integerLinearAlgebra.IVariable;
import fr.irisa.cairn.model.integerLinearAlgebra.IntCeilDExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntFloorDExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntLinearConstraint;
import fr.irisa.cairn.model.integerLinearAlgebra.IntLinearExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntTermExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntegerLinearAlgebraFactory;
import fr.irisa.cairn.model.integerLinearAlgebra.IntegerLinearAlgebraPackage;
import fr.irisa.cairn.model.integerLinearAlgebra.OUTPUT_FORMAT;
import fr.irisa.cairn.model.integerLinearAlgebra.Operator;
import fr.irisa.cairn.model.integerLinearAlgebra.factory.IntegerExpressionUserFactory;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Int Linear Constraint</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntLinearConstraintImpl#getLinexpr <em>Linexpr</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class IntLinearConstraintImpl extends IntConstraintImpl implements IntLinearConstraint {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IntLinearConstraintImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return IntegerLinearAlgebraPackage.Literals.INT_LINEAR_CONSTRAINT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IntLinearExpression getLinexpr() {
		IntLinearExpression linexpr = basicGetLinexpr();
		return linexpr != null && linexpr.eIsProxy() ? (IntLinearExpression)eResolveProxy((InternalEObject)linexpr) : linexpr;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public IntLinearExpression basicGetLinexpr() {
		return (IntLinearExpression) getExpr();
	}
	
	private int getCoefficientOf(IVariable var) {
		int targetCoef = 0;

		//Iterate over terms and look for matching variable
		for (IntExpression ile : getLinexpr().getTerms()) {
			//Handles IntTermExpression only
			if (ile instanceof IntTermExpression) {
				IntTermExpression term = (IntTermExpression)ile;
				if (term.getVar() != null && term.getVar().equals(var)) {
					targetCoef = term.getValue();
				}
			} else {
				throw new RuntimeException("Expecting IntTermExpression");
			}
		}
		
		return targetCoef;
	}

	/**
	 * Returns the expression with the term that multiplies the IVariable specified removed.
	 * If the negate flag is true, negates all other terms.
	 * 
	 * @param var
	 * @param negate
	 * @return
	 */
	private IntLinearExpression getExpressionWithout(IVariable var, boolean negate) {
		int targetCoef = 0;
		//Construct the term without the target variable
		IntLinearExpression Bexpr = IntegerLinearAlgebraFactory.eINSTANCE.createIntLinearExpression();
		for (IntExpression ile : getLinexpr().getTerms()) {
			//Handles IntTermExpression only
			if (ile instanceof IntTermExpression) {
				IntTermExpression term = (IntTermExpression)ile;
				//Constant
				if (term.getVar() == null) {
					Bexpr.getTerms().add(term.copy());
				//linear term
				} else if (!term.getVar().equals(var)) {
					Bexpr.getTerms().add(term.copy());
				//When it is the target variable, keep track of its coefficient
				} else {
					targetCoef = term.getValue();
				}
			} else {
				throw new RuntimeException("Expecting IntTermExpression");
			}
		}
		
		//If the target was not involved in the expression, skip
		if (targetCoef == 0) {
			return null;
		}
		
		//When no term is set, give 0
		if (Bexpr.getTerms().size() == 0) {
			Bexpr.getTerms().add(IntegerExpressionUserFactory.term(0));
		}
		
		//When specified negate all terms
		//This is for lower bounds
		if (negate) {
			for (IntExpression expr : Bexpr.getTerms()) {
				((IntTermExpression)expr).setValue(((IntTermExpression)expr).getValue()*-1);
			}
		}
		
		
		return Bexpr;
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public IntExpression getUB(IVariable var) {
		
		//First get the coefficient of the target variable
		int targetCoef = getCoefficientOf(var);
		
		//If the target is not involved or not relevant for upper bound, return null
		if (targetCoef >= 0 && getComparisonOperator() != Operator.EQ) {
			return null;
		}
		
		//Otherwise, get the term without the target variable
		//negate only when the operator is equality
		IntLinearExpression expr;
		if (getComparisonOperator() == Operator.EQ && targetCoef > 0) {
			expr = getExpressionWithout(var, true);
		} else {
			expr = getExpressionWithout(var, false);
		}
		
		//If the coefficient is larger than one, divide and take the floor
		if (Math.abs(targetCoef) > 1) {
			return IntegerExpressionUserFactory.ceild(expr, targetCoef);
		}
		
		return expr;
		
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public IntExpression getLB(IVariable var) {
		
		//First get the coefficient of the target variable
		int targetCoef = getCoefficientOf(var);
		
		//If the target is not involved or not relevant for lower bound, return null
		if (targetCoef <= 0 && getComparisonOperator() != Operator.EQ) {
			return null;
		}
		
		//Otherwise, get the term without the target variable
		//negate if the operator is not equality
		IntLinearExpression expr;
		if ((getComparisonOperator() == Operator.EQ && targetCoef > 0) || (getComparisonOperator() != Operator.EQ && targetCoef > 0)) {
			expr = getExpressionWithout(var, true);
		} else {
			expr = getExpressionWithout(var, false);
		}
		
		//If the coefficient is larger than one, divide and take the ceiling
		if (Math.abs(targetCoef) > 1) {
			return IntegerExpressionUserFactory.floord(expr, targetCoef);
		}
		
		return expr;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case IntegerLinearAlgebraPackage.INT_LINEAR_CONSTRAINT__LINEXPR:
				if (resolve) return getLinexpr();
				return basicGetLinexpr();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case IntegerLinearAlgebraPackage.INT_LINEAR_CONSTRAINT__LINEXPR:
				return basicGetLinexpr() != null;
		}
		return super.eIsSet(featureID);
	}

	@Override
	public String toString(OUTPUT_FORMAT format) {
		switch (getComparisonOperator().ordinal()) {
		case Operator.EQ_VALUE:
			if (format == OUTPUT_FORMAT.ALPHABETS || format == OUTPUT_FORMAT.C) {
				return "" +expr.toString(format) + "== 0";
			} else {
				return "" +expr.toString(format) + "= 0";
			}
		case Operator.GT_VALUE:
			return "" +expr.toString(format) + "> 0";			
		case Operator.GE_VALUE:
			return "" +expr.toString(format) + ">= 0";			
		case Operator.LE_VALUE:
			return "" +expr.toString(format) + "<= 0";			
		case Operator.LT_VALUE:
			return "" +expr.toString(format) + "< 0";			
		default:
			return "" +expr.toString(format) + "("+getComparisonOperator()+") 0";			
		}
	}
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	@Override
	public String toString() {
		return toString(OUTPUT_FORMAT.DEFAULT);
	}

	public IntLinearConstraint copy() {
		IntLinearConstraintImpl intLinearConstraintImpl = new IntLinearConstraintImpl();
		intLinearConstraintImpl.setExpr((IntLinearExpression)expr.copy());
		intLinearConstraintImpl.setComparisonOperator(comparisonOperator);
		return intLinearConstraintImpl;
	}

} //IntLinearConstraintImpl
