/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package fr.irisa.cairn.model.integerLinearAlgebra.impl;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.util.EcoreUtil;

import fr.irisa.cairn.model.integerLinearAlgebra.IVariable;
import fr.irisa.cairn.model.integerLinearAlgebra.IntConstraint;
import fr.irisa.cairn.model.integerLinearAlgebra.IntExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntLinearConstraint;
import fr.irisa.cairn.model.integerLinearAlgebra.IntLinearConstraintSystem;
import fr.irisa.cairn.model.integerLinearAlgebra.IntMaxExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntMinExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntegerLinearAlgebraFactory;
import fr.irisa.cairn.model.integerLinearAlgebra.IntegerLinearAlgebraPackage;
import fr.irisa.cairn.model.integerLinearAlgebra.OUTPUT_FORMAT;
import fr.irisa.cairn.model.integerLinearAlgebra.factory.PrettyPrinter;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Int Linear Constraint System</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntLinearConstraintSystemImpl#getLinearConstraints <em>Linear Constraints</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class IntLinearConstraintSystemImpl extends IntConstraintSystemImpl implements IntLinearConstraintSystem {
	
	@Override
	public IntLinearConstraintSystem normalize() {
		return this;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IntLinearConstraintSystemImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return IntegerLinearAlgebraPackage.Literals.INT_LINEAR_CONSTRAINT_SYSTEM;
	}

	@Override @Deprecated
	public EList<IntConstraint> getConstraints() {
		return super.getConstraints();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public EList<IntLinearConstraint> getLinearConstraints() {
		return (EList) getConstraints(); 
	}
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public IntExpression getUB(IVariable var) {
		List<IntExpression> ubs = new LinkedList<IntExpression>();
		//Get bounds from each constraint
		for (IntLinearConstraint ilc : getLinearConstraints()) {
			IntExpression ub = ilc.getUB(var);
			if (ub != null) {
				ubs.add(ub);
			}
		}
		
		//When no bounds were found, return null
		if (ubs.size() == 0) {
			return null;
		//If only one bound is found, use that
		} else if (ubs.size() == 1) {
			return ubs.get(0);
		}
		
		//Otherwise
		//Take the max
		IntMaxExpression max = IntegerLinearAlgebraFactory.eINSTANCE.createIntMaxExpression();
		for (IntExpression ub : ubs) {
			max.getTerms().add(ub);
		}
		
		return max;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public IntExpression getLB(IVariable var) {
		List<IntExpression> lbs = new LinkedList<IntExpression>();
		//Get bounds from each constraint
		for (IntLinearConstraint ilc : getLinearConstraints()) {
			IntExpression lb = ilc.getLB(var);
			if (lb != null) {
				lbs.add(lb);
			}
		}
		
		//When no bounds were found, return null
		if (lbs.size() == 0) {
			return null;
		//If only one bound is found, use that
		} else if (lbs.size() == 1) {
			return lbs.get(0);
		}
		
		//Otherwise
		//Take the min
		IntMinExpression min = IntegerLinearAlgebraFactory.eINSTANCE.createIntMinExpression();
		for (IntExpression lb : lbs) {
			min.getTerms().add(lb);
		}
		
		return min;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case IntegerLinearAlgebraPackage.INT_LINEAR_CONSTRAINT_SYSTEM__LINEAR_CONSTRAINTS:
				return getLinearConstraints();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case IntegerLinearAlgebraPackage.INT_LINEAR_CONSTRAINT_SYSTEM__LINEAR_CONSTRAINTS:
				getLinearConstraints().clear();
				getLinearConstraints().addAll((Collection<? extends IntLinearConstraint>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case IntegerLinearAlgebraPackage.INT_LINEAR_CONSTRAINT_SYSTEM__LINEAR_CONSTRAINTS:
				getLinearConstraints().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case IntegerLinearAlgebraPackage.INT_LINEAR_CONSTRAINT_SYSTEM__LINEAR_CONSTRAINTS:
				return !getLinearConstraints().isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	@Override
	public String toString() {
		return PrettyPrinter.separate((getLinearConstraints()), " && ", OUTPUT_FORMAT.DEFAULT);
	}
	
	@Override
	public String toString(OUTPUT_FORMAT format) {
		return PrettyPrinter.separate((getLinearConstraints()), " && ", format);
	}

	
	public IntLinearConstraintSystem copy() {
		IntLinearConstraintSystem copy = (IntLinearConstraintSystem) EcoreUtil.copy(this);
		return copy;
	}

} //IntLinearConstraintSystemImpl
