/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package fr.irisa.cairn.model.integerLinearAlgebra.impl;

import fr.irisa.cairn.model.integerLinearAlgebra.IVariable;
import fr.irisa.cairn.model.integerLinearAlgebra.IntTermExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntegerLinearAlgebraPackage;
import fr.irisa.cairn.model.integerLinearAlgebra.OUTPUT_FORMAT;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Int Term Expression</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntTermExpressionImpl#getValue <em>Value</em>}</li>
 *   <li>{@link fr.irisa.cairn.model.integerLinearAlgebra.impl.IntTermExpressionImpl#getVar <em>Var</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class IntTermExpressionImpl extends IntExpressionImpl implements IntTermExpression {
	/**
	 * The default value of the '{@link #getValue() <em>Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getValue()
	 * @generated
	 * @ordered
	 */
	protected static final int VALUE_EDEFAULT = 1;

	/**
	 * The cached value of the '{@link #getValue() <em>Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getValue()
	 * @generated
	 * @ordered
	 */
	protected int value = VALUE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getVar() <em>Var</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVar()
	 * @generated
	 * @ordered
	 */
	protected IVariable var;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IntTermExpressionImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return IntegerLinearAlgebraPackage.Literals.INT_TERM_EXPRESSION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getValue() {
		return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setValue(int newValue) {
		int oldValue = value;
		value = newValue;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IntegerLinearAlgebraPackage.INT_TERM_EXPRESSION__VALUE, oldValue, value));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IVariable getVar() {
		if (var != null && var.eIsProxy()) {
			InternalEObject oldVar = (InternalEObject)var;
			var = (IVariable)eResolveProxy(oldVar);
			if (var != oldVar) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, IntegerLinearAlgebraPackage.INT_TERM_EXPRESSION__VAR, oldVar, var));
			}
		}
		return var;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IVariable basicGetVar() {
		return var;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setVar(IVariable newVar) {
		IVariable oldVar = var;
		var = newVar;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IntegerLinearAlgebraPackage.INT_TERM_EXPRESSION__VAR, oldVar, var));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case IntegerLinearAlgebraPackage.INT_TERM_EXPRESSION__VALUE:
				return getValue();
			case IntegerLinearAlgebraPackage.INT_TERM_EXPRESSION__VAR:
				if (resolve) return getVar();
				return basicGetVar();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case IntegerLinearAlgebraPackage.INT_TERM_EXPRESSION__VALUE:
				setValue((Integer)newValue);
				return;
			case IntegerLinearAlgebraPackage.INT_TERM_EXPRESSION__VAR:
				setVar((IVariable)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case IntegerLinearAlgebraPackage.INT_TERM_EXPRESSION__VALUE:
				setValue(VALUE_EDEFAULT);
				return;
			case IntegerLinearAlgebraPackage.INT_TERM_EXPRESSION__VAR:
				setVar((IVariable)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case IntegerLinearAlgebraPackage.INT_TERM_EXPRESSION__VALUE:
				return value != VALUE_EDEFAULT;
			case IntegerLinearAlgebraPackage.INT_TERM_EXPRESSION__VAR:
				return var != null;
		}
		return super.eIsSet(featureID);
	}
	
	@Override
	public String toString(OUTPUT_FORMAT format) {
		switch (format) {
		//In alphabets, no * for multiplication of terminal variable and coefficient
			case ALPHABETS:
				if (getValue() == 0) return "0";
				StringBuffer buf = new StringBuffer();
				if (getValue() < 0) {
					buf.append("-");
				}
				int abs = Math.abs(getValue());
				if (getVar() == null) {
					buf.append(abs);
				} else {
					if (abs==1) {
						
					} else {
						buf.append(abs+"");
					}
					buf.append(getVar().toString());
				}
				return buf.toString();
		}
		return super.toString(format);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	@Override
	public String toString() {
		if (getValue() == 0) {
			if(getVar()==null) {
				return "0";
			}  else {
				return "0*"+getVar();
			}
		}
		StringBuffer buf = new StringBuffer();
		if (getValue() < 0) {
			buf.append("-");
		}
		int abs = Math.abs(getValue());
		if (getVar() == null) {
			buf.append(abs);
		} else {
			if (abs==1) {
				
			} else {
				buf.append(abs+"*");
			}
			buf.append(getVar().toString());
		}
		return buf.toString();
		/*
		String txt;
		if(abs!=1) {
			txt = ""+getValue();
			if(getVar()!=null) {
				txt += getVar();
			}
		} else {
			if(getVar()!=null) {
				txt = (getValue()<0?"-":"")+ getVar();
			} else {
				txt = (getValue()<0?"-1":"1");
			}
		}
		return txt;//*/
	}

} //IntTermExpressionImpl
