package fr.irisa.cairn.model.integerLinearAlgebra.tom;

import tom.library.sl.*;
import java.util.List;

  

import fr.irisa.cairn.model.integerLinearAlgebra.*;
import fr.irisa.cairn.model.integerLinearAlgebra.adapter.*;
import static fr.irisa.cairn.model.integerLinearAlgebra.factory.IntegerExpressionUserFactory.*;
import fr.irisa.cairn.model.integerLinearAlgebra.factory.IntegerExpressionUserFactory;
import java.util.List;
import tom.library.sl.VisitFailure;

/**
 * Variable isolation tool.
 * 
 * @author antoine
 * 
 */
public class Replace{

	private static boolean tom_equal_term_Strategy(Object t1, Object t2) {return  (t1.equals(t2)) ;}private static boolean tom_is_sort_Strategy(Object t) {return  (t instanceof tom.library.sl.Strategy) ;} private static boolean tom_equal_term_Position(Object t1, Object t2) {return  (t1.equals(t2)) ;}private static boolean tom_is_sort_Position(Object t) {return  (t instanceof tom.library.sl.Position) ;} private static boolean tom_equal_term_int(int t1, int t2) {return  t1==t2 ;}private static boolean tom_is_sort_int(int t) {return  true ;} private static boolean tom_equal_term_char(char t1, char t2) {return  t1==t2 ;}private static boolean tom_is_sort_char(char t) {return  true ;} private static boolean tom_equal_term_String(String t1, String t2) {return  t1.equals(t2) ;}private static boolean tom_is_sort_String(String t) {return  t instanceof String ;} private static  tom.library.sl.Strategy  tom_make_mu( tom.library.sl.Strategy  var,  tom.library.sl.Strategy  v) { return ( new tom.library.sl.Mu(var,v) );}private static  tom.library.sl.Strategy  tom_make_MuVar( String  name) { return ( new tom.library.sl.MuVar(name) );}private static  tom.library.sl.Strategy  tom_make_Identity() { return ( new tom.library.sl.Identity() );}private static  tom.library.sl.Strategy  tom_make_One( tom.library.sl.Strategy  v) { return ( new tom.library.sl.One(v) );}private static boolean tom_is_fun_sym_Choice( tom.library.sl.Strategy  t) {return ( (t instanceof tom.library.sl.Choice) );}private static  tom.library.sl.Strategy  tom_empty_list_Choice() { return ( null );}private static  tom.library.sl.Strategy  tom_cons_list_Choice( tom.library.sl.Strategy  head,  tom.library.sl.Strategy  tail) { return ( (tail==null)?head:new tom.library.sl.Choice(head,tail) );}private static  tom.library.sl.Strategy  tom_get_head_Choice_Strategy( tom.library.sl.Strategy  t) {return ( (tom.library.sl.Strategy)t.getChildAt(tom.library.sl.Choice.FIRST) );}private static  tom.library.sl.Strategy  tom_get_tail_Choice_Strategy( tom.library.sl.Strategy  t) {return ( (tom.library.sl.Strategy)t.getChildAt(tom.library.sl.Choice.THEN) );}private static boolean tom_is_empty_Choice_Strategy( tom.library.sl.Strategy  t) {return ( t ==null );}   private static   tom.library.sl.Strategy  tom_append_list_Choice( tom.library.sl.Strategy  l1,  tom.library.sl.Strategy  l2) {     if(( l1 ==null )) {       return l2;     } else if(( l2 ==null )) {       return l1;     } else if(( (l1 instanceof tom.library.sl.Choice) )) {       if(( ( (tom.library.sl.Strategy)l1.getChildAt(tom.library.sl.Choice.THEN) ) ==null )) {         return ( (l2==null)?( (tom.library.sl.Strategy)l1.getChildAt(tom.library.sl.Choice.FIRST) ):new tom.library.sl.Choice(( (tom.library.sl.Strategy)l1.getChildAt(tom.library.sl.Choice.FIRST) ),l2) );       } else {         return ( (tom_append_list_Choice(( (tom.library.sl.Strategy)l1.getChildAt(tom.library.sl.Choice.THEN) ),l2)==null)?( (tom.library.sl.Strategy)l1.getChildAt(tom.library.sl.Choice.FIRST) ):new tom.library.sl.Choice(( (tom.library.sl.Strategy)l1.getChildAt(tom.library.sl.Choice.FIRST) ),tom_append_list_Choice(( (tom.library.sl.Strategy)l1.getChildAt(tom.library.sl.Choice.THEN) ),l2)) );       }     } else {       return ( (l2==null)?l1:new tom.library.sl.Choice(l1,l2) );     }   }   private static   tom.library.sl.Strategy  tom_get_slice_Choice( tom.library.sl.Strategy  begin,  tom.library.sl.Strategy  end, tom.library.sl.Strategy  tail) {     if( (begin.equals(end)) ) {       return tail;     } else if( (end.equals(tail))  && (( end ==null ) ||  (end.equals(tom_empty_list_Choice())) )) {       /* code to avoid a call to make, and thus to avoid looping during list-matching */       return begin;     }     return ( (( tom.library.sl.Strategy )tom_get_slice_Choice(((( (begin instanceof tom.library.sl.Choice) ))?( (tom.library.sl.Strategy)begin.getChildAt(tom.library.sl.Choice.THEN) ):tom_empty_list_Choice()),end,tail)==null)?((( (begin instanceof tom.library.sl.Choice) ))?( (tom.library.sl.Strategy)begin.getChildAt(tom.library.sl.Choice.FIRST) ):begin):new tom.library.sl.Choice(((( (begin instanceof tom.library.sl.Choice) ))?( (tom.library.sl.Strategy)begin.getChildAt(tom.library.sl.Choice.FIRST) ):begin),( tom.library.sl.Strategy )tom_get_slice_Choice(((( (begin instanceof tom.library.sl.Choice) ))?( (tom.library.sl.Strategy)begin.getChildAt(tom.library.sl.Choice.THEN) ):tom_empty_list_Choice()),end,tail)) );   }     private static  tom.library.sl.Strategy  tom_make_OnceTopDown( tom.library.sl.Strategy  v) { return ( tom_make_mu(tom_make_MuVar("_x"),tom_cons_list_Choice(v,tom_cons_list_Choice(tom_make_One(tom_make_MuVar("_x")),tom_empty_list_Choice()))) );}  private static boolean tom_equal_term_List(Object l1, Object l2) {return  l1.equals(l2) ;}private static boolean tom_is_sort_List(Object t) {return  t instanceof java.util.List ;} private static boolean tom_equal_term_IntExpression(Object t1, Object t2) {return t1.equals(t2);}private static boolean tom_is_sort_IntExpression(Object t) {return  t instanceof IntExpressionAdapter ;}private static boolean tom_equal_term_Variable(Object l1, Object l2) {return  l1.equals(l2) ;}private static  IntExpressionAdapter  tom_make_mul( int  l,  IntExpressionAdapter  r) { return  new IntExpressionAdapter(IntegerExpressionUserFactory.mul(l,r.expr()))  ;}private static boolean tom_is_fun_sym_term( IntExpressionAdapter  t) {return  t.isTerm();}private static  int  tom_get_slot_term_value( IntExpressionAdapter  t) {return  ((IntTermExpression)(t.expr())).getValue() ;}private static  IVariable  tom_get_slot_term_var( IntExpressionAdapter  t) {return  ((IntTermExpression)(t.expr())).getVar() ;}private static boolean tom_equal_term_IntExpressionList(Object l1, Object l2) {return  l1.equals(l2) ;}private static boolean tom_is_sort_IntExpressionList(Object t) {return  (t instanceof IntExpressionListAdapter) ;}  


	/**
	 * Build an expression corresponding to a variable isolation. Variable is removed and
	 * other terms are negated. Input expression isn't modified.
	 * 
	 * @param expression 
	 * @param var variable to isolate
	 * @return a new expression
	 */
	static IntExpression newExpr;

	public static IntExpression replace(IntExpression expression, IVariable var,IntExpression anewExpr) {
		try {
			newExpr=anewExpr;
			IntExpressionAdapter adapter = (IntExpressionAdapter)
					tom_make_OnceTopDown(tom_make_VariableReplacement(var)).visitLight(new IntExpressionAdapter(expression.copy()));
			return adapter.expr().simplify();
		} catch(Exception e) { 
			e.printStackTrace(); 
			throw new RuntimeException("Visitor failure on "+expression+ ":"+e.getMessage());
		}
	}

	public static class VariableReplacement extends tom.library.sl.AbstractStrategyBasic {private  IVariable  var;public VariableReplacement( IVariable  var) {super(tom_make_Identity());this.var=var;}public  IVariable  getvar() {return var;}public tom.library.sl.Visitable[] getChildren() {tom.library.sl.Visitable[] stratChilds = new tom.library.sl.Visitable[getChildCount()];stratChilds[0] = super.getChildAt(0);return stratChilds;}public tom.library.sl.Visitable setChildren(tom.library.sl.Visitable[] children) {super.setChildAt(0, children[0]);return this;}public int getChildCount() {return 1;}public tom.library.sl.Visitable getChildAt(int index) {switch (index) {case 0: return super.getChildAt(0);default: throw new IndexOutOfBoundsException();}}public tom.library.sl.Visitable setChildAt(int index, tom.library.sl.Visitable child) {switch (index) {case 0: return super.setChildAt(0, child);default: throw new IndexOutOfBoundsException();}}@SuppressWarnings("unchecked")public  IntExpressionAdapter  visit_IntExpression( IntExpressionAdapter  tom__arg, tom.library.sl.Introspector introspector) throws tom.library.sl.VisitFailure {{{if (tom_is_sort_IntExpression(tom__arg)) {if (tom_is_fun_sym_term((( IntExpressionAdapter )tom__arg))) { int  tom_k=tom_get_slot_term_value((( IntExpressionAdapter )tom__arg));

 
				IntExpressionAdapter newRes = new IntExpressionAdapter(newExpr.copy()); 
				switch (tom_k) {
					case 1:
						return newRes; 
				default:
						return tom_make_mul(tom_k,newRes); 
				}
			}}}}return _visit_IntExpression(tom__arg,introspector); }@SuppressWarnings("unchecked")public  IntExpressionAdapter  _visit_IntExpression( IntExpressionAdapter  arg, tom.library.sl.Introspector introspector) throws tom.library.sl.VisitFailure {if (!((environment ==  null ))) {return (( IntExpressionAdapter )any.visit(environment,introspector));} else {return any.visitLight(arg,introspector);} }@SuppressWarnings("unchecked")public <T> T visitLight(T v, tom.library.sl.Introspector introspector) throws tom.library.sl.VisitFailure {if (tom_is_sort_IntExpression(v)) {return ((T)visit_IntExpression((( IntExpressionAdapter )v),introspector));}if (!((environment ==  null ))) {return ((T)any.visit(environment,introspector));} else {return any.visitLight(v,introspector);} }}private static  tom.library.sl.Strategy  tom_make_VariableReplacement( IVariable  t0) { return new VariableReplacement(t0);}



}