package fr.irisa.cairn.model.integerLinearAlgebra.transforms;

import static fr.irisa.cairn.model.integerLinearAlgebra.factory.IntegerExpressionUserFactory.add;
import static fr.irisa.cairn.model.integerLinearAlgebra.factory.IntegerExpressionUserFactory.linConstraint;
import static fr.irisa.cairn.model.integerLinearAlgebra.factory.IntegerExpressionUserFactory.linConstraintSystem;
import static fr.irisa.cairn.model.integerLinearAlgebra.factory.IntegerExpressionUserFactory.linexp;
import static fr.irisa.cairn.model.integerLinearAlgebra.factory.IntegerExpressionUserFactory.mul;
import static fr.irisa.cairn.model.integerLinearAlgebra.factory.IntegerExpressionUserFactory.sub;
import static fr.irisa.cairn.model.integerLinearAlgebra.factory.IntegerExpressionUserFactory.*;
import static fr.irisa.cairn.model.integerLinearAlgebra.factory.IntegerExpressionUserFactory.var;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

import javax.management.RuntimeErrorException;
import javax.swing.plaf.synth.Region;

import tom.engine.adt.il.types.substitution.undefsubs;

import fr.irisa.cairn.model.integerLinearAlgebra.IVariable;
import fr.irisa.cairn.model.integerLinearAlgebra.IntCeilDExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntConstraint;
import fr.irisa.cairn.model.integerLinearAlgebra.IntConstraintSystem;
import fr.irisa.cairn.model.integerLinearAlgebra.IntDivExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntFloorDExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntLinearConstraint;
import fr.irisa.cairn.model.integerLinearAlgebra.IntLinearConstraintSystem;
import fr.irisa.cairn.model.integerLinearAlgebra.IntLinearExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntMaxExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntMinExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntModExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntMulExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntReductionExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntSumExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntTermExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.Operator;
import fr.irisa.cairn.model.integerLinearAlgebra.Scope;
import fr.irisa.cairn.model.integerLinearAlgebra.util.IntegerLinearAlgebraSwitch;

/**
 * 
 * @author sderrien
 * 
 */
public class Normalize extends IntegerLinearAlgebraSwitch<Boolean> {

	private IntConstraintSystem system;
	private Map<String, IVariable> map;
	private IntConstraint currentConstraint;
	private static int varid = 0;

	Stack<Operator> conType;

	Operator currentConstraintType;
	private ArrayList<IntConstraint> currentList;
	private boolean VERBOSE = false;
	Scope scope;

	public Normalize(IntConstraintSystem system) {
		this.system = system;
		map = new HashMap<String, IVariable>();
		conType = new Stack<Operator>();
	}

	public static IntLinearConstraintSystem normalize(IntConstraintSystem system) {
		Normalize instance = new Normalize(system);
		IntLinearConstraintSystem normalize = instance.normalize();
		instance.checkNormalization(normalize);
		
		return normalize;
	}

	public static IntLinearConstraintSystem normalize(IntConstraintSystem system,Scope scope) {
		Normalize instance = new Normalize(system);
		instance.scope=scope;
		IntLinearConstraintSystem normalize = instance.normalize(scope);
		instance.checkNormalization(normalize);
		
		return normalize;
	}

	private void debug(String mess) {
		if (VERBOSE) {
			System.out.println(mess);
		}
	}

	private IntLinearConstraintSystem normalize() {
		if (system.getScopeContainter() != null) {
			scope = system.getScopeContainter().getScope();
			return normalize(scope);
		} else {
			throw new UnsupportedOperationException("Cannot normalize since the system is not attached to a ScopeContainer");
		}
	}

	private IntLinearConstraintSystem normalize(Scope scope) {
		/**
		 * We first check whether the system actually need to be normalized
		 */
		if (system instanceof IntLinearConstraintSystem)
			return (IntLinearConstraintSystem) system;

		boolean isalreadyAffine = true;
		IntLinearConstraintSystem res = linConstraintSystem();
		for (IntConstraint constraint : system.getConstraints()) {
			boolean affine = constraint.isAffine();
			if (!affine) {
				isalreadyAffine = false;
			} else {
				IntConstraint copy = constraint.copy();
				try {
					res.getLinearConstraints().add((IntLinearConstraint) copy);
				} catch (Exception e) {
					System.out.println(copy);// TODO: handle exception
				}
			}
		}
		if (isalreadyAffine) {
			checkNormalization(res);
			return res;
		} else {
			if (scope != null) {
				currentList = new ArrayList<IntConstraint>();
				List<IntConstraint> previous = new ArrayList<IntConstraint>(
						system.getConstraints());
				boolean fixpoint = false;

				int i = 0;
				while (!fixpoint) {
					fixpoint = true;
					debug("***** Stage " + (i++) + " *****");
					for (IntConstraint constraint : previous) {
						currentConstraint = constraint;
						currentConstraintType = currentConstraint
								.getComparisonOperator();
						debug("\t- " + currentConstraint);
						Boolean touched = doSwitch(currentConstraint.getExpr());
						if (touched) {
							fixpoint = false;
						}
						currentList.add(currentConstraint);
						debug("\t\t- currentList = " + currentList);
						debug("\t\t- previousList = " + previous);
					}
					previous = currentList;
					currentList = new ArrayList<IntConstraint>();
				}
				debug("previous " + previous);
				res.setScopeContainter(system.getScopeContainter());
				for (IntConstraint contraint : previous) {
					IntLinearConstraint linConstraint = linConstraint(
							linexp(contraint.getExpr()),
							contraint.getComparisonOperator());
					debug("adding " + linConstraint);
					res.getConstraints().add(linConstraint);
				}

				checkNormalization(res);
				return res;
			}
			throw new UnsupportedOperationException(
					"Cannot normalize since the system does not have a scope");
		}

	}

	private void checkNormalization(IntLinearConstraintSystem res) {
		for (IntConstraint constraint : res.getConstraints()) {
			if (!(constraint instanceof IntLinearConstraint)) {
				throw new UnsupportedOperationException("Error in normalize !");
			}
			if (!constraint.isAffine()) {
				throw new UnsupportedOperationException("Error in normalize !");
			}
		}
	}

	@Override
	public Boolean caseIntExpression(IntExpression object) {
		return false;
	}

	@Override
	public Boolean caseIntSumExpression(IntSumExpression object) {
		boolean touched = false;
		for (IntExpression child : object.getTerms()) {
			touched |= doSwitch(child);
		}
		return touched;
	}

	@Override
	public Boolean caseIntMulExpression(IntMulExpression object) {
		Operator old = currentConstraintType;

		if (object.getFactor() < 0) {
			switch (currentConstraintType) {
			case LT:
				currentConstraintType = Operator.GT;
				break;
			case LE:
				currentConstraintType = Operator.GE;
				break;
			case GT:
				currentConstraintType = Operator.LT;
				break;
			case GE:
				currentConstraintType = Operator.LE;
				break;
			}
		}
		Boolean res = doSwitch(object.getExpr());
		currentConstraintType = old;
		return res;
	}

	@Override
	public Boolean caseIntDivExpression(IntDivExpression object) {
		IntLinearExpression linexp = null;
		IVariable ivar = getExistentialVariable(object);
		if (ivar == null) {
			int denum = object.getDenum();
			ivar = registerExistentialVariable("div_" + denum, object);
			addDivRangeConstraint(denum, ivar, object.getExpr());
		}
		linexp = linexp(term(ivar));
		debug(object + "=>");
		object.substituteWith(linexp);
		debug("" + currentConstraint);
		return true;
	}

	private void addDivRangeConstraint(int denum, IVariable newVarDiv,
			IntExpression child) {
		IntLinearExpression lb = linexp(sub(mul(denum, term(newVarDiv)),
				child.copy()));
		IntLinearExpression ub = linexp(sub(
				add(mul(denum, term(newVarDiv)), term(denum - 1)), child.copy()));
		currentList.add(linConstraint(lb, Operator.LE));
		currentList.add(linConstraint(ub, Operator.LE));
	}

	@Override
	public Boolean caseIntCeilDExpression(IntCeilDExpression object) {
		IntLinearExpression linexp = null;
		IVariable ivar = getExistentialVariable(object);
		int denum = object.getDenum();
		if (ivar == null) {
			ivar = registerExistentialVariable("div_" + denum, object);
			addDivRangeConstraint(denum, ivar, object.getExpr());
		}
		linexp = linexp(add(term(ivar), term(denum - 1)));
		debug(object + "=>");
		object.substituteWith(linexp);
		debug("" + currentConstraint);
		return true;

	}

	/**
	 * Min/max are disjunctive constraint ?
	 */
	@Override
	public Boolean caseIntMinExpression(IntMinExpression object) {
		switch (currentConstraintType) {
		case GT:
		case GE:
			IVariable ivar = getExistentialVariable(object);
			if (ivar == null) {
				ivar = registerExistentialVariable("min_" , object);
			}
			for (IntExpression child : object.getTerms()) {
				currentList.add(linConstraint(linexp(sub(term(ivar),child.copy())), Operator.LE));
			}
			object.substituteWith(term(ivar));
			return true;
		default:
			throw new UnsupportedOperationException("Cannot normalize "
					+ object + " in " + system);
		}

	}

	@Override
	public Boolean caseIntMaxExpression(IntMaxExpression object) {
	

		switch (currentConstraintType) {
		case LT:
		case LE:
			IVariable ivar = getExistentialVariable(object);
			if (ivar == null) {
				ivar = registerExistentialVariable("max_" , object);
			}
			for (IntExpression child : object.getTerms()) {
				currentList.add(linConstraint(linexp(sub(term(ivar),child.copy())), Operator.GE));
			}
			object.substituteWith(term(ivar));
			return true;
		default:
			throw new UnsupportedOperationException("Cannot normalize "
					+ object + " in " + system);
		}
	}

	private IVariable registerExistentialVariable(String name,
			IntExpression expression) {
		IVariable ivar = var("e" + (varid)++ + "" + name);
		map.put(expression.toString(), ivar);
		scope.getSymbols().add(ivar);
		return ivar;
	}

	private IVariable getExistentialVariable(IntExpression expression) {
		String string = expression.toString();
		if (map.containsKey(string)) {
			return map.get(string);
		} else {
			return null;
		}
	}

	@Override
	public Boolean caseIntFloorDExpression(IntFloorDExpression object) {
		IntLinearExpression linexp = null;
		IVariable ivar = getExistentialVariable(object);
		if (ivar == null) {
			int denum = object.getDenum();
			ivar = registerExistentialVariable("div_" + denum, object);
			addDivRangeConstraint(denum, ivar, object.getExpr());
		}
		linexp = linexp(term(ivar));
		debug(object + "=>");
		object.substituteWith(linexp);
		debug("" + currentConstraint);
		return true;
	}

	private void addDivModEquConstraint(int denum, IVariable newVarMod,
			IVariable newVarDiv, IntExpression child) {
		/*
		 * building modulo + denum*div = expr constraint
		 */
		IntExpression val = sub(
				add(term(newVarMod), mul(denum, term(newVarDiv))), child.copy());
		currentList.add(linConstraint(linexp(val), Operator.EQ));
	}

	private void addModRangeConstraint(int denum, IVariable newVarMod) {
		/*
		 * building 0 <= modulo <= denum-1 constraint
		 */
		currentList.add(linConstraint(linexp(term(newVarMod)), Operator.GE));
		currentList.add(linConstraint(
				linexp(sub(term(newVarMod), term(denum - 1))), Operator.LE));
	}

	@Override
	public Boolean caseIntModExpression(IntModExpression object) {
		IntLinearExpression linexp = null;
		IVariable ivar = getExistentialVariable(object);
		if (ivar == null) {
			int denum = object.getDenum();

			ivar = registerExistentialVariable("mod_" + denum, object);
			IntExpression child = object.getExpr();
			IVariable newVarDiv = registerExistentialVariable("div_" + denum,
					floord(child, denum));
			registerExistentialVariable("div_" + denum, object);

			addDivModEquConstraint(denum, ivar, newVarDiv, child);
			addDivRangeConstraint(denum, newVarDiv, child);
			addModRangeConstraint(denum, ivar);
		}
		linexp = linexp(term(ivar));
		debug(object + "=>");
		object.substituteWith(linexp);
		debug("" + currentConstraint);
		return true;
	}

}
