package fr.irisa.cairn.model.integerLinearAlgebra.transforms;

import static fr.irisa.cairn.model.integerLinearAlgebra.factory.IntegerExpressionUserFactory.*;
import static fr.irisa.cairn.model.integerLinearAlgebra.factory.IntegerExpressionUserFactory.constraintSystem;
import static fr.irisa.cairn.model.integerLinearAlgebra.factory.IntegerExpressionUserFactory.*;
import fr.irisa.cairn.model.integerLinearAlgebra.IVariable;
import fr.irisa.cairn.model.integerLinearAlgebra.IntConstraintSystem;
import fr.irisa.cairn.model.integerLinearAlgebra.IntLinearConstraintSystem;
import fr.irisa.cairn.model.integerLinearAlgebra.Operator;
import fr.irisa.cairn.model.integerLinearAlgebra.Scope;
import fr.irisa.cairn.model.integerLinearAlgebra.ScopeContainer;
import fr.irisa.cairn.model.integerLinearAlgebra.SymbolVariable;

public class TestNormalize {

	
	public void testNormalizeMax() {
		SymbolVariable i = var("i");
		SymbolVariable j = var("j");
		SymbolVariable vars[]= new SymbolVariable []{ 
				i,j
		};
		IntConstraintSystem test0 = constraintSystem(constraint(max(term(j),term(i)),Operator.LE,term(3)));
		
		IntLinearConstraintSystem res = Normalize.normalize(test0, scope());
		System.out.println(test0);
		System.out.println("=>");
		System.out.println(res);
	}
	
	public static void main(String[] args) {
		SymbolVariable i = var("i");
		SymbolVariable j = var("j");
//		SymbolVariable k = var("k");
//		SymbolVariable l = var("l");
		SymbolVariable vars[]= new SymbolVariable []{ 
				i,j//,k,l
		};
		IntConstraintSystem test0 = constraintSystem(
//				constraint("2i+j<=5",vars),
//				constraint(mod(sum(term(i),mul(7,term(j))),5),Operator.EQ,term(3)),
//				constraint(mul(-1,mod(term(i),3)),Operator.EQ,term(3)),
//				constraint(sum(term(j),mod(term(i),3)),Operator.EQ,term(3)),
//				constraint(sum(term(j),floord(term(i),3)),Operator.LE,term(3)),
//				constraint(floord(term(i),3),Operator.LE,term(3)),
				constraint(max(term(j),term(i)),Operator.LE,term(3))
				);
		
		Scope scope = scope();
		IntLinearConstraintSystem res = Normalize.normalize(test0, scope);
		System.out.println(test0);
		System.out.println("=>");
		System.out.println(res);
	}

}
