package fr.irisa.cairn.model.integerLinearAlgebra.util;

import fr.irisa.cairn.model.integerLinearAlgebra.IVariable;
import fr.irisa.cairn.model.integerLinearAlgebra.IntDivExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntMulExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntReductionExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntTermExpression;

public class IntExpressionQuery {
	
	public static boolean containsVar(IntExpression expr, IVariable var) {
		ContainsQuery containsQuery = new ContainsQuery(var);
		return (containsQuery.doSwitch(expr));
	}

	public static class ContainsQuery extends IntegerLinearAlgebraSwitch<Boolean> {
		
		IVariable var;

		public ContainsQuery(IVariable var) {
			this.var=var;
		}
		
		
		@Override
		public Boolean caseIntTermExpression(IntTermExpression object) {
			if(object.getVar()==var) {
				return true;
			}
			return false;
		}

		@Override
		public Boolean caseIntDivExpression(IntDivExpression object) {
			return doSwitch(object.getExpr());
		}

		@Override
		public Boolean caseIntMulExpression(IntMulExpression object) {
			return doSwitch(object.getExpr());
		}

		@Override
		public Boolean caseIntReductionExpression(IntReductionExpression object) {
			for (IntExpression child : object.getTerms()) {
				if(doSwitch(child)) return true;
			}
			return false;
		}

		
	}
}
