/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package fr.irisa.cairn.model.integerLinearAlgebra.util;

import fr.irisa.cairn.model.integerLinearAlgebra.*;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see fr.irisa.cairn.model.integerLinearAlgebra.IntegerLinearAlgebraPackage
 * @generated
 */
public class IntegerLinearAlgebraSwitch<T> {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static IntegerLinearAlgebraPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IntegerLinearAlgebraSwitch() {
		if (modelPackage == null) {
			modelPackage = IntegerLinearAlgebraPackage.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	public T doSwitch(EObject theEObject) {
		return doSwitch(theEObject.eClass(), theEObject);
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected T doSwitch(EClass theEClass, EObject theEObject) {
		if (theEClass.eContainer() == modelPackage) {
			return doSwitch(theEClass.getClassifierID(), theEObject);
		}
		else {
			List<EClass> eSuperTypes = theEClass.getESuperTypes();
			return
				eSuperTypes.isEmpty() ?
					defaultCase(theEObject) :
					doSwitch(eSuperTypes.get(0), theEObject);
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected T doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case IntegerLinearAlgebraPackage.INTEGER_MAPPING_EXPRESSION: {
				IntegerMappingExpression integerMappingExpression = (IntegerMappingExpression)theEObject;
				T result = caseIntegerMappingExpression(integerMappingExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IntegerLinearAlgebraPackage.INTEGER_LINEAR_CONSTRAINT_PROBLEM: {
				IntegerLinearConstraintProblem integerLinearConstraintProblem = (IntegerLinearConstraintProblem)theEObject;
				T result = caseIntegerLinearConstraintProblem(integerLinearConstraintProblem);
				if (result == null) result = caseScopeContainer(integerLinearConstraintProblem);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IntegerLinearAlgebraPackage.IPRETTY_PRINT: {
				IPrettyPrint iPrettyPrint = (IPrettyPrint)theEObject;
				T result = caseIPrettyPrint(iPrettyPrint);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IntegerLinearAlgebraPackage.SCOPE_CONTAINER: {
				ScopeContainer scopeContainer = (ScopeContainer)theEObject;
				T result = caseScopeContainer(scopeContainer);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IntegerLinearAlgebraPackage.SCOPE: {
				Scope scope = (Scope)theEObject;
				T result = caseScope(scope);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IntegerLinearAlgebraPackage.IVARIABLE: {
				IVariable iVariable = (IVariable)theEObject;
				T result = caseIVariable(iVariable);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IntegerLinearAlgebraPackage.INT_EXPRESSION: {
				IntExpression intExpression = (IntExpression)theEObject;
				T result = caseIntExpression(intExpression);
				if (result == null) result = caseIPrettyPrint(intExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IntegerLinearAlgebraPackage.INT_MAX: {
				IntMax intMax = (IntMax)theEObject;
				T result = caseIntMax(intMax);
				if (result == null) result = caseIntExpression(intMax);
				if (result == null) result = caseIPrettyPrint(intMax);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IntegerLinearAlgebraPackage.INT_MIN: {
				IntMin intMin = (IntMin)theEObject;
				T result = caseIntMin(intMin);
				if (result == null) result = caseIntExpression(intMin);
				if (result == null) result = caseIPrettyPrint(intMin);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IntegerLinearAlgebraPackage.INT_TERM_EXPRESSION: {
				IntTermExpression intTermExpression = (IntTermExpression)theEObject;
				T result = caseIntTermExpression(intTermExpression);
				if (result == null) result = caseIntExpression(intTermExpression);
				if (result == null) result = caseIPrettyPrint(intTermExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IntegerLinearAlgebraPackage.INT_DIV_EXPRESSION: {
				IntDivExpression intDivExpression = (IntDivExpression)theEObject;
				T result = caseIntDivExpression(intDivExpression);
				if (result == null) result = caseIntExpression(intDivExpression);
				if (result == null) result = caseIPrettyPrint(intDivExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IntegerLinearAlgebraPackage.INT_MOD_EXPRESSION: {
				IntModExpression intModExpression = (IntModExpression)theEObject;
				T result = caseIntModExpression(intModExpression);
				if (result == null) result = caseIntDivExpression(intModExpression);
				if (result == null) result = caseIntExpression(intModExpression);
				if (result == null) result = caseIPrettyPrint(intModExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IntegerLinearAlgebraPackage.INT_FLOOR_DEXPRESSION: {
				IntFloorDExpression intFloorDExpression = (IntFloorDExpression)theEObject;
				T result = caseIntFloorDExpression(intFloorDExpression);
				if (result == null) result = caseIntDivExpression(intFloorDExpression);
				if (result == null) result = caseIntExpression(intFloorDExpression);
				if (result == null) result = caseIPrettyPrint(intFloorDExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IntegerLinearAlgebraPackage.INT_CEIL_DEXPRESSION: {
				IntCeilDExpression intCeilDExpression = (IntCeilDExpression)theEObject;
				T result = caseIntCeilDExpression(intCeilDExpression);
				if (result == null) result = caseIntDivExpression(intCeilDExpression);
				if (result == null) result = caseIntExpression(intCeilDExpression);
				if (result == null) result = caseIPrettyPrint(intCeilDExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IntegerLinearAlgebraPackage.INT_MUL_EXPRESSION: {
				IntMulExpression intMulExpression = (IntMulExpression)theEObject;
				T result = caseIntMulExpression(intMulExpression);
				if (result == null) result = caseIntExpression(intMulExpression);
				if (result == null) result = caseIPrettyPrint(intMulExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IntegerLinearAlgebraPackage.INT_REDUCTION_EXPRESSION: {
				IntReductionExpression intReductionExpression = (IntReductionExpression)theEObject;
				T result = caseIntReductionExpression(intReductionExpression);
				if (result == null) result = caseIntExpression(intReductionExpression);
				if (result == null) result = caseIPrettyPrint(intReductionExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IntegerLinearAlgebraPackage.INT_SUM_EXPRESSION: {
				IntSumExpression intSumExpression = (IntSumExpression)theEObject;
				T result = caseIntSumExpression(intSumExpression);
				if (result == null) result = caseIntReductionExpression(intSumExpression);
				if (result == null) result = caseIntExpression(intSumExpression);
				if (result == null) result = caseIPrettyPrint(intSumExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IntegerLinearAlgebraPackage.INT_PROD_EXPRESSION: {
				IntProdExpression intProdExpression = (IntProdExpression)theEObject;
				T result = caseIntProdExpression(intProdExpression);
				if (result == null) result = caseIntReductionExpression(intProdExpression);
				if (result == null) result = caseIntExpression(intProdExpression);
				if (result == null) result = caseIPrettyPrint(intProdExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IntegerLinearAlgebraPackage.INT_LINEAR_EXPRESSION: {
				IntLinearExpression intLinearExpression = (IntLinearExpression)theEObject;
				T result = caseIntLinearExpression(intLinearExpression);
				if (result == null) result = caseIntSumExpression(intLinearExpression);
				if (result == null) result = caseIntReductionExpression(intLinearExpression);
				if (result == null) result = caseIntExpression(intLinearExpression);
				if (result == null) result = caseIPrettyPrint(intLinearExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IntegerLinearAlgebraPackage.INT_MAX_EXPRESSION: {
				IntMaxExpression intMaxExpression = (IntMaxExpression)theEObject;
				T result = caseIntMaxExpression(intMaxExpression);
				if (result == null) result = caseIntReductionExpression(intMaxExpression);
				if (result == null) result = caseIntExpression(intMaxExpression);
				if (result == null) result = caseIPrettyPrint(intMaxExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IntegerLinearAlgebraPackage.INT_MIN_EXPRESSION: {
				IntMinExpression intMinExpression = (IntMinExpression)theEObject;
				T result = caseIntMinExpression(intMinExpression);
				if (result == null) result = caseIntReductionExpression(intMinExpression);
				if (result == null) result = caseIntExpression(intMinExpression);
				if (result == null) result = caseIPrettyPrint(intMinExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IntegerLinearAlgebraPackage.INT_LINEAR_CONSTRAINT_SYSTEM: {
				IntLinearConstraintSystem intLinearConstraintSystem = (IntLinearConstraintSystem)theEObject;
				T result = caseIntLinearConstraintSystem(intLinearConstraintSystem);
				if (result == null) result = caseIntConstraintSystem(intLinearConstraintSystem);
				if (result == null) result = caseIPrettyPrint(intLinearConstraintSystem);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IntegerLinearAlgebraPackage.INT_LINEAR_CONSTRAINT: {
				IntLinearConstraint intLinearConstraint = (IntLinearConstraint)theEObject;
				T result = caseIntLinearConstraint(intLinearConstraint);
				if (result == null) result = caseIntConstraint(intLinearConstraint);
				if (result == null) result = caseIPrettyPrint(intLinearConstraint);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IntegerLinearAlgebraPackage.SYMBOL_VARIABLE: {
				SymbolVariable symbolVariable = (SymbolVariable)theEObject;
				T result = caseSymbolVariable(symbolVariable);
				if (result == null) result = caseIVariable(symbolVariable);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IntegerLinearAlgebraPackage.INT_CONSTRAINT: {
				IntConstraint intConstraint = (IntConstraint)theEObject;
				T result = caseIntConstraint(intConstraint);
				if (result == null) result = caseIPrettyPrint(intConstraint);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IntegerLinearAlgebraPackage.INT_CONSTRAINT_SYSTEM: {
				IntConstraintSystem intConstraintSystem = (IntConstraintSystem)theEObject;
				T result = caseIntConstraintSystem(intConstraintSystem);
				if (result == null) result = caseIPrettyPrint(intConstraintSystem);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IntegerLinearAlgebraPackage.INTEGER_MAPPING_SYSTEM: {
				IntegerMappingSystem integerMappingSystem = (IntegerMappingSystem)theEObject;
				T result = caseIntegerMappingSystem(integerMappingSystem);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case IntegerLinearAlgebraPackage.INT_CONSTRAINT_EXPRESSION: {
				IntConstraintExpression intConstraintExpression = (IntConstraintExpression)theEObject;
				T result = caseIntConstraintExpression(intConstraintExpression);
				if (result == null) result = caseIPrettyPrint(intConstraintExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Integer Mapping Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Integer Mapping Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIntegerMappingExpression(IntegerMappingExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Integer Linear Constraint Problem</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Integer Linear Constraint Problem</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIntegerLinearConstraintProblem(IntegerLinearConstraintProblem object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>IPretty Print</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>IPretty Print</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIPrettyPrint(IPrettyPrint object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Scope Container</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Scope Container</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseScopeContainer(ScopeContainer object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Scope</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Scope</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseScope(Scope object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>IVariable</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>IVariable</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIVariable(IVariable object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Int Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Int Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIntExpression(IntExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Int Max</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Int Max</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIntMax(IntMax object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Int Min</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Int Min</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIntMin(IntMin object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Int Term Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Int Term Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIntTermExpression(IntTermExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Int Div Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Int Div Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIntDivExpression(IntDivExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Int Mod Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Int Mod Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIntModExpression(IntModExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Int Floor DExpression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Int Floor DExpression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIntFloorDExpression(IntFloorDExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Int Ceil DExpression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Int Ceil DExpression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIntCeilDExpression(IntCeilDExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Int Mul Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Int Mul Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIntMulExpression(IntMulExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Int Reduction Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Int Reduction Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIntReductionExpression(IntReductionExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Int Sum Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Int Sum Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIntSumExpression(IntSumExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Int Prod Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Int Prod Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIntProdExpression(IntProdExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Int Linear Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Int Linear Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIntLinearExpression(IntLinearExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Int Max Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Int Max Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIntMaxExpression(IntMaxExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Int Min Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Int Min Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIntMinExpression(IntMinExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Int Linear Constraint System</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Int Linear Constraint System</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIntLinearConstraintSystem(IntLinearConstraintSystem object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Int Linear Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Int Linear Constraint</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIntLinearConstraint(IntLinearConstraint object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Symbol Variable</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Symbol Variable</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSymbolVariable(SymbolVariable object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Int Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Int Constraint</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIntConstraint(IntConstraint object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Int Constraint System</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Int Constraint System</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIntConstraintSystem(IntConstraintSystem object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Integer Mapping System</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Integer Mapping System</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIntegerMappingSystem(IntegerMappingSystem object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Int Constraint Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Int Constraint Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIntConstraintExpression(IntConstraintExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public T defaultCase(EObject object) {
		return null;
	}

} //IntegerLinearAlgebraSwitch
