package tests;

import static fr.irisa.cairn.model.integerLinearAlgebra.factory.IntegerExpressionUserFactory.linConstraint;
import static fr.irisa.cairn.model.integerLinearAlgebra.factory.IntegerExpressionUserFactory.linConstraintSystem;
import static fr.irisa.cairn.model.integerLinearAlgebra.factory.IntegerExpressionUserFactory.linexp;
import static fr.irisa.cairn.model.integerLinearAlgebra.factory.IntegerExpressionUserFactory.term;
import static fr.irisa.cairn.model.integerLinearAlgebra.factory.IntegerExpressionUserFactory.var;

import java.util.ArrayList;
import java.util.List;

import junit.framework.TestCase;
import fr.irisa.cairn.model.integerLinearAlgebra.IVariable;
import fr.irisa.cairn.model.integerLinearAlgebra.IntConstraint;
import fr.irisa.cairn.model.integerLinearAlgebra.IntConstraintSystem;
import fr.irisa.cairn.model.integerLinearAlgebra.IntLinearConstraintSystem;
import fr.irisa.cairn.model.integerLinearAlgebra.IntLinearExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.IntTermExpression;
import fr.irisa.cairn.model.integerLinearAlgebra.Operator;
import fr.irisa.cairn.model.integerLinearAlgebra.factory.IntegerExpressionUserFactory;

public class TestNegate extends TestCase{

	public static void testNegate() {
		IVariable i = var("i");
		IVariable j = var("j");
		IVariable k = var("k");
		List<IVariable> list = new ArrayList<IVariable>();
		list.add(i);
		list.add(j);
		list.add(k);

		List<IntLinearConstraintSystem> syss = new ArrayList<IntLinearConstraintSystem>();
		syss.add(linConstraintSystem(
				linConstraint(linexp(term(i)), Operator.GE),
				linConstraint(linexp(term(j)), Operator.GE)));
		syss.add(linConstraintSystem(
				linConstraint(linexp(term(i)), Operator.GE),
				linConstraint(linexp(term(k)), Operator.GE)));
		
		System.out.println(syss);
		
		List<? extends IntConstraintSystem> res = IntegerExpressionUserFactory.negate(syss);
		
		System.out.println(res);
		//check that variables are the same
		for (IntConstraintSystem s : res) {
			for (IntConstraint c : s.getConstraints()) {
				IntLinearExpression e = linexp(c.getExpr());
				for (IntTermExpression t : e.getSimpleTerms()) {
					IVariable v = t.getVar();
					if (v != null) {
						assertTrue(list.contains(v));
					}
				}
			}
		}

		System.out.println(syss);
		//check that variables are the same
		for (IntConstraintSystem s : syss) {
			for (IntConstraint c : s.getConstraints()) {
				IntLinearExpression e = linexp(c.getExpr());
				for (IntTermExpression t : e.getSimpleTerms()) {
					IVariable v = t.getVar();
					if (v != null) {
						assertTrue(list.contains(v));
					}
				}
			}
		}
	}
	
	public static void testNENegate() {
		
		IVariable i = var("i");
		IVariable j = var("j");
		IVariable k = var("k");
		List<IVariable> list = new ArrayList<IVariable>();
		list.add(i);
		list.add(j);
		list.add(k);

		List<IntLinearConstraintSystem> syss = new ArrayList<IntLinearConstraintSystem>();
		syss.add(linConstraintSystem(
				linConstraint(linexp(term(i)), Operator.EQ),
				linConstraint(linexp(term(j)), Operator.GE)));
		syss.add(linConstraintSystem(
				linConstraint(linexp(term(j)), Operator.GE),
				linConstraint(linexp(term(k)), Operator.GE)));
		
		System.out.println(syss);

		List<? extends IntConstraintSystem> res = IntegerExpressionUserFactory.negate(syss);
		
		System.out.println(res);
		
		
	}
}
