package fr.irisa.cairn.jnimap.isl.jni;

public class ISLFactory {

	public static final int ISL_FORMAT_ISL=0;
	public static final int ISL_FORMAT_POLYLIB=1;
	public static final int ISL_FORMAT_POLYLIB_CONSTRAINTS=2;
	public static final int ISL_FORMAT_OMEGA=3;
	public static final int ISL_FORMAT_C	=		4;
	public static final int ISL_FORMAT_LATEX=		5;

	public static JNIISLContext getContext() {
		return JNIISLContext.getCtx();
	}
	
	public static JNIISLSet islSet(String setTxt) {
		return new JNIISLSet(getContext(), setTxt);
	}
	
	public static JNIISLUnionMap islUnionMap(String setTxt) {
		return new JNIISLUnionMap(getContext(), setTxt);
	}

	public static JNIISLUnionSet islUnionSet(String setTxt) {
		return new JNIISLUnionSet(getContext(), setTxt);
	}
	
	public static JNIISLBasicSet islBasicSet(String bsetTxt) {
		return new JNIISLBasicSet(getContext(), bsetTxt);
	}

//	public static JNIISLBasicMap islBasicMap(String bsetTxt) {
//		return new JNIISLBasicMap(getContext(), bsetTxt,-1);
//	}

	public static JNIISLMap islMap(String setTxt) {
		return new JNIISLMap(getContext(), setTxt);
	}
	
	public static JNIISLBasicMap islBasicMap(String setTxt) {
		return new JNIISLBasicMap(getContext(), setTxt);
	}


	public static JNIISLPWQPolynomial islPWQPolynomial(String setTxt) {
		return new JNIISLPWQPolynomial(getContext(), setTxt);
	}

	public static String asString(JNIISLSet set) {
		return JNIISLSet._toString(getContext(), set, ISL_FORMAT_ISL);
	}
	
	public static String asString(JNIISLMap set) {
		return JNIISLMap._toString(getContext(), set, ISL_FORMAT_ISL);
	}

	public static String asString(JNIISLBasicSet set) {
		return JNIISLBasicSet._toString(getContext(), set, ISL_FORMAT_ISL);
	}
	
	public static String asString(JNIISLBasicMap map) {
		return JNIISLBasicMap._toString(getContext(), map, ISL_FORMAT_ISL);
	}
}
