
package fr.irisa.cairn.jnimap.isl.jni;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import fr.irisa.cairn.jnimap.isl.jni.platform.*;

public class ISLNative {

	private static final String arch = System.getProperty("sun.arch.data.model");

	private static JNIISLAbstractPlatform loader ;


 
	static  {
		String osName= System.getProperty("os.name");
		String arch = System.getProperty("sun.arch.data.model");
		if(osName.equals("Linux")) {
			if(arch.equals("32")) {
				loader = new JNIISLLinux_32();
			} else {
				loader = new JNIISLLinux_64();
			} 
		} else if (osName.equals("Windows XP")) {
			loader = new JNIISLCygwin_32();
		} else if (osName.equals("Mac OS X")) {
			if(arch.equals("32")) {
				loader = new JNIISLMacosx_32();
			} else {
				loader = new JNIISLMacosx_64();
			} 
		} else  {
			throw new RuntimeException("Unsupported Operating system : " + osName+"_"+arch);
		}
		loader.loadPlatformLibraries();
	}

	
	public static native long derefPointer(long ptr);
	
	public static native long isl_stream_new_str(long ctx,String str);
	public static native void isl_stream_free(long s);
	public static native long isl_options_new_with_defaults();
	public static native long isl_map_n_in(long map);
	public static native long isl_map_n_out(long map);
	public static native long isl_map_n_param(long map);
	public static native long isl_map_dim(long map,int type);
	public static native long isl_map_get_space(long map);
	public static native long isl_map_from_basic_map(long bmap);
	public static native long isl_map_read_from_str(long ctx,String str);
	public static native long isl_map_sum(long map1,long map2);
	public static native long isl_map_neg(long map);
	public static native long isl_map_partial_lexmax(long map,long dom,long empty);
	public static native long isl_map_partial_lexmin(long map,long dom,long empty);
	public static native int isl_map_is_bijective(long map);
	public static native long isl_map_lexmin(long map);
	public static native long isl_map_lexmax(long map);
	public static native long isl_map_copy_basic_map(long map);
	public static native long isl_map_drop_basic_map(long map,long bmap);
	public static native long isl_map_extend(long base,long nparam,long n_in,long n_out);
	public static native long isl_map_alloc(long ctx,long nparam,long n_in,long out,int n,long flags);
	public static native long isl_map_universe(long dim);
	public static native long isl_map_empty(long dim);
	public static native long isl_map_empty_like(long model);
	public static native long isl_map_dup(long map);
	public static native long isl_map_add_basic_map(long map,long bmap);
	public static native long isl_map_set_dim_name(long map,int type,long pos,String s);
	public static native long isl_map_transitive_closure_jnimap(long map);
	public static native void isl_map_free(long map);
	public static native long isl_map_identity_like(long model);
	public static native long isl_map_finalize(long map);
	public static native long isl_map_copy(long map);
	public static native long isl_map_reverse(long map);
	public static native long isl_map_union(long map1,long map2);
	public static native long isl_map_union_disjoint(long map1,long map2);
	public static native long isl_map_intersect_domain(long map,long set);
	public static native long isl_map_intersect_range(long map,long set);
	public static native long isl_map_apply_domain(long map1,long map2);
	public static native long isl_map_apply_range(long map1,long map2);
	public static native long isl_map_product(long map1,long map2);
	public static native long isl_map_intersect(long map1,long map2);
	public static native long isl_map_subtract(long map1,long map2);
	public static native long isl_map_fix_input_si(long map,long input,int value);
	public static native long isl_map_fix_si(long map,int type,long pos,int value);
	public static native long isl_map_lower_bound_si(long map,int type,long pos,int value);
	public static native long isl_map_deltas(long map);
	public static native long isl_map_detect_equalities(long map);
	public static native long isl_map_affine_hull(long map);
	public static native long isl_map_convex_hull(long map);
	public static native long isl_map_insert_dims(long map,int type,long pos,long n);
	public static native long isl_map_move_dims(long map,int dst_type,long dst_pos,int src_type,long src_pos,long n);
	public static native long isl_map_project_out(long map,int type,long first,long n);
	public static native long isl_map_remove_inputs(long map,long first,long n);
	public static native long isl_map_domain(long bmap);
	public static native long isl_map_range(long map);
	public static native long isl_map_from_domain(long set);
	public static native long isl_map_from_range(long set);
	public static native long isl_map_from_domain_and_range(long domain,long range);
	public static native long isl_map_from_set(long set,long dim);
	public static native long isl_map_sample(long map);
	public static native int isl_map_fast_is_empty(long map);
	public static native int isl_map_is_empty(long map);
	public static native int isl_map_is_subset(long map1,long map2);
	public static native int isl_map_is_strict_subset(long map1,long map2);
	public static native int isl_map_is_equal(long map1,long map2);
	public static native long isl_map_make_disjoint(long map);
	public static native long isl_map_compute_divs(long map);
	public static native long isl_map_align_divs(long map);
	public static native long isl_map_gist(long map,long context);
	public static native long isl_map_coalesce(long map);
	public static native int isl_map_fast_is_equal(long map1,long map2);
	public static native long isl_map_lex_lt(long set_dim);
	public static native long isl_map_lex_le(long set_dim);
	public static native long isl_map_lex_gt(long set_dim);
	public static native long isl_map_lex_ge(long set_dim);
	public static native long isl_map_identity(long set_dim);
	public static native long isl_map_lex_lt_first(long dim,long n);
	public static native long isl_map_lex_le_first(long dim,long n);
	public static native long isl_map_lex_gt_first(long dim,long n);
	public static native long isl_map_lex_ge_first(long dim,long n);
	public static native long isl_map_get_basic_map_at(long map,int pos);
	public static native int isl_map_numberof_basic_map(long map);
	public static native String isl_map_get_tuple_name(long map,int type);
	public static native long isl_map_set_tuple_name(long map,int type,String s);
	public static native String isl_map_to_string(long ctx,long map,int format);
	public static native long isl_basic_map_read_from_str(long ctx,String str);
	public static native long isl_basic_map_copy(long bmap);
	public static native long isl_basic_map_extend(long base,long nparam,long n_in,long n_out,long extra,long n_eq,long n_ineq);
	public static native long isl_basic_map_extend_constraints(long base,long n_eq,long n_ineq);
	public static native long isl_basic_map_equal(long dim,long n_equal);
	public static native long isl_basic_map_less_at(long dim,long pos);
	public static native long isl_basic_map_more_at(long dim,long pos);
	public static native long isl_basic_map_empty(long dim);
	public static native long isl_basic_map_empty_like(long model);
	public static native long isl_basic_map_empty_like_map(long model);
	public static native long isl_basic_map_universe(long dim);
	public static native long isl_basic_map_universe_like(long bmap);
	public static native long isl_basic_map_intersect_range(long bmap,long bset);
	public static native long isl_basic_map_intersect(long bmap1,long bmap2);
	public static native long isl_basic_map_union(long bmap1,long bmap2);
	public static native long isl_basic_map_apply_domain(long bmap1,long bmap2);
	public static native long isl_basic_map_apply_range(long bmap1,long bmap2);
	public static native long isl_basic_map_affine_hull(long bmap);
	public static native long isl_basic_map_reverse(long bmap);
	public static native long isl_basic_map_domain(long bmap);
	public static native long isl_basic_map_range(long bmap);
	public static native long isl_basic_map_from_basic_set(long bset,long dim);
	public static native long isl_basic_map_sample(long bmap);
	public static native long isl_basic_map_simplify(long bmap);
	public static native long isl_basic_map_detect_equalities(long bmap);
	public static native long isl_basic_map_lower_bound_si(long bmap,int type,long pos,int value);
	public static native long isl_basic_map_sum(long bmap1,long bmap2);
	public static native long isl_basic_map_neg(long bmap);
	public static native int isl_basic_map_is_equal(long bmap1,long bmap2);
	public static native long isl_basic_map_partial_lexmax(long bmap,long dom,long empty);
	public static native long isl_basic_map_partial_lexmin(long bmap,long dom,long empty);
	public static native long isl_basic_map_lexmin(long bmap);
	public static native long isl_basic_map_lexmax(long bmap);
	public static native long isl_basic_map_deltas(long bmap);
	public static native long isl_basic_map_project_out(long bmap,int type,long first,long n);
	public static native long isl_basic_map_compute_divs(long bmap);
	public static native long isl_basic_map_gist(long bmap,long context);
	public static native int isl_basic_map_is_universe(long bmap);
	public static native int isl_basic_map_fast_is_empty(long bmap);
	public static native int isl_basic_map_is_empty(long bmap);
	public static native int isl_basic_map_is_subset(long bmap1,long bmap2);
	public static native int isl_basic_map_is_strict_subset(long bmap1,long bmap2);
	public static native long isl_map_empty_like_basic_map(long model);
	public static native long isl_map_identity_like_basic_map(long model);
	public static native int isl_basic_map_numberof_constraint(long bmap);
	public static native long isl_basic_map_equalities_matrix(long bmap,int c1,int c2,int c3,int c4,int c5);
	public static native long isl_basic_map_inequalities_matrix(long bmap,int c1,int c2,int c3,int c4,int c5);
	public static native long isl_basic_map_get_space(long bmap);
	public static native long isl_basic_map_set_tuple_name(long bmap,int type,String s);
	public static native String isl_basic_map_get_tuple_name(long bmap,int type);
	public static native long isl_basic_map_set_dim_name(long bmap,int type,long pos,String s);
	public static native String isl_basic_map_to_string(long ctx,long bmap,int format);
	public static native long isl_basic_map_move_dims(long bmap,int dst_type,long dst_pos,int src_type,long src_pos,long n);
	public static native int isl_basic_map_numberof_lexopt(long bmap,int maximize);
	public static native long isl_basic_map_get_lexopt_at(long bmap,int maximize,int pos);
	public static native long isl_basic_map_add_constraint(long bmap,long constraint);
	public static native long isl_printer_print_basic_set(long printer,long bset);
	public static native long isl_printer_print_set(long printer,long set);
	public static native long isl_printer_print_basic_map(long printer,long bmap);
	public static native long isl_printer_print_map(long printer,long map);
	public static native long isl_printer_print_aff(long p,long aff);
	public static native long isl_printer_print_constraint(long p,long c);
	public static native long isl_printer_print_space(long p,long ls);
	public static native long isl_printer_print_local_space(long p,long ls);
	public static native long isl_printer_set_output_format(long p,int output_format);
	public static native long isl_set_lifting(long set);
	public static native long isl_set_get_space(long set);
	public static native long isl_set_n_dim(long set);
	public static native long isl_set_n_param(long set);
	public static native long isl_set_read_from_str(long ctx,String str);
	public static native long isl_set_fix_si(long set,int type,long pos,int value);
	public static native long isl_set_lower_bound_si(long set,int type,long pos,int value);
	public static native long isl_set_from_underlying_set(long set,long like);
	public static native long isl_set_to_underlying_set(long set);
	public static native long isl_set_from_map(long map);
	public static native long isl_set_partial_lexmin(long set,long dom,long empty);
	public static native long isl_set_partial_lexmax(long set,long dom,long empty);
	public static native long isl_set_lexmin(long set);
	public static native long isl_set_lexmax(long set);
	public static native int isl_set_follows_at(long set1,long set2,int pos);
	public static native long isl_set_alloc(long ctx,long nparam,long dim,int n,long flags);
	public static native long isl_set_extend(long base,long nparam,long dim);
	public static native long isl_set_empty(long dim);
	public static native long isl_set_empty_like(long set);
	public static native long isl_set_universe(long dim);
	public static native long isl_set_universe_like(long model);
	public static native long isl_set_add_basic_set(long set,long bset);
	public static native long isl_set_finalize(long set);
	public static native long isl_set_copy(long set);
	public static native void isl_set_free(long set);
	public static native long isl_set_dup(long set);
	public static native long isl_set_sample(long set);
	public static native long isl_set_sample_point(long set);
	public static native long isl_set_detect_equalities(long set);
	public static native long isl_set_affine_hull(long set);
	public static native long isl_set_convex_hull(long set);
	public static native long isl_set_simple_hull(long set);
	public static native long isl_set_polyhedral_hull(long set);
	public static native long isl_set_bounded_simple_hull(long set);
	public static native long isl_set_union_disjoint(long set1,long set2);
	public static native long isl_set_union(long set1,long set2);
	public static native long isl_set_product(long set1,long set2);
	public static native long isl_set_intersect(long set1,long set2);
	public static native long isl_set_subtract(long set1,long set2);
	public static native long isl_set_complement(long set);
	public static native long isl_set_apply(long set,long map);
	public static native long isl_set_fix_dim_si(long set,long dim,int value);
	public static native long isl_set_move_dims(long set,int dst_type,long dst_pos,int src_type,long src_pos,long n);
	public static native long isl_set_project_out(long set,int type,long first,long n);
	public static native long isl_set_insert_dims(long set,int type,long pos,long n);
	public static native long isl_set_eliminate_dims(long set,long first,long n);
	public static native long isl_set_remove_divs(long set);
	public static native int isl_set_fast_is_empty(long set);
	public static native int isl_set_fast_is_universe(long set);
	public static native int isl_set_is_empty(long set);
	public static native int isl_set_is_subset(long set1,long set2);
	public static native int isl_set_is_strict_subset(long set1,long set2);
	public static native int isl_set_is_equal(long set1,long set2);
	public static native long isl_set_make_disjoint(long set);
	public static native long isl_set_align_divs(long set);
	public static native long isl_set_gist(long set,long context);
	public static native long isl_set_coalesce(long set);
	public static native int isl_set_fast_is_equal(long set1,long set2);
	public static native int isl_set_fast_is_disjoint(long set1,long set2);
	public static native long isl_set_get_hash(long set);
	public static native int isl_set_dim_is_unique(long set,long dim);
	public static native long isl_set_from_point(long pnt);
	public static native long isl_set_box_from_points(long pnt1,long pnt2);
	public static native long isl_set_lift(long set);
	public static native int isl_set_size(long set);
	public static native long isl_set_compute_divs(long set);
	public static native long isl_set_get_basic_set_at(long map,int pos);
	public static native int isl_set_numberof_basic_set(long set);
	public static native long isl_set_set_tuple_name(long set,String s);
	public static native String isl_set_get_tuple_name(long set);
	public static native long isl_set_from_basic_set(long bset);
	public static native int isl_set_numberof_points(long set);
	public static native long isl_set_get_point_at(long set,int pos);
	public static native String isl_set_to_string(long ctx,long set,int format);
	public static native long lex_next(long dom,int nbInnerLoop);
	public static native long lex_next_power(long dom,int nbInnerLoop,int power);
	public static native long isl_basic_set_read_from_str(long ctx,String str);
	public static native long isl_basic_set_get_space(long bset);
	public static native long isl_basic_set_gist(long bset,long context);
	public static native long isl_basic_set_copy(long bset);
	public static native long isl_basic_set_lexmin(long bset);
	public static native long isl_basic_set_lexmax(long bset);
	public static native long isl_basic_set_project_out(long bset,int type,long first,long n);
	public static native long isl_basic_set_intersect(long bset1,long bset2);
	public static native int isl_basic_set_is_empty(long bset);
	public static native int isl_basic_set_is_universe(long bset);
	public static native int isl_basic_set_numberof_constraint(long bset);
	public static native String isl_basic_set_to_string(long ctx,long bset,int format);
	public static native long isl_basic_set_get_constraint_at(long bset,int pos);
	public static native long isl_basic_set_equalities_matrix(long bset,int c1,int c2,int c3,int c4);
	public static native long isl_basic_set_inequalities_matrix(long bset,int c1,int c2,int c3,int c4);
	public static native long isl_basic_set_set_dim_name(long bset,int type,long pos,String s);
	public static native long isl_basic_set_apply(long bset,long bmap);
	public static native long isl_basic_set_union(long bset1,long bset2);
	public static native long isl_basic_set_universe(long dim);
	public static native long isl_basic_set_add_constraint(long bset,long constraint);
	public static native long isl_mat_alloc(long ctx,long n_row,long n_col);
	public static native long isl_mat_dup(long mat);
	public static native long isl_mat_extend(long mat,long n_row,long n_col);
	public static native long isl_mat_identity(long ctx,long n_row);
	public static native long isl_mat_copy(long mat);
	public static native long isl_mat_cow(long mat);
	public static native void isl_mat_free(long mat);
	public static native long isl_mat_swap_cols(long mat,long i,long j);
	public static native long isl_mat_swap_rows(long mat,long i,long j);
	public static native long isl_mat_vec_product(long mat,long vec);
	public static native long isl_vec_mat_product(long vec,long mat);
	public static native long isl_mat_vec_inverse_product(long mat,long vec);
	public static native long isl_mat_aff_direct_sum(long left,long right);
	public static native long isl_mat_left_hermite(long m_matrix,int neg,long u_matrix,long q_matrix);
	public static native long isl_mat_lin_to_aff(long mat);
	public static native long isl_mat_inverse_product(long left,long right);
	public static native long isl_mat_product(long left,long right);
	public static native long isl_mat_transpose(long mat);
	public static native long isl_mat_right_inverse(long mat);
	public static native long isl_mat_right_kernel(long mat);
	public static native long isl_mat_drop_cols(long mat,long col,long n);
	public static native long isl_mat_drop_rows(long mat,long row,long n);
	public static native long isl_mat_insert_cols(long mat,long col,long n);
	public static native void isl_mat_col_mul_misc(long mat,int dst_col,long f,int src_col);
	public static native void isl_mat_col_submul_misc(long mat,int dst_col,long f,int src_col);
	public static native long isl_mat_unimodular_complete(long M,int row);
	public static native long isl_mat_concat(long top,long bot);
	public static native long isl_mat_vec_concat(long top,long bot);
	public static native int isl_mat_is_equal(long mat1,long mat2);
	public static native void isl_mat_set_at(long term,int i,int j,int value);
	public static native int isl_mat_get_at(long term,int i,int j);
	public static native int isl_mat_rows(long mat);
	public static native int isl_mat_cols(long mat);
	public static native long isl_mat_from_row_vec(long vec);
	public static native long isl_ctx_options(long ctx);
	public static native long isl_ctx_alloc();
	public static native void isl_ctx_ref(long ctx);
	public static native void isl_ctx_deref(long ctx);
	public static native void isl_ctx_free(long ctx);
	public static native long isl_dim_alloc(long ctx,long nparam,long n_in,long n_out);
	public static native long isl_dim_set_alloc(long ctx,long nparam,long dim);
	public static native long isl_dim_copy(long dim);
	public static native void isl_dim_free(long dim);
	public static native long isl_dim_set_name(long dim,int type,long pos,String name);
	public static native String isl_dim_get_name(long dim,int type,long pos);
	public static native long isl_dim_size(long dim,int type);
	public static native long isl_dim_map_from_set(long dim);
	public static native long isl_dim_add(long dim,int type,long n);
	public static native long isl_dim_join(long left,long right);
	public static native long isl_dim_reverse(long dim);
	public static native long isl_dim_drop(long dim,int type,long first,long num);
	public static native long isl_dim_domain(long dim);
	public static native long isl_dim_range(long dim);
	public static native long isl_dim_set_tuple_name(long dim,int type,String s);
	public static native String isl_dim_get_tuple_name(long dim,int type);
	public static native long isl_space_alloc(long ctx,long nparam,long n_in,long n_out);
	public static native long isl_space_set_alloc(long ctx,long nparam,long dim);
	public static native long isl_space_copy(long dim);
	public static native void isl_space_free(long dim);
	public static native long isl_space_set_dim_name(long dim,int type,long pos,String name);
	public static native String isl_space_get_dim_name(long dim,int type,long pos);
	public static native long isl_space_set_tuple_name(long dim,int type,String s);
	public static native String isl_space_get_tuple_name(long dim,int type);
	public static native long isl_space_dim(long dim,int type);
	public static native long isl_space_drop_dims(long dim,int type,long first,long num);
	public static native long isl_space_drop_inputs(long dim,long first,long num);
	public static native long isl_space_drop_outputs(long dim,long first,long num);
	public static native long isl_space_extend(long dim,long nparam,long n_in,long n_out);
	public static native int isl_space_compatible(long dim1,long dim2);
	public static native int isl_space_is_equal(long dim1,long dim2);
	public static native int isl_space_match(long dim1,int dim1_type,long dim2,int dim2_type);
	public static native long isl_space_product(long left,long right);
	public static native long isl_local_space_alloc(long ctx,long nparam,long n_in,long n_out);
	public static native long isl_local_space_copy(long ls);
	public static native void isl_local_space_free(long ls);
	public static native long isl_local_space_from_space(long dim);
	public static native long isl_local_space_get_space(long ls);
	public static native long isl_local_space_get_div(long ls,int pos);
	public static native long isl_local_space_set_dim_name(long ls,int type,long pos,String name);
	public static native String isl_local_space_get_dim_name(long ls,int type,long pos);
	public static native long isl_local_space_dim(long ls,int type);
	public static native long isl_local_space_add_dims(long ls,int type,long num);
	public static native long isl_local_space_drop_dims(long ls,int type,long first,long num);
	public static native long isl_local_space_insert_dims(long ls,int type,long first,long num);
	public static native int isl_local_space_is_equal(long ls1,long ls2);
	public static native long isl_qpolynomial_copy(long qp);
	public static native long isl_qpolynomial_zero_on_domain(long dim);
	public static native long isl_qpolynomial_one_on_domain(long dim);
	public static native long isl_qpolynomial_infty_on_domain(long dim);
	public static native long isl_qpolynomial_neginfty_on_domain(long dim);
	public static native long isl_qpolynomial_nan_on_domain(long dim);
	public static native long isl_qpolynomial_rat_cst_on_domain(long dim,long n,long d);
	public static native long isl_qpolynomial_var_on_domain(long dim,int type,long pos);
	public static native long isl_qpolynomial_from_aff(long aff);
	public static native long isl_qpolynomial_scale_misc(long qp,int v);
	public static native long isl_qpolynomial_neg(long qp);
	public static native long isl_qpolynomial_add(long qp1,long qp2);
	public static native long isl_qpolynomial_sub(long qp1,long qp2);
	public static native long isl_qpolynomial_mul(long qp1,long qp2);
	public static native long isl_qpolynomial_pow(long qp,long exponent);
	public static native long isl_qpolynomial_drop_dims(long qp,int type,long first,long n);
	public static native long isl_qpolynomial_get_space(long qp);
	public static native int isl_qpolynomial_is_cst(long qp,long n,long d);
	public static native String isl_qpolynomial_to_string(long ctx,long qp,int format);
	public static native long isl_qpolynomial_gist(long qp,long context);
	public static native long isl_pw_qpolynomial_read_from_str(long ctx,String str);
	public static native long isl_pw_qpolynomial_zero(long dim);
	public static native long isl_pw_qpolynomial_alloc(long set,long qp);
	public static native long isl_pw_qpolynomial_copy(long pwqp);
	public static native long isl_pw_qpolynomial_add(long pwqp1,long pwqp2);
	public static native long isl_pw_qpolynomial_sub(long pwqp1,long pwqp2);
	public static native long isl_pw_qpolynomial_add_disjoint(long pwqp1,long pwqp2);
	public static native long isl_pw_qpolynomial_neg(long pwqp);
	public static native long isl_pw_qpolynomial_mul(long pwqp1,long pwqp2);
	public static native long isl_pw_qpolynomial_domain(long pwqp);
	public static native long isl_pw_qpolynomial_get_space(long pwqp);
	public static native long isl_pw_qpolynomial_min(long pwqp);
	public static native long isl_pw_qpolynomial_max(long pwqp);
	public static native long isl_pw_qpolynomial_gist(long pwqp,long context);
	public static native long isl_pw_qpolynomial_bound_misc(long pwqp,int type,long tight);
	public static native String isl_pw_qpolynomial_to_string(long ctx,long pwqp,int format);
	public static native long isl_union_pw_qpolynomial_copy(long upwqp);
	public static native long isl_union_pw_qpolynomial_add(long upwqp1,long upwqp2);
	public static native long isl_union_pw_qpolynomial_sub(long upwqp1,long upwqp2);
	public static native long isl_union_pw_qpolynomial_mul(long upwqp1,long upwqp2);
	public static native long isl_union_pw_qpolynomial_bound_misc(long upwqp,int type,long tight);
	public static native long isl_union_pw_qpolynomial_gist(long upwqp,long context);
	public static native long isl_union_pw_qpolynomial_coalesce(long upwqp);
	public static native String isl_union_pw_qpolynomial_to_string(long ctx,long upwqp,int format);
	public static native long isl_qpolynomial_fold_alloc(int type,long qp);
	public static native long isl_pw_qpolynomial_fold_alloc(int type,long set,long fold);
	public static native long isl_pw_qpolynomial_fold_max(long pwf);
	public static native long isl_pw_qpolynomial_fold_min(long pwf);
	public static native long isl_pw_qpolynomial_fold_coalesce(long pwf);
	public static native String isl_qpolynomial_fold_to_string(long ctx,long qpf,int format);
	public static native String isl_pw_qpolynomial_fold_to_string(long ctx,long pwqpf,int format);
	public static native String isl_union_pw_qpolynomial_fold_to_string(long ctx,long upwqpf,int format);
	public static native int isl_constraint_is_equality(long constraint);
	public static native void isl_constraint_get_constant(long constraint,long v);
	public static native void isl_constraint_get_coefficient(long constraint,int type,int pos,long v);
	public static native long isl_constraint_get_div(long constraint,int pos);
	public static native String isl_constraint_get_dim_name(long constraint,int type,int pos);
	public static native long isl_equality_alloc(long ls);
	public static native long isl_inequality_alloc(long ls);
	public static native void isl_constraint_set_coefficient_misc(long constraint,int type,int pos,int value);
	public static native void isl_constraint_set_constant_misc(long constraint,int value);
	public static native long isl_constraint_get_space(long constraint);
	public static native int isl_constraint_dim(long constraint,int type);
	public static native String isl_constraint_to_string(long ctx,long constraint,int format);
	public static native long init_isl_int();
	public static native long init_set_isl_int(int v);
	public static native void free_isl_int(long i);
	public static native String isl_int_to_string(long v);
	public static native int isl_int_to_int(long v);
	public static native void set_isl_int(long i,int v);
	public static native long alloc_dataflow_analysis();
	public static native void free_dataflow_analysis(long result);
	public static native long isl_array_dataflow_analysis(long sink,long must_source,long may_source,long schedule);
	public static native long compute_ADA(long domains,long writes,long reads,long idSchedule,int memoryBased);
	public static native long compute_ADA_custom(long domains,long writes,long reads,long idSchedule,int RAW,int WAW,int WAR);
	public static native long compute_pluto_schedule(long domains,long prdg);
	public static native long isl_union_map_from_map(long map);
	public static native long isl_union_map_empty(long dim);
	public static native long isl_union_map_copy(long umap);
	public static native void isl_union_map_free(long umap);
	public static native long isl_union_map_get_ctx(long umap);
	public static native long isl_union_map_get_space(long umap);
	public static native long isl_union_map_domain(long umap);
	public static native long isl_union_map_range(long umap);
	public static native long isl_union_map_domain_map(long umap);
	public static native long isl_union_map_range_map(long umap);
	public static native long isl_union_map_affine_hull(long umap);
	public static native long isl_union_map_polyhedral_hull(long umap);
	public static native long isl_union_map_coalesce(long umap);
	public static native long isl_union_map_compute_divs(long umap);
	public static native long isl_union_map_lexmin(long umap);
	public static native long isl_union_map_lexmax(long umap);
	public static native long isl_union_map_add_map(long umap,long map);
	public static native long isl_union_map_union(long umap1,long umap2);
	public static native long isl_union_map_subtract(long umap1,long umap2);
	public static native long isl_union_map_intersect(long umap1,long umap2);
	public static native long isl_union_map_product(long umap1,long umap2);
	public static native long isl_union_map_gist(long umap,long context);
	public static native long isl_union_map_intersect_domain(long umap,long uset);
	public static native long isl_union_map_intersect_range(long umap,long uset);
	public static native long isl_union_map_apply_domain(long umap1,long umap2);
	public static native long isl_union_map_apply_range(long umap1,long umap2);
	public static native long isl_union_map_reverse(long umap);
	public static native long isl_union_map_from_domain_and_range(long domain,long range);
	public static native long isl_union_map_deltas(long umap);
	public static native int isl_union_map_is_empty(long umap);
	public static native int isl_union_map_is_subset(long umap1,long umap2);
	public static native int isl_union_map_is_equal(long umap1,long umap2);
	public static native int isl_union_map_is_strict_subset(long umap1,long umap2);
	public static native long isl_union_map_extract_map(long umap,long dim);
	public static native long isl_union_map_sample(long umap);
	public static native long isl_union_map_transitive_closure_jnimap(long umap);
	public static native long isl_union_map_lex_lt_union_map(long umap1,long umap2);
	public static native long isl_union_map_lex_le_union_map(long umap1,long umap2);
	public static native long isl_union_map_lex_gt_union_map(long umap1,long umap2);
	public static native long isl_union_map_lex_ge_union_map(long umap1,long umap2);
	public static native long isl_union_map_read_from_str(long ctx,String str);
	public static native long isl_printer_print_union_map(long p,long umap);
	public static native String isl_union_map_to_string(long ctx,long map,int format);
	public static native long isl_union_map_align_params(long umap,long model);
	public static native long isl_basic_map_get_constraint_at(long bmap,int pos);
	public static native long isl_union_map_get_map_at(long umap,int pos);
	public static native int isl_union_map_numberof_map(long umap);
	public static native long isl_union_set_align_params(long uset,long model);
	public static native String isl_union_set_to_string(long ctx,long map,int format);
	public static native long isl_union_set_from_set(long set);
	public static native long isl_union_set_empty(long dim);
	public static native long isl_union_set_copy(long uset);
	public static native void isl_union_set_free(long uset);
	public static native long isl_union_set_get_set_at(long uset,int pos);
	public static native int isl_union_set_numberof_set(long uset);
	public static native long isl_union_set_get_ctx(long uset);
	public static native long isl_union_set_get_space(long uset);
	public static native long isl_union_set_affine_hull(long uset);
	public static native long isl_union_set_polyhedral_hull(long uset);
	public static native long isl_union_set_coalesce(long uset);
	public static native long isl_union_set_compute_divs(long uset);
	public static native long isl_union_set_lexmin(long uset);
	public static native long isl_union_set_lexmax(long uset);
	public static native long isl_union_set_identity(long uset);
	public static native long isl_union_set_add_set(long uset,long set);
	public static native long isl_union_set_union(long uset1,long uset2);
	public static native long isl_union_set_subtract(long uset1,long uset2);
	public static native long isl_union_set_intersect(long uset1,long uset2);
	public static native long isl_union_set_product(long uset1,long uset2);
	public static native long isl_union_set_gist(long uset,long context);
	public static native long isl_union_set_apply(long uset,long umap);
	public static native int isl_union_set_is_empty(long uset);
	public static native int isl_union_set_is_subset(long uset1,long uset2);
	public static native int isl_union_set_is_equal(long uset1,long uset2);
	public static native int isl_union_set_is_strict_subset(long uset1,long uset2);
	public static native int isl_union_set_n_set(long uset);
	public static native long isl_union_set_extract_set(long uset,long dim);
	public static native long isl_union_set_sample(long uset);
	public static native long isl_union_set_lex_lt_union_set(long uset1,long uset2);
	public static native long isl_union_set_lex_le_union_set(long uset1,long uset2);
	public static native long isl_union_set_lex_gt_union_set(long uset1,long uset2);
	public static native long isl_union_set_lex_ge_union_set(long uset1,long uset2);
	public static native long isl_union_set_read_from_str(long ctx,String str);
	public static native long isl_printer_print_union_set(long p,long uset);
	public static native long isl_point_get_space(long point);
	public static native void isl_point_get_coordinate(long pnt,int type,int pos,long v);
	public static native String isl_aff_to_string(long ctx,long aff,int format);
	public static native long isl_aff_copy(long aff);
	public static native void isl_aff_free(long aff);
	public static native long isl_aff_get_space(long aff);
	public static native int isl_aff_dim(long aff,int type);
	public static native int isl_aff_get_constant(long aff,long v);
	public static native int isl_aff_get_coefficient(long aff,int type,int pos,long v);
	public static native long isl_aff_get_div(long aff,int pos);
	public static native int isl_aff_get_denominator(long aff,long v);
	public static native long isl_aff_set_constant_si(long aff,int v);
	public static native long isl_aff_set_coefficient_si(long aff,int type,int pos,int v);
	public static native int isl_aff_list_numberof_aff(long afflist);
	public static native long isl_aff_list_get_aff_at(long afflist,int pos);
	public static native long isl_union_map_wrap(long umap);
	public static native long isl_basic_map_wrap(long bmap);
	public static native long isl_map_wrap(long map);
	public static native long isl_basic_set_unwrap(long bset);
	public static native long isl_union_set_unwrap(long uset);
	public static native long isl_set_unwrap(long set);
	public static native long isl_basic_map_flatten(long bmap);
	public static native long isl_basic_set_flatten(long bset);
	public static native long isl_map_flatten_range(long map);
	public static native long isl_map_flatten(long map);
	public static native long isl_set_flatten(long set);
	public static native long isl_set_flatten_map(long set);
	



	

	

	

	

	

	

	

	

	

	

	

	

	

	

	

	

	

	

	

	

	

	

	
	
		// getter for ISLDataflowAnalysis.must_dep
		public static native long isl_dataflow_analysis_get_must_dep(long ptr);
		// setter for ISLDataflowAnalysis.must_dep
		public static native void isl_dataflow_analysis_set_must_dep(long ptr, long value);
	
	
	
		// getter for ISLDataflowAnalysis.may_dep
		public static native long isl_dataflow_analysis_get_may_dep(long ptr);
		// setter for ISLDataflowAnalysis.may_dep
		public static native void isl_dataflow_analysis_set_may_dep(long ptr, long value);
	
	
	
		// getter for ISLDataflowAnalysis.must_no_source
		public static native long isl_dataflow_analysis_get_must_no_source(long ptr);
		// setter for ISLDataflowAnalysis.must_no_source
		public static native void isl_dataflow_analysis_set_must_no_source(long ptr, long value);
	
	
	
		// getter for ISLDataflowAnalysis.may_no_source
		public static native long isl_dataflow_analysis_get_may_no_source(long ptr);
		// setter for ISLDataflowAnalysis.may_no_source
		public static native void isl_dataflow_analysis_set_may_no_source(long ptr, long value);
	
	

	
	
		// getter for ISLTransitiveClosureResult.exact
		public static native int isl_transitive_closure_result_get_exact(long ptr);
		// setter for ISLTransitiveClosureResult.exact
		public static native void isl_transitive_closure_result_set_exact(long ptr, int value);
	
	
	
		// getter for ISLTransitiveClosureResult.map
		public static native long isl_transitive_closure_result_get_map(long ptr);
		// setter for ISLTransitiveClosureResult.map
		public static native void isl_transitive_closure_result_set_map(long ptr, long value);
	
	
	
		// getter for ISLTransitiveClosureResult.bmap
		public static native long isl_transitive_closure_result_get_bmap(long ptr);
		// setter for ISLTransitiveClosureResult.bmap
		public static native void isl_transitive_closure_result_set_bmap(long ptr, long value);
	
	
	
		// getter for ISLTransitiveClosureResult.umap
		public static native long isl_transitive_closure_result_get_umap(long ptr);
		// setter for ISLTransitiveClosureResult.umap
		public static native void isl_transitive_closure_result_set_umap(long ptr, long value);
	
	

	

	

	

	

	

	
	
		// getter for ISLLexopt.bset
		public static native long isl_lexopt_get_bset(long ptr);
		// setter for ISLLexopt.bset
		public static native void isl_lexopt_set_bset(long ptr, long value);
	
	
	
		// getter for ISLLexopt.list
		public static native long isl_lexopt_get_list(long ptr);
		// setter for ISLLexopt.list
		public static native void isl_lexopt_set_list(long ptr, long value);
	
	

	
	
	
	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
		
		
	
	
	


	
	
	
}
