package fr.irisa.cairn.jnimap.isl.jni;

 

public class ISLPrettyPrinter {

	public static enum ISL_FORMAT {ISL, POLYLIB, POLYLIB_CONSTRAINTS, OMEGA, C, LATEX};

	
	private static JNIISLContext context;

	public static JNIISLContext getContext() {
		return JNIISLContext.getCtx();
	}

	public static JNIISLSet islSet(String setTxt) {
		return new JNIISLSet(getContext(), setTxt);
	}
//	public static JNIISLBasicSet islBasicSet(String setTxt) {
//		return new JNIISLBasicSet(getContext(), setTxt, -1);
//	}

	public static JNIISLMap islMap(String setTxt) {
		return new JNIISLMap(getContext(), setTxt);
	}

	public static String asString(JNIISLSet set) {
		return JNIISLSet._toString(getContext(), set, ISL_FORMAT.ISL.ordinal());
	}

	public static String asString(JNIISLSet set, ISL_FORMAT format) {
		return JNIISLSet._toString(getContext(), set, format.ordinal());
	}
	
	
	public static String asString(JNIISLBasicSet set) {
		return JNIISLBasicSet._toString(getContext(), set, ISL_FORMAT.ISL.ordinal());
	}
	
	public static String asString(JNIISLBasicSet set, ISL_FORMAT format) {
		return JNIISLBasicSet._toString(getContext(), set, format.ordinal());
	}

	public static String asString(JNIISLBasicMap set, ISL_FORMAT format) {
		return JNIISLBasicMap._toString(getContext(), set, format.ordinal());
	}

	public static String asString(JNIISLBasicMap set) {
		return JNIISLBasicMap._toString(getContext(), set, ISL_FORMAT.ISL.ordinal());
	}


	public static String asString(JNIISLMap set) {
		return JNIISLMap._toString(getContext(), set, ISL_FORMAT.ISL.ordinal());
	}

	public static String asString(JNIISLMap set, ISL_FORMAT format) {
		return JNIISLMap._toString(getContext(), set, format.ordinal());
	}

	public static String toString(JNIISLBasicMap set) {
		return JNIISLBasicMap._toString(getContext(), set, ISL_FORMAT.ISL.ordinal());
	}

	public static String toString(JNIISLUnionMap set,ISL_FORMAT format) {
		return JNIISLUnionMap._toString(getContext(), set, format.ordinal());
	}

	public static String toString(JNIISLUnionMap set) {
		return JNIISLUnionMap._toString(getContext(), set, ISL_FORMAT.ISL.ordinal());
	}

	public static String asString(JNIISLPWQPolynomial set) {
		return JNIISLPWQPolynomial._toString(getContext(), set, ISL_FORMAT.ISL.ordinal());
	}

	public static String asString(JNIISLQPolynomial set) {
		return JNIISLQPolynomial._toString(getContext(), set, ISL_FORMAT.ISL.ordinal());
	}

	public static String asString(JNIISLQPolynomialFold set) {
		return JNIISLQPolynomialFold._toString(getContext(), set, ISL_FORMAT.ISL.ordinal());
	}

	public static String asString(JNIISLTerm set) {
		return "";//set.getN()+"/"+set.getD()+"^?";
	}

	public static String asString(JNIISLConstraint cstr) {
		return JNIISLConstraint._toString(getContext(), cstr, ISL_FORMAT.ISL.ordinal());
	}
	  
	
//	public static String asString2(JNIISLConstraint cstr) {
//		return cstr._toString();
//		
//		
////		JNIISLDimType isl_dim_type = JNIISLDimType.isl_dim_param;
////		for(int i=0;i<cstr.getNumberOfCoefficientsFoDimension(isl_dim_type);i++) {
////			
////			long coefficientAt = cstr.getCoefficientAt(isl_dim_type, i);
////			if (coefficientAt!=0)
////				if(coefficientAt==1)
////					buf.append(cstr.getNameAt(isl_dim_type, i)+" + ");
////				else
////					buf.append(coefficientAt+"*"+cstr.getNameAt(isl_dim_type, i)+" + ");
////		}
////		isl_dim_type = JNIISLDimType.isl_dim_set;
////		for(int i=0;i<cstr.getNumberOfCoefficientsFoDimension(isl_dim_type);i++) {
////			long coefficientAt = cstr.getCoefficientAt(isl_dim_type, i);
////			if (coefficientAt!=0)
////				if(coefficientAt==1)
////					buf.append(cstr.getNameAt(isl_dim_type, i)+" + ");
////				else
////					buf.append(coefficientAt+"*"+cstr.getNameAt(isl_dim_type, i)+" + ");
////		}
////		isl_dim_type = JNIISLDimType.isl_dim_div;
////		for(int i=0;i<cstr.getNumberOfCoefficientsFoDimension(isl_dim_type);i++) {
////			long coefficientAt = cstr.getCoefficientAt(isl_dim_type, i);
////			if (coefficientAt!=0)
////				if(coefficientAt==1)
////					buf.append("e_"+i+" + ");
////				else
////					buf.append(coefficientAt+"*e_"+i+" + ");
////
////		}
////		if( cstr.isEquality()>0) {
////			buf.append(cstr.getConstant()+" = 0 ");
////		} else {
////			buf.append(cstr.getConstant()+" >= 0 ");
////		}
////		//cstr.getDiv(pos)
//	//	return  "";//buf.toString();
//	}

	public static String asString(JNIISLUnionMap jniislUnionMap) {
		return JNIISLUnionMap._toString(getContext(), jniislUnionMap, ISL_FORMAT.ISL.ordinal());
	}

	public static String asString(JNIISLUnionSet jniislUnionSet) {
		return JNIISLUnionSet._toString(getContext(), jniislUnionSet, ISL_FORMAT.ISL.ordinal());
	}

	public static String asString(JNIISLAffine aff) {
		return JNIISLAffine._toString(getContext(), aff, ISL_FORMAT.ISL.ordinal());
	}
	
	public static String asString(JNIISLAffineList list) {
		return ""+list.getAffines();
	}

	public static String asString(JNIISLPoint p) {
		return p.getCoordinates().toString();
	}

	public static String asString(JNIISLDataflowAnalysis df) {
		String string = "May dep :" +df.getMay_dep() +"\n";
		string += "May no source :" +df.getMay_no_source() +"\n";
		string += "Must dep :" +df.getMust_dep() +"\n";
		string += "Must no source :" +df.getMust_no_source() +"\n";
		return string;
	}

	public static String asString(JNIISLDim dim) {
		return ""+
			dim.getNames(JNIISLDimType.isl_dim_param)+" -> {"+
			dim.getNames(JNIISLDimType.isl_dim_in)+" -> "+
			dim.getNames(JNIISLDimType.isl_dim_out)+" :"
			;
	}

	public static String asString(JNIISLMatrix m) {

		StringBuffer res = new StringBuffer();
		res.append(m.getNbRows()+"\n"+m.getNbCols()+"\n");
		for(int i=0;i<m.getNbRows();i++) {
			for(int j=0;j<m.getNbCols();j++) {
				int val = m.getAt(i,j);
				res.append(val+" ");
				
			}
			res.append("\n");
		}
		return res.toString();
		
	}
	
	public static String asString(JNIISLPWQPolynomialFold p) {
		return JNIISLPWQPolynomialFold._toString(getContext(), p, ISL_FORMAT.ISL.ordinal());
	}

	public static String asString(Object obj) {
		
		return "default:"+obj.getClass().getSimpleName();
	}

}
