

package fr.irisa.cairn.jnimap.isl.jni;

import java.util.HashMap;
import java.util.Map;
import java.util.ArrayList;
import java.util.List;

/***PROTECTED REGION ID(ISLAffineuserImport) ENABLED START***/
/*
	Put you custom import here ....
*/	
/***PROTECTED REGION END***/


/**
 *  Automatically generated by jnimap 
 * @generated
 */
 
public class JNIISLAffine extends  JNIObject  {

	
	/* @generated */
	protected JNIISLAffine(long ptr) {
	/***PROTECTED REGION ID(ISLAffineConstructor) START***/
		super(ptr);
	/***PROTECTED REGION END***/
	}
	
	 

	/* @generated */
	static Map<Long,JNIISLAffine> ISLAffineliveMap;


	/* @generated */
	public static JNIISLAffine build(long ptr) {
	
		if(ISLAffineliveMap==null) {
			ISLAffineliveMap= new HashMap<Long,JNIISLAffine>();
		} 
		
		if (isNull(ptr)) {
			return null;
		} else if (!ISLAffineliveMap.containsKey((long) ptr)) {
		/***PROTECTED REGION ID(ISLAffineBuilder) START***/
			JNIISLAffine res; 
			res = new JNIISLAffine(ptr);
			ISLAffineliveMap.put(ptr,res);
			return res;
		/***PROTECTED REGION END***/
		} else {
			return ISLAffineliveMap.get((long) ptr);
		}
		
	}
	
	
	
	
	
	
	
	/***PROTECTED REGION ID(ISLAffine-userCode) ENABLED START***/
	public int getCoefficientAt(JNIISLDimType dType, int pos) {
		JNIISLInt tmp = new JNIISLInt();
		this._getCoefficientAt(dType, pos, tmp);
		int res = tmp._toInt();
		tmp.free();
		return res;
	}
	
	public int getConstant() {
		JNIISLInt tmp = new JNIISLInt();
		this._getConstant(tmp);
		int res = tmp._toInt();
		tmp.free();
		return res;
	}
	
	public int getDenominator() {
		JNIISLInt tmp = new JNIISLInt();
		this._getDenominator(tmp);
		int res = tmp._toInt();
		tmp.free();
		return res;
	}
	
	public String javaPrint() {
		String javaPrint = "";
		boolean first = true;
		
		int cst = this.getConstant();
		if (cst != 0) {
			first = false;
			javaPrint += cst;
		}
		
		JNIISLSpace dims = this.getSpace();
		
		JNIISLDimType dimType = JNIISLDimType.isl_dim_in;
		int n = this.getNbDim(dimType);
		for (int i = 0; i < n; i++) {
			int coef = this.getCoefficientAt(dimType, i);
			if (coef != 0) {
				if (!first) {
					if (coef < 0)
						javaPrint += " - ";
					else 
						javaPrint += " + ";
				} else {
					if (coef < 0)
						javaPrint += "-";
				}
				first = false;
				if (Math.abs(coef) != 1)
					javaPrint += Math.abs(coef);
				String name = dims.getName(dimType, i);
				if (name == null) name = "i"+i;
				javaPrint += name;
			}
		}

		dimType = JNIISLDimType.isl_dim_out;
		n = this.getNbDim(dimType);
		for (int i = 0; i < n; i++) {
			int coef = this.getCoefficientAt(dimType, i);
			if (coef != 0) {
				if (!first) {
					if (coef < 0)
						javaPrint += " - ";
					else 
						javaPrint += " + ";
				} else {
					if (coef < 0)
						javaPrint += "-";
				}
				first = false;
				if (Math.abs(coef) != 1)
					javaPrint += Math.abs(coef);
				String name = dims.getName(dimType, i);
				if (name == null) name = "o"+i;
				javaPrint += name;
			}
		}
		
		dimType = JNIISLDimType.isl_dim_param;
		n = this.getNbDim(dimType);
		for (int i = 0; i < n; i++) {
			int coef = this.getCoefficientAt(dimType, i);
			if (coef != 0) {
				if (!first) {
					if (coef < 0)
						javaPrint += " - ";
					else 
						javaPrint += " + ";
				} else {
					if (coef < 0)
						javaPrint += "-";
				}
				first = false;
				if (Math.abs(coef) != 1)
					javaPrint += Math.abs(coef);
				String name = dims.getName(dimType, i);
				if (name == null) name = "p"+i;
				javaPrint += name;
			}
		}
		
		dimType = JNIISLDimType.isl_dim_div;
		n = this.getNbDim(dimType);
		for (int i = 0; i < n; i++) {
			int coef = this.getCoefficientAt(dimType, i);
			if (coef != 0) {
				if (!first) {
					if (coef < 0)
						javaPrint += " - ";
					else 
						javaPrint += " + ";
				} else {
					if (coef < 0)
						javaPrint += "-";
				}
				first = false;
				if (Math.abs(coef) != 1)
					javaPrint += Math.abs(coef)+"*";
				
//				JNIISLDiv div = this.getDivAt(i);
//				javaPrint += div.javaPrint(dims);
			}
		}
		
		if (javaPrint.isEmpty()) javaPrint = "[(0)]";
		else javaPrint = "[("+javaPrint+")]";
		return javaPrint;
	}
	/***PROTECTED REGION END***/

	
	
	/* 
	
		Constructors 
	
	*/ 
		
		
		
		
	
	
	/* 
	
		Finalizer 
	
	*/ 
	
	


	/* 
	
		Standard methods 
	
	*/ 
	
		 /* @generated */
		 public static String _toString(JNIISLContext ctx,JNIISLAffine aff,int format) { 
			/***PROTECTED REGION ID(static_isl_aff_to_string) START***/
			/***PROTECTED REGION END***/return ISLNative.isl_aff_to_string(
ctx.getNativePtr()
,
aff.getNativePtr()
,format			);
		}
	

		/***PROTECTED REGION ID(isl_aff_copy) START***/
			
			/* @generated */
			public JNIISLAffine copy() { return JNIISLAffine.build(ISLNative.isl_aff_copy(this.getNativePtr())					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_aff_free) START***/
			
			/* @generated */
			public void free() { ISLNative.isl_aff_free(this.getNativePtr()					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_aff_get_space) START***/
			
			/* @generated */
			public JNIISLSpace getSpace() { return JNIISLSpace.build(ISLNative.isl_aff_get_space(this.getNativePtr())					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_aff_dim) START***/
			
			/* @generated */
			public int getNbDim(JNIISLDimType type) { return ISLNative.isl_aff_dim(this.getNativePtr(),
type.getValue()
					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_aff_get_constant) START***/
			
			/* @generated */
			public int _getConstant(JNIISLInt v) { return ISLNative.isl_aff_get_constant(this.getNativePtr(),
v.getNativePtr()
					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_aff_get_coefficient) START***/
			
			/* @generated */
			public int _getCoefficientAt(JNIISLDimType type,int pos,JNIISLInt v) { return ISLNative.isl_aff_get_coefficient(this.getNativePtr(),
type.getValue()
,pos,
v.getNativePtr()
					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_aff_get_div) START***/
			
			/* @generated */
			public JNIISLAffine getDivAt(int pos) { return JNIISLAffine.build(ISLNative.isl_aff_get_div(this.getNativePtr(),pos)					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_aff_get_denominator) START***/
			
			/* @generated */
			public int _getDenominator(JNIISLInt v) { return ISLNative.isl_aff_get_denominator(this.getNativePtr(),
v.getNativePtr()
					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_aff_set_constant_si) START***/
			
			/* @generated */
			public JNIISLAffine setConstant(int v) { return JNIISLAffine.build(ISLNative.isl_aff_set_constant_si(this.getNativePtr(),v)					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_aff_set_coefficient_si) START***/
			
			/* @generated */
			public JNIISLAffine setCoefficient(JNIISLDimType type,int pos,int v) { return JNIISLAffine.build(ISLNative.isl_aff_set_coefficient_si(this.getNativePtr(),
type.getValue()
,pos,v)					);
				}
			
		/***PROTECTED REGION END***/
	 
	
		
	public String toString() {
	/***PROTECTED REGION ID(ISLAffinetoString) START***/
			return ISLPrettyPrinter.asString(this);
	/***PROTECTED REGION END***/
	}
}

