

package fr.irisa.cairn.jnimap.isl.jni;

import java.util.HashMap;
import java.util.Map;
import java.util.ArrayList;
import java.util.List;

/***PROTECTED REGION ID(ISLSetuserImport) ENABLED START***/
/*
	Put you custom import here ....
*/	
import fr.irisa.cairn.jnimap.isl.jni.ISLPrettyPrinter.ISL_FORMAT;
import fr.irisa.cairn.jnimap.isl.jni.extra.JNIISLTools;
/***PROTECTED REGION END***/


/**
 *  Automatically generated by jnimap 
 * @generated
 */
 
public class JNIISLSet extends  JNIObject  {

	
	/* @generated */
	protected JNIISLSet(long ptr) {
	/***PROTECTED REGION ID(ISLSetConstructor) START***/
		super(ptr);
	/***PROTECTED REGION END***/
	}
	
	 

	/* @generated */
	static Map<Long,JNIISLSet> ISLSetliveMap;


	/* @generated */
	public static JNIISLSet build(long ptr) {
	
		if(ISLSetliveMap==null) {
			ISLSetliveMap= new HashMap<Long,JNIISLSet>();
		} 
		
		if (isNull(ptr)) {
			return null;
		} else if (!ISLSetliveMap.containsKey((long) ptr)) {
		/***PROTECTED REGION ID(ISLSetBuilder) START***/
			JNIISLSet res; 
			res = new JNIISLSet(ptr);
			ISLSetliveMap.put(ptr,res);
			return res;
		/***PROTECTED REGION END***/
		} else {
			return ISLSetliveMap.get((long) ptr);
		}
		
	}
	
	
	
	
	
	
	
	/***PROTECTED REGION ID(ISLSet-userCode) ENABLED START***/
	
	public JNIISLSet expandTo(JNIISLSet mergedDomains) {
		return JNIISLTools.expandTo(this,mergedDomains);
	}

	public List<JNIISLBasicSet> getBasicSets() {
		List<JNIISLBasicSet> res = new ArrayList<JNIISLBasicSet>();
		for(int i=0; i<getNumberOfBasicSet();i++) {
			res.add(this.getBasicSetAt(i));
		}
		return res;
	}
	

	public String toString(ISL_FORMAT format) {
		return ISLPrettyPrinter.asString(this, format);
	}
	
	public static String asList(List objs, String sep) {
		String res = "";
		boolean first = true;
		for (Object obj : objs) {
			if (!first) {
				res += sep;
			}
			res += obj.toString();
			first = false;
		}
		return res;

	}

	public JNIISLSet convertTo(JNIISLDim target) {
		JNIISLSpace space = this.getSpace();
		if(target.getSize(JNIISLDimType.isl_dim_param)!=space.getSize(JNIISLDimType.isl_dim_param)) {
			throw new UnsupportedOperationException("Parameter mismatch : cannnot convert "+space+" to "+target);
		} else {
			String mapStr = "" + this.getParametersNames()+ "-> { "+getIndicesNames()+" ->  "+target.getNameList(JNIISLDimType.isl_dim_set)+"  :";
			List<String> nameList = space.getNameList(JNIISLDimType.isl_dim_set);
			List<String> assgnList = new ArrayList<String>();
			List<String> targetNames = target.getNameList(JNIISLDimType.isl_dim_set);
			int insize = nameList.size();
			for(int i=0;i<insize;i++) {
				assgnList.add(targetNames.get(i)+"="+nameList.get(i)); 
			}
			mapStr+=asList(assgnList, " & ")+" }";
			JNIISLMap islMap = ISLFactory.islMap(mapStr);
			return this.copy().apply(islMap);
		}
	}

	public List<String> getParametersNames() {
		int nbParams = (int) getSpace().getSize(JNIISLDimType.isl_dim_param);//for(StringBuffer dim : map.get)
		List<String> params=new ArrayList<String>();
		for(int i=0; i<nbParams;i++) {
			String name = getSpace().getName(JNIISLDimType.isl_dim_param, i);
			params.add(name);
		}
		return params;
	}

	public List<String> getIndicesNames() {
		int nbIndices = (int) getSpace().getSize(JNIISLDimType.isl_dim_set);//for(StringBuffer dim : map.get)
		List<String> indices=new ArrayList<String>();
		for(int i=0; i<nbIndices;i++) {
			String name = getSpace().getName(JNIISLDimType.isl_dim_set, i);
			if(name==null) {
				name="i"+i;
			}
			indices.add(name);
		}
		return indices;
	}
	
	public List<JNIISLPoint> getPoints() {
		int n = this.getNbPoints();
		List<JNIISLPoint> res = new ArrayList<JNIISLPoint>(n);
		for (int i = 0; i < n; i++) {
			res.add(this.getPointAt(i));
		}
		return res;
	}

	public JNIISLMap lexFirstMap(int nbLoops) {
		int n = (int)this.getNDim() - nbLoops;
		JNIISLMap m = JNIISLMap.fromDomainAndRange(JNIISLSet.buildUniverseLike(this.copy()),this.copy());
		JNIISLBasicMap bm = JNIISLBasicMap.universe(m.getSpace());
		for (int i = 0; i < n; i++) {
			JNIISLConstraint c = JNIISLConstraint.equality(JNIISLLocalSpace.fromSpace(m.getSpace()));
			c.setCoef(JNIISLDimType.isl_dim_in, i, 1);
			c.setCoef(JNIISLDimType.isl_dim_out, i, -1);
			bm = bm.addConstraint(c);
		}
		JNIISLMap ma = JNIISLMap.fromBasicMap(bm);
		m = JNIISLMap.intersect(m, ma).lexMin();
		//m = m.projectOut(JNIISLDimType.isl_dim_out, 0, n);
		return m;
	}
	
	/***PROTECTED REGION END***/

	
	
	/* 
	
		Constructors 
	
	*/ 
		 
			/* @generated */
				
			public JNIISLSet(JNIISLContext ctx,String str) { 
				this(ISLNative.isl_set_read_from_str(
ctx.getNativePtr()
,str)				);
				}
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
	
	
	/* 
	
		Finalizer 
	
	*/ 
	
	


	/* 
	
		Standard methods 
	
	*/ 
	
		 /* @generated */
		 public static JNIISLSet fromMap(JNIISLMap map) { 
			/***PROTECTED REGION ID(static_isl_set_from_map) START***/
			/***PROTECTED REGION END***/return JNIISLSet.build(ISLNative.isl_set_from_map(
map.getNativePtr()
)			);
		}
		 /* @generated */
		 public static JNIISLSet islSetAlloc(JNIISLContext ctx,long nparam,long dim,int n,long flags) { 
			/***PROTECTED REGION ID(static_isl_set_alloc) START***/
			/***PROTECTED REGION END***/return JNIISLSet.build(ISLNative.isl_set_alloc(
ctx.getNativePtr()
,nparam,dim,n,flags)			);
		}
		 /* @generated */
		 public static JNIISLSet buildEmpty(JNIISLSpace dim) { 
			/***PROTECTED REGION ID(static_isl_set_empty) START***/
			/***PROTECTED REGION END***/return JNIISLSet.build(ISLNative.isl_set_empty(
dim.getNativePtr()
)			);
		}
		 /* @generated */
		 public static JNIISLSet buildEmptyLike(JNIISLSet set) { 
			/***PROTECTED REGION ID(static_isl_set_empty_like) START***/
			/***PROTECTED REGION END***/return JNIISLSet.build(ISLNative.isl_set_empty_like(
set.getNativePtr()
)			);
		}
		 /* @generated */
		 public static JNIISLSet buildUniverse(JNIISLSpace dim) { 
			/***PROTECTED REGION ID(static_isl_set_universe) START***/
			/***PROTECTED REGION END***/return JNIISLSet.build(ISLNative.isl_set_universe(
dim.getNativePtr()
)			);
		}
		 /* @generated */
		 public static JNIISLSet buildUniverseLike(JNIISLSet model) { 
			/***PROTECTED REGION ID(static_isl_set_universe_like) START***/
			/***PROTECTED REGION END***/return JNIISLSet.build(ISLNative.isl_set_universe_like(
model.getNativePtr()
)			);
		}
		 /* @generated */
		 public static JNIISLSet disjoint(JNIISLSet set1,JNIISLSet set2) { 
			/***PROTECTED REGION ID(static_isl_set_union_disjoint) START***/
			/***PROTECTED REGION END***/return JNIISLSet.build(ISLNative.isl_set_union_disjoint(
set1.getNativePtr()
,
set2.getNativePtr()
)			);
		}
		 /* @generated */
		 public static JNIISLSet union(JNIISLSet set1,JNIISLSet set2) { 
			/***PROTECTED REGION ID(static_isl_set_union) START***/
			/***PROTECTED REGION END***/return JNIISLSet.build(ISLNative.isl_set_union(
set1.getNativePtr()
,
set2.getNativePtr()
)			);
		}
		 /* @generated */
		 public static JNIISLSet product(JNIISLSet set1,JNIISLSet set2) { 
			/***PROTECTED REGION ID(static_isl_set_product) START***/
			/***PROTECTED REGION END***/return JNIISLSet.build(ISLNative.isl_set_product(
set1.getNativePtr()
,
set2.getNativePtr()
)			);
		}
		 /* @generated */
		 public static JNIISLSet intersect(JNIISLSet set1,JNIISLSet set2) { 
			/***PROTECTED REGION ID(static_isl_set_intersect) START***/
			/***PROTECTED REGION END***/return JNIISLSet.build(ISLNative.isl_set_intersect(
set1.getNativePtr()
,
set2.getNativePtr()
)			);
		}
		 /* @generated */
		 public static JNIISLSet substract(JNIISLSet set1,JNIISLSet set2) { 
			/***PROTECTED REGION ID(static_isl_set_subtract) START***/
			/***PROTECTED REGION END***/return JNIISLSet.build(ISLNative.isl_set_subtract(
set1.getNativePtr()
,
set2.getNativePtr()
)			);
		}
		 /* @generated */
		 public static JNIISLSet fromBasicSet(JNIISLBasicSet bset) { 
			/***PROTECTED REGION ID(static_isl_set_from_basic_set) START***/
			/***PROTECTED REGION END***/return JNIISLSet.build(ISLNative.isl_set_from_basic_set(
bset.getNativePtr()
)			);
		}
		 /* @generated */
		 public static String _toString(JNIISLContext ctx,JNIISLSet set,int format) { 
			/***PROTECTED REGION ID(static_isl_set_to_string) START***/
			/***PROTECTED REGION END***/return ISLNative.isl_set_to_string(
ctx.getNativePtr()
,
set.getNativePtr()
,format			);
		}
	

		/***PROTECTED REGION ID(isl_set_lifting) START***/
			
			/* @generated */
			public JNIISLMap isEqualFast() { return JNIISLMap.build(ISLNative.isl_set_lifting(this.getNativePtr())					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_get_space) START***/
			
			/* @generated */
			public JNIISLSpace getSpace() { return JNIISLSpace.build(ISLNative.isl_set_get_space(this.getNativePtr())					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_n_dim) START***/
			
			/* @generated */
			public long getNDim() { return ISLNative.isl_set_n_dim(this.getNativePtr()					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_n_param) START***/
			
			/* @generated */
			public long getNParam() { return ISLNative.isl_set_n_param(this.getNativePtr()					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_fix_si) START***/
			
			/* @generated */
			public JNIISLSet islSetFixSi(JNIISLDimType type,long pos,int value) { return JNIISLSet.build(ISLNative.isl_set_fix_si(this.getNativePtr(),
type.getValue()
,pos,value)					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_lower_bound_si) START***/
			
			/* @generated */
			public JNIISLSet islSetLowerBoundSi(JNIISLDimType type,long pos,int value) { return JNIISLSet.build(ISLNative.isl_set_lower_bound_si(this.getNativePtr(),
type.getValue()
,pos,value)					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_from_underlying_set) START***/
			
			/* @generated */
			public JNIISLSet islSetFromUnderlyingSet(JNIISLBasicSet like) { return JNIISLSet.build(ISLNative.isl_set_from_underlying_set(this.getNativePtr(),
like.getNativePtr()
)					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_to_underlying_set) START***/
			
			/* @generated */
			public JNIISLSet islSetToUnderlyingSet() { return JNIISLSet.build(ISLNative.isl_set_to_underlying_set(this.getNativePtr())					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_partial_lexmin) START***/
			
			/* @generated */
			public JNIISLSet partialLexMin(JNIISLSet dom,JNIPtrJNIISLSet empty) { return JNIISLSet.build(ISLNative.isl_set_partial_lexmin(this.getNativePtr(),
dom.getNativePtr()
,
empty.getNativePtr()
)					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_partial_lexmax) START***/
			
			/* @generated */
			public JNIISLSet partialLexMax(JNIISLSet dom,JNIPtrJNIISLSet empty) { return JNIISLSet.build(ISLNative.isl_set_partial_lexmax(this.getNativePtr(),
dom.getNativePtr()
,
empty.getNativePtr()
)					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_lexmin) START***/
			
			/* @generated */
			public JNIISLSet lexMin() { return JNIISLSet.build(ISLNative.isl_set_lexmin(this.getNativePtr())					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_lexmax) START***/
			
			/* @generated */
			public JNIISLSet lexMax() { return JNIISLSet.build(ISLNative.isl_set_lexmax(this.getNativePtr())					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_follows_at) START***/
			
			/* @generated */
			public int islSetFollowsAt(JNIISLSet set2,int pos) { return ISLNative.isl_set_follows_at(this.getNativePtr(),
set2.getNativePtr()
,pos					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_extend) START***/
			
			/* @generated */
			public JNIISLSet extend(long nparam,long dim) { return JNIISLSet.build(ISLNative.isl_set_extend(this.getNativePtr(),nparam,dim)					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_add_basic_set) START***/
			
			/* @generated */
			public JNIISLSet addBasicSet(JNIISLBasicSet bset) { return JNIISLSet.build(ISLNative.isl_set_add_basic_set(this.getNativePtr(),
bset.getNativePtr()
)					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_finalize) START***/
			
			/* @generated */
			public JNIISLSet islSetFinalize() { return JNIISLSet.build(ISLNative.isl_set_finalize(this.getNativePtr())					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_copy) START***/
			
			/* @generated */
			public JNIISLSet copy() { return JNIISLSet.build(ISLNative.isl_set_copy(this.getNativePtr())					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_free) START***/
			
			/* @generated */
			public void free() { ISLNative.isl_set_free(this.getNativePtr()					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_dup) START***/
			
			/* @generated */
			public JNIISLSet islSetDup() { return JNIISLSet.build(ISLNative.isl_set_dup(this.getNativePtr())					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_sample) START***/
			
			/* @generated */
			public JNIISLBasicSet sample() { return JNIISLBasicSet.build(ISLNative.isl_set_sample(this.getNativePtr())					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_sample_point) START***/
			
			/* @generated */
			public JNIISLPoint samplePoint() { return JNIISLPoint.build(ISLNative.isl_set_sample_point(this.getNativePtr())					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_detect_equalities) START***/
			
			/* @generated */
			public JNIISLSet detectEqualities() { return JNIISLSet.build(ISLNative.isl_set_detect_equalities(this.getNativePtr())					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_affine_hull) START***/
			
			/* @generated */
			public JNIISLBasicSet affineHull() { return JNIISLBasicSet.build(ISLNative.isl_set_affine_hull(this.getNativePtr())					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_convex_hull) START***/
			
			/* @generated */
			public JNIISLBasicSet convexHull() { return JNIISLBasicSet.build(ISLNative.isl_set_convex_hull(this.getNativePtr())					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_simple_hull) START***/
			
			/* @generated */
			public JNIISLBasicSet simpleHull() { return JNIISLBasicSet.build(ISLNative.isl_set_simple_hull(this.getNativePtr())					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_polyhedral_hull) START***/
			
			/* @generated */
			public JNIISLBasicSet polyhedralHull() { return JNIISLBasicSet.build(ISLNative.isl_set_polyhedral_hull(this.getNativePtr())					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_bounded_simple_hull) START***/
			
			/* @generated */
			public JNIISLBasicSet boundedSimpleHull() { return JNIISLBasicSet.build(ISLNative.isl_set_bounded_simple_hull(this.getNativePtr())					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_complement) START***/
			
			/* @generated */
			public JNIISLSet complement() { return JNIISLSet.build(ISLNative.isl_set_complement(this.getNativePtr())					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_apply) START***/
			
			/* @generated */
			public JNIISLSet apply(JNIISLMap map) { return JNIISLSet.build(ISLNative.isl_set_apply(this.getNativePtr(),
map.getNativePtr()
)					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_fix_dim_si) START***/
			
			/* @generated */
			public JNIISLSet fixDimSi(long dim,int value) { return JNIISLSet.build(ISLNative.isl_set_fix_dim_si(this.getNativePtr(),dim,value)					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_move_dims) START***/
			
			/* @generated */
			public JNIISLSet moveDims(JNIISLDimType dst_type,long dst_pos,JNIISLDimType src_type,long src_pos,long n) { return JNIISLSet.build(ISLNative.isl_set_move_dims(this.getNativePtr(),
dst_type.getValue()
,dst_pos,
src_type.getValue()
,src_pos,n)					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_project_out) START***/
			
			/* @generated */
			public JNIISLSet projectOut(JNIISLDimType type,long first,long n) { return JNIISLSet.build(ISLNative.isl_set_project_out(this.getNativePtr(),
type.getValue()
,first,n)					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_insert_dims) START***/
			
			/* @generated */
			public JNIISLSet insertDim(JNIISLDimType type,long pos,long n) { return JNIISLSet.build(ISLNative.isl_set_insert_dims(this.getNativePtr(),
type.getValue()
,pos,n)					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_eliminate_dims) START***/
			
			/* @generated */
			public JNIISLSet eliminateDims(long first,long n) { return JNIISLSet.build(ISLNative.isl_set_eliminate_dims(this.getNativePtr(),first,n)					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_remove_divs) START***/
			
			/* @generated */
			public JNIISLSet removeDivs() { return JNIISLSet.build(ISLNative.isl_set_remove_divs(this.getNativePtr())					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_fast_is_empty) START***/
			
			/* @generated */
			public int isEmpty_fast() { return ISLNative.isl_set_fast_is_empty(this.getNativePtr()					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_fast_is_universe) START***/
			
			/* @generated */
			public int isUniverse_fast() { return ISLNative.isl_set_fast_is_universe(this.getNativePtr()					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_is_empty) START***/
			
			/* @generated */
			public int isEmpty() { return ISLNative.isl_set_is_empty(this.getNativePtr()					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_is_subset) START***/
			
			/* @generated */
			public int isSubset(JNIISLSet set2) { return ISLNative.isl_set_is_subset(this.getNativePtr(),
set2.getNativePtr()
					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_is_strict_subset) START***/
			
			/* @generated */
			public int isStrictSubset(JNIISLSet set2) { return ISLNative.isl_set_is_strict_subset(this.getNativePtr(),
set2.getNativePtr()
					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_is_equal) START***/
			
			/* @generated */
			public int isEqual(JNIISLSet set2) { return ISLNative.isl_set_is_equal(this.getNativePtr(),
set2.getNativePtr()
					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_make_disjoint) START***/
			
			/* @generated */
			public JNIISLSet makeDisjoint() { return JNIISLSet.build(ISLNative.isl_set_make_disjoint(this.getNativePtr())					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_align_divs) START***/
			
			/* @generated */
			public JNIISLSet alignDivs() { return JNIISLSet.build(ISLNative.isl_set_align_divs(this.getNativePtr())					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_gist) START***/
			
			/* @generated */
			public JNIISLSet gist(JNIISLSet context) { return JNIISLSet.build(ISLNative.isl_set_gist(this.getNativePtr(),
context.getNativePtr()
)					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_coalesce) START***/
			
			/* @generated */
			public JNIISLSet coalesce() { return JNIISLSet.build(ISLNative.isl_set_coalesce(this.getNativePtr())					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_fast_is_equal) START***/
			
			/* @generated */
			public int isEqual_fast(JNIISLSet set2) { return ISLNative.isl_set_fast_is_equal(this.getNativePtr(),
set2.getNativePtr()
					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_fast_is_disjoint) START***/
			
			/* @generated */
			public int isDisjoint_fast(JNIISLSet set2) { return ISLNative.isl_set_fast_is_disjoint(this.getNativePtr(),
set2.getNativePtr()
					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_get_hash) START***/
			
			/* @generated */
			public long getHash() { return ISLNative.isl_set_get_hash(this.getNativePtr()					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_dim_is_unique) START***/
			
			/* @generated */
			public int isUnique(long dim) { return ISLNative.isl_set_dim_is_unique(this.getNativePtr(),dim					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_lift) START***/
			
			/* @generated */
			public JNIISLSet lift() { return JNIISLSet.build(ISLNative.isl_set_lift(this.getNativePtr())					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_size) START***/
			
			/* @generated */
			public int getSize() { return ISLNative.isl_set_size(this.getNativePtr()					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_compute_divs) START***/
			
			/* @generated */
			public JNIISLSet computeDivs() { return JNIISLSet.build(ISLNative.isl_set_compute_divs(this.getNativePtr())					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_get_basic_set_at) START***/
			
			/* @generated */
			public JNIISLBasicSet getBasicSetAt(int pos) { return JNIISLBasicSet.build(ISLNative.isl_set_get_basic_set_at(this.getNativePtr(),pos)					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_numberof_basic_set) START***/
			
			/* @generated */
			public int getNumberOfBasicSet() { return ISLNative.isl_set_numberof_basic_set(this.getNativePtr()					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_set_tuple_name) START***/
			
			/* @generated */
			public JNIISLSet setTupleName(String s) { return JNIISLSet.build(ISLNative.isl_set_set_tuple_name(this.getNativePtr(),s)					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_get_tuple_name) START***/
			
			/* @generated */
			public String getTupleName() { return ISLNative.isl_set_get_tuple_name(this.getNativePtr()					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_numberof_points) START***/
			
			/* @generated */
			public int getNbPoints() { return ISLNative.isl_set_numberof_points(this.getNativePtr()					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_get_point_at) START***/
			
			/* @generated */
			public JNIISLPoint getPointAt(int pos) { return JNIISLPoint.build(ISLNative.isl_set_get_point_at(this.getNativePtr(),pos)					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(lex_next) START***/
			
			/* @generated */
			public JNIISLMap lexNextMap(int nbInnerLoop) { return JNIISLMap.build(ISLNative.lex_next(this.getNativePtr(),nbInnerLoop)					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(lex_next_power) START***/
			
			/* @generated */
			public JNIISLMap lexNextPowerMap(int nbInnerLoop,int power) { return JNIISLMap.build(ISLNative.lex_next_power(this.getNativePtr(),nbInnerLoop,power)					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_unwrap) START***/
			
			/* @generated */
			public JNIISLMap unwrap() { return JNIISLMap.build(ISLNative.isl_set_unwrap(this.getNativePtr())					);
				}
			
		/***PROTECTED REGION END***/
	 

		/***PROTECTED REGION ID(isl_set_flatten) START***/
			
			/* @generated */
			public JNIISLSet flatten() { return JNIISLSet.build(ISLNative.isl_set_flatten(this.getNativePtr())					);
				}
			
		/***PROTECTED REGION END***/
	 
	
		
	public String toString() {
	/***PROTECTED REGION ID(ISLSettoString) START***/
			return ISLPrettyPrinter.asString(this);
	/***PROTECTED REGION END***/
	}
}

